/*
 * Decompiled with CFR 0.152.
 */
package net.daimonin.client3d.editor.util.binpacker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.daimonin.client3d.editor.util.binpacker.Rect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinPacker {
    private int mNumPacked;
    private List<Rect> mRects;
    private List<Rect> mPacks;
    private List<Integer> mRoots;

    public static void main(String[] args) {
        BinPacker packer = new BinPacker();
        ArrayList<Rect> rects = new ArrayList<Rect>();
        rects.add(new Rect("Rect 01", 14, 5));
        rects.add(new Rect("Rect 02", 9, 3));
        rects.add(new Rect("Rect 03", 5, 11));
        rects.add(new Rect("Rect 04", 3, 8));
        rects.add(new Rect("Rect 10", 11, 2));
        rects.add(new Rect("Rect 07", 5, 4));
        rects.add(new Rect("Rect 08", 2, 6));
        rects.add(new Rect("Rect 05", 6, 3));
        rects.add(new Rect("Rect 06", 3, 6));
        rects.add(new Rect("Rect 09", 4, 2));
        rects.add(new Rect("Rect 11", 4, 2));
        int[] dimension = new int[]{1024, 768};
        List<Rect> packsO = packer.packOptimized(rects, false, dimension);
        int i = 0;
        while (i < packsO.size()) {
            System.out.println(packsO.get(i));
            ++i;
        }
    }

    public final List<Rect> packOptimized(List<Rect> rects, boolean rotate) {
        return this.packOptimized(rects, rotate, new int[]{-1, -1});
    }

    public final List<Rect> packOptimized(List<Rect> rects, boolean rotate, int[] dimension) {
        int dw = 0;
        int dh = 0;
        int maxWidth = dimension[0];
        int maxHeight = dimension[1];
        if (maxWidth == -1 && maxHeight == -1) {
            int i = 0;
            while (i < rects.size()) {
                dw += rects.get((int)i).w;
                dh += rects.get((int)i).h;
                ++i;
            }
        } else {
            dw = maxWidth;
            dh = maxHeight;
        }
        int minW = Integer.MAX_VALUE;
        int minH = Integer.MAX_VALUE;
        int maxW = Integer.MIN_VALUE;
        int maxH = Integer.MIN_VALUE;
        int i = 0;
        while (i < rects.size()) {
            if (rects.get((int)i).w < minW) {
                minW = rects.get((int)i).w;
            }
            if (rects.get((int)i).h < minH) {
                minH = rects.get((int)i).h;
            }
            if (rects.get((int)i).w > maxW) {
                maxW = rects.get((int)i).w;
            }
            if (rects.get((int)i).h > maxH) {
                maxH = rects.get((int)i).h;
            }
            ++i;
        }
        ArrayList<List<Rect>> packs = this.pack(rects, dw, dh, rotate, false);
        if (packs.size() != 1) {
            if (maxWidth == -1 && maxHeight == -1) {
                throw new RuntimeException("Optimization method needs to get rewritten!!!");
            }
            throw new RuntimeException("The given rectangles could not be packed in an enclosing rectangle width these dimensions (" + maxWidth + "x" + maxHeight + ").");
        }
        List<Rect> pack = packs.get(0);
        dw = Integer.MIN_VALUE;
        dh = Integer.MIN_VALUE;
        int i2 = 0;
        while (i2 < pack.size()) {
            if (pack.get((int)i2).x + pack.get((int)i2).w > dw) {
                dw = pack.get((int)i2).x + pack.get((int)i2).w;
            }
            if (pack.get((int)i2).y + pack.get((int)i2).h > dh) {
                dh = pack.get((int)i2).y + pack.get((int)i2).h;
            }
            ++i2;
        }
        int fitsW = dw;
        int fitsH = dh;
        while (dw - minW >= maxW && dh - minH >= maxH) {
            packs = this.pack(rects, dw - minW, dh - minH, rotate, false);
            if (packs.size() != 1) break;
            pack = packs.get(0);
            fitsW = dw -= minW;
            fitsH = dh -= minH;
        }
        while (dw - minW >= maxW) {
            packs = this.pack(rects, dw - minW, dh, rotate, false);
            if (packs.size() != 1) break;
            pack = packs.get(0);
            fitsW = dw -= minW;
        }
        while (dh - minH >= maxH) {
            packs = this.pack(rects, dw, dh - minH, rotate, false);
            if (packs.size() != 1) break;
            pack = packs.get(0);
            fitsH = dh -= minH;
        }
        dimension[0] = fitsW;
        dimension[1] = fitsH;
        return pack;
    }

    public final ArrayList<List<Rect>> pack(List<Rect> rects, int packSizeW, int packSizeH, boolean rotate, boolean printID) {
        this.clear(rects);
        Rect packRect = new Rect("invalid", packSizeW, packSizeH);
        int i = 0;
        while (i < rects.size()) {
            if (!this.fits(rects.get(i), packRect, rotate)) {
                String message = "All rectangle dimensions must be <= the pack size. Rectangle with ID '" + rects.get((int)i).id + "' is too big.";
                throw new RuntimeException(message);
            }
            if (this.mRects.contains(rects.get(i))) {
                String message = "There is more than one rectangle with ID '" + rects.get((int)i).id + "'. This is not allowed, ID's must be unique.";
                throw new RuntimeException(message);
            }
            this.mRects.add(rects.get(i));
            ++i;
        }
        this.sortRects();
        while (this.mNumPacked < this.mRects.size()) {
            i = this.mPacks.size();
            this.mPacks.add(new Rect("invalid", packSizeW, packSizeH));
            this.mRoots.add(i);
            this.fill(i, rotate);
        }
        ArrayList<List<Rect>> packs = new ArrayList<List<Rect>>();
        int i2 = 0;
        while (i2 < this.mRoots.size()) {
            packs.add(new ArrayList());
            ++i2;
        }
        i2 = 0;
        while (i2 < this.mRoots.size()) {
            this.addPackToArray(this.mRoots.get(i2), packs.get(i2));
            ++i2;
        }
        if (printID) {
            this.printPackedID(packs);
        }
        return packs;
    }

    private void addPackToArray(int pack, List<Rect> array) {
        assert (this.packIsValid(pack));
        int i = pack;
        if (!"invalid".equals(this.mPacks.get((int)i).id)) {
            Rect myRect = this.getRectByID(this.mPacks.get((int)i).id);
            array.add(new Rect(myRect.id, this.mPacks.get((int)i).x, this.mPacks.get((int)i).y, myRect.w, myRect.h, this.mPacks.get((int)i).rotated, myRect.packed));
            if (!myRect.packed) {
                System.err.println("Rect with ID=" + myRect.id + " was not packed!");
                assert (false);
            }
            if (this.mPacks.get(i).getChildren()[0] != -1) {
                this.addPackToArray(this.mPacks.get(i).getChildren()[0], array);
            }
            if (this.mPacks.get(i).getChildren()[1] != -1) {
                this.addPackToArray(this.mPacks.get(i).getChildren()[1], array);
            }
        }
    }

    private void clear(List<Rect> rects) {
        this.mNumPacked = 0;
        this.mRects = new ArrayList<Rect>();
        this.mPacks = new ArrayList<Rect>();
        this.mRoots = new ArrayList<Integer>();
        this.resetRects(rects);
    }

    private void fill(int pack, boolean allowRotation) {
        assert (this.packIsValid(pack));
        int i = pack;
        int j = 0;
        while (j < this.mRects.size()) {
            if (!this.mRects.get((int)j).packed && this.fits(this.mRects.get(j), this.mPacks.get(i), allowRotation)) {
                ++this.mNumPacked;
                this.split(i, j);
                this.fill(this.mPacks.get(i).getChildren()[0], allowRotation);
                this.fill(this.mPacks.get(i).getChildren()[1], allowRotation);
                return;
            }
            ++j;
        }
    }

    private void split(int pack, int rect) {
        assert (this.packIsValid(pack));
        assert (this.rectIsValid(rect));
        int i = pack;
        int j = rect;
        Rect left = new Rect(this.mPacks.get(i));
        Rect right = new Rect(this.mPacks.get(i));
        Rect bottom = new Rect(this.mPacks.get(i));
        Rect top = new Rect(this.mPacks.get(i));
        left.y += this.mRects.get((int)j).h;
        left.w = this.mRects.get((int)j).w;
        left.h -= this.mRects.get((int)j).h;
        right.x += this.mRects.get((int)j).w;
        right.w -= this.mRects.get((int)j).w;
        bottom.x += this.mRects.get((int)j).w;
        bottom.h = this.mRects.get((int)j).h;
        bottom.w -= this.mRects.get((int)j).w;
        top.y += this.mRects.get((int)j).h;
        top.h -= this.mRects.get((int)j).h;
        int maxLeftRightArea = left.getArea();
        if (right.getArea() > maxLeftRightArea) {
            maxLeftRightArea = right.getArea();
        }
        int maxBottomTopArea = bottom.getArea();
        if (top.getArea() > maxBottomTopArea) {
            maxBottomTopArea = top.getArea();
        }
        if (maxLeftRightArea > maxBottomTopArea) {
            if (left.getArea() > right.getArea()) {
                this.mPacks.add(left);
                this.mPacks.add(right);
            } else {
                this.mPacks.add(right);
                this.mPacks.add(left);
            }
        } else if (bottom.getArea() > top.getArea()) {
            this.mPacks.add(bottom);
            this.mPacks.add(top);
        } else {
            this.mPacks.add(top);
            this.mPacks.add(bottom);
        }
        this.mPacks.get((int)i).w = this.mRects.get((int)j).w;
        this.mPacks.get((int)i).h = this.mRects.get((int)j).h;
        this.mPacks.get((int)i).id = this.mRects.get((int)j).id;
        this.mPacks.get((int)i).rotated = this.mRects.get((int)j).rotated;
        this.mPacks.get(i).setChildren(this.mPacks.size() - 2, this.mPacks.size() - 1);
        this.mRects.get((int)j).packed = true;
    }

    private boolean fits(Rect rect1, Rect rect2, boolean allowRotation) {
        if (rect1.w <= rect2.w && rect1.h <= rect2.h) {
            return true;
        }
        if (allowRotation && rect1.h <= rect2.w && rect1.w <= rect2.h) {
            rect1.rotate();
            return true;
        }
        return false;
    }

    private boolean rectIsValid(int i) {
        return i >= 0 && i < this.mRects.size();
    }

    private boolean packIsValid(int i) {
        return i >= 0 && i < this.mPacks.size();
    }

    private void sortRects() {
        assert (this.mRects.size() > 0);
        Object[] sorts = this.mRects.toArray(new Rect[this.mRects.size()]);
        Arrays.sort(sorts);
        int i = sorts.length - 1;
        while (i >= 0) {
            this.mRects.set(i, (Rect)sorts[sorts.length - 1 - i]);
            --i;
        }
    }

    private Rect getRectByID(String id) {
        ArrayList<Rect> found = new ArrayList<Rect>();
        int i = 0;
        while (i < this.mRects.size()) {
            if (this.mRects.get((int)i).id.equals(id)) {
                found.add(this.mRects.get(i));
            }
            ++i;
        }
        if (found.size() > 1) {
            System.err.println("More than one rect with ID '" + id + "' found!");
            assert (false);
            return null;
        }
        if (found.size() == 0) {
            return null;
        }
        return (Rect)found.get(0);
    }

    private void printPackedID(ArrayList<List<Rect>> packs) {
        int id = 0;
        List<Rect> aPack = packs.get(0);
        int i = 0;
        while (i < aPack.size()) {
            id += (aPack.get((int)i).x + aPack.get((int)i).y * 2) * i;
            ++i;
        }
        System.out.println("PackedID of pack 1 is " + id);
    }

    private void resetRects(List<Rect> rects) {
        int i = 0;
        while (i < rects.size()) {
            rects.get((int)i).x = 0;
            rects.get((int)i).y = 0;
            rects.get((int)i).packed = false;
            rects.get((int)i).rotated = false;
            rects.get(i).setChildren(-1, -1);
            ++i;
        }
    }
}

