/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller;

import com.izforge.izpack.util.OsVersion;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelfModifier {
    public static final String BASE_KEY = "self.mod.base";
    public static final String JAR_KEY = "self.mod.jar";
    public static final String CLASS_KEY = "self.mod.class";
    public static final String METHOD_KEY = "self.mod.method";
    public static final String PHASE_KEY = "self.mod.phase";
    public static final String MEMORY_KEY = "self.memory";
    private String prefix = "izpack";
    private Method method = null;
    private File logFile = null;
    private File sandbox = null;
    private File jarFile = null;
    private int phase = 0;
    private SimpleDateFormat isoPoint = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private Date date = new Date();
    private long maxmemory = 64L;
    private long maxpermgensize = 16L;
    private boolean useMemorySettings = false;
    PrintStream log = null;
    private static final float JAVA_SPECIFICATION_VERSION = Float.parseFloat(System.getProperty("java.specification.version"));
    private static final String JAVA_HOME = System.getProperty("java.home");

    public static void test(String[] stringArray) {
        try {
            File file = new File(System.getProperty(BASE_KEY) + ".d");
            File file2 = new File(file, "RandomAccess.tmp");
            RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
            randomAccessFile.writeChars("Just a test: The jvm has to close 'cuz I won't!\n");
            System.err.print("Deleting sandbox: ");
            SelfModifier.deleteTree(file);
            System.err.println(file.exists() ? "FAILED" : "SUCCEEDED");
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            SelfModifier selfModifier = new SelfModifier();
            if (selfModifier.phase == 2) {
                selfModifier.invoke2(stringArray);
            } else if (selfModifier.phase == 3) {
                selfModifier.invoke3(stringArray);
            }
        }
        catch (IOException iOException) {
            System.err.println("Error invoking a secondary phase");
            System.err.println("Note that this program is only intended as a secondary process");
            iOException.printStackTrace();
        }
    }

    private SelfModifier() throws IOException {
        this.phase = Integer.parseInt(System.getProperty(PHASE_KEY));
        String string = System.getProperty(CLASS_KEY);
        String string2 = System.getProperty(METHOD_KEY);
        this.jarFile = new File(System.getProperty(JAR_KEY));
        this.logFile = new File(System.getProperty(BASE_KEY) + ".log");
        this.sandbox = new File(System.getProperty(BASE_KEY) + ".d");
        this.maxmemory = Long.parseLong(System.getProperty(MEMORY_KEY, "64"));
        this.maxpermgensize = this.maxmemory / 4L;
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod(string2, String[].class);
            this.initMethod(method);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log("No class found for " + string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.log("No method " + string2 + " found in " + string);
        }
    }

    public SelfModifier(Method method) throws IOException {
        this.phase = 1;
        this.initJavaExec();
        this.initMethod(method);
    }

    public SelfModifier(Method method, long l, long l2) throws IOException {
        this(method);
        this.maxmemory = l;
        this.maxpermgensize = l2;
        this.useMemorySettings = true;
    }

    private void initMethod(Method method) {
        int n = method.getModifiers();
        if ((n & 1) == 0 || (n & 8) == 0) {
            throw new IllegalArgumentException("Method not public and static");
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1 || !classArray[0].isArray() || !"java.lang.String".equals(classArray[0].getComponentType().getName())) {
            throw new IllegalArgumentException("Method must accept String array");
        }
        Class<?> clazz = method.getDeclaringClass();
        n = clazz.getModifiers();
        if ((n & 1) == 0 || (n & 0x200) != 0) {
            throw new IllegalArgumentException("Method must be in a public class");
        }
        this.method = method;
    }

    private void initJavaExec() throws IOException {
        try {
            Process process = Runtime.getRuntime().exec(SelfModifier.javaCommand());
            new StreamProxy(process.getErrorStream(), "err").start();
            new StreamProxy(process.getInputStream(), "out").start();
            process.getOutputStream().close();
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Unable to create a java subprocess");
        }
    }

    public void invoke(String[] stringArray) throws IOException {
        while (true) {
            this.logFile = File.createTempFile(this.prefix, ".log");
            String string = this.logFile.toString();
            this.sandbox = new File(string.substring(0, string.length() - 4) + ".d");
            if (!this.sandbox.exists()) break;
            this.logFile.delete();
        }
        if (!this.sandbox.mkdir()) {
            throw new RuntimeException("Failed to create temp dir: " + this.sandbox);
        }
        this.sandbox = this.sandbox.getCanonicalFile();
        this.logFile = this.logFile.getCanonicalFile();
        this.jarFile = SelfModifier.findJarFile(this.method.getDeclaringClass()).getCanonicalFile();
        if (this.jarFile == null) {
            throw new IllegalStateException("SelfModifier must be in a jar file");
        }
        this.log("JarFile: " + this.jarFile);
        this.extractJarFile();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        this.spawn(stringArray, 2);
        this.log("Exit");
        System.exit(0);
    }

    private Process spawn(String[] stringArray, int n) throws IOException {
        String string = this.logFile.getAbsolutePath();
        string = string.substring(0, string.length() - 4);
        String string2 = SelfModifier.javaCommand();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        arrayList.add("-Xmx" + this.maxmemory + "m");
        arrayList.add("-XX:MaxPermSize=" + this.maxpermgensize + "m");
        arrayList.add("-classpath");
        arrayList.add(this.sandbox.getAbsolutePath());
        arrayList.add("-Dself.mod.base=" + string);
        arrayList.add("-Dself.mod.jar=" + this.jarFile.getPath() + "");
        arrayList.add("-Dself.mod.class=" + this.method.getDeclaringClass().getName());
        arrayList.add("-Dself.mod.method=" + this.method.getName());
        arrayList.add("-Dself.mod.phase=" + n);
        arrayList.add("-Dself.memory=" + this.maxmemory);
        arrayList.add(this.getClass().getName());
        for (String string3 : stringArray) {
            arrayList.add(string3);
        }
        StringBuffer stringBuffer = new StringBuffer("Spawning phase ");
        stringBuffer.append(n).append(": ");
        for (String string4 : arrayList) {
            stringBuffer.append("\n\t").append(string4);
        }
        this.log(stringBuffer.toString());
        return Runtime.getRuntime().exec(arrayList.toArray(new String[arrayList.size()]), null, null);
    }

    public static File findJarFile(Class<?> clazz) {
        String string = clazz.getName().replace('.', '/') + ".class";
        URL uRL = ClassLoader.getSystemResource(string);
        if (!"jar".equals(uRL.getProtocol())) {
            return null;
        }
        String string2 = uRL.getFile();
        string2 = string2.substring(0, string2.lastIndexOf(33));
        File file = (double)JAVA_SPECIFICATION_VERSION < 1.4 ? new File(SelfModifier.fromURI(string2)) : new File(URI.create(string2));
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractJarFile() throws IOException {
        byte[] byArray = new byte[5120];
        int n = 0;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        String string = "META-INF/MANIFEST.MF";
        JarFile jarFile = new JarFile(this.jarFile, true);
        try {
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                int n2;
                String string2;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || string.equals((string2 = zipEntry.getName()).toUpperCase())) continue;
                inputStream = jarFile.getInputStream(zipEntry);
                File file = new File(this.sandbox, string2);
                File file2 = file.getParentFile();
                if (file2 != null && !file2.exists()) {
                    file2.mkdirs();
                }
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                while ((n2 = inputStream.read(byArray, 0, byArray.length)) > 0) {
                    outputStream.write(byArray, 0, n2);
                }
                outputStream.close();
                ++n;
            }
            jarFile.close();
            this.log("Extracted " + n + " file" + (n > 1 ? "s" : "") + " into " + this.sandbox.getPath());
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {}
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void invoke2(String[] stringArray) {
        int n = -1;
        try {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Process process = this.spawn(stringArray, 3);
            new StreamProxy(process.getErrorStream(), "err", this.log).start();
            new StreamProxy(process.getInputStream(), "out", this.log).start();
            process.getOutputStream().close();
            try {
                n = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                this.log(interruptedException);
            }
            this.log("deleteing sandbox");
            SelfModifier.deleteTree(this.sandbox);
        }
        catch (Exception exception) {
            this.log(exception);
        }
        this.log("Phase 3 return value = " + n);
    }

    public static boolean deleteTree(File file) {
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                SelfModifier.deleteTree(file2);
            }
        }
        return file.delete();
    }

    private void invoke3(String[] stringArray) {
        try {
            this.errlog("Invoking method: " + this.method.getDeclaringClass().getName() + "." + this.method.getName() + "(String[] args)");
            this.method.invoke(null, new Object[]{stringArray});
        }
        catch (Throwable throwable) {
            this.errlog(throwable.getMessage());
            throwable.printStackTrace();
            this.errlog("exiting");
            System.err.flush();
            System.exit(31);
        }
        this.errlog("Method returned, waiting for other threads");
        System.err.flush();
    }

    private void errlog(String string) {
        this.date.setTime(System.currentTimeMillis());
        System.err.println(this.isoPoint.format(this.date) + " Phase " + this.phase + ": " + string);
    }

    private PrintStream checkLog() {
        try {
            if (this.log == null) {
                this.log = new PrintStream(new FileOutputStream(this.logFile.toString(), true));
            }
        }
        catch (IOException iOException) {
            System.err.println("Phase " + this.phase + " log err: " + iOException.getMessage());
            iOException.printStackTrace();
        }
        this.date.setTime(System.currentTimeMillis());
        return this.log;
    }

    private void log(Throwable throwable) {
        if (this.checkLog() != null) {
            this.log.println(this.isoPoint.format(this.date) + " Phase " + this.phase + ": " + throwable.getMessage());
            throwable.printStackTrace(this.log);
        }
    }

    private void log(String string) {
        if (this.checkLog() != null) {
            this.log.println(this.isoPoint.format(this.date) + " Phase " + this.phase + ": " + string);
        }
    }

    public static String fromURI(String string) {
        if (!string.startsWith("file:")) {
            throw new IllegalArgumentException("Can only handle file: URIs");
        }
        string = string.startsWith("file://") ? string.substring(7) : string.substring(5);
        string = string.replace('/', File.separatorChar);
        if (File.pathSeparatorChar == ';' && string.startsWith("\\") && string.length() > 2 && Character.isLetter(string.charAt(1)) && string.lastIndexOf(58) > -1) {
            string = string.substring(1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '%') {
                char c2 = stringCharacterIterator.next();
                if (c2 != '\uffff') {
                    int n = Character.digit(c2, 16);
                    char c3 = stringCharacterIterator.next();
                    if (c3 != '\uffff') {
                        int n2 = Character.digit(c3, 16);
                        stringBuffer.append((char)((n << 4) + n2));
                    }
                }
            } else {
                stringBuffer.append(c);
            }
            c = stringCharacterIterator.next();
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    private static String addExtension(String string) {
        return string + (OsVersion.IS_WINDOWS || OsVersion.IS_OS2 ? ".exe" : "");
    }

    private static String javaCommand() {
        String string = SelfModifier.addExtension("java");
        String string2 = new File(JAVA_HOME + "/bin").getAbsolutePath();
        File file = new File(string2, string);
        if (!file.exists()) {
            return string;
        }
        return file.getAbsolutePath();
    }

    public static class StreamProxy
    extends Thread {
        InputStream in;
        String name;
        OutputStream out;

        public StreamProxy(InputStream inputStream, String string) {
            this(inputStream, string, null);
        }

        public StreamProxy(InputStream inputStream, String string, OutputStream outputStream) {
            this.in = inputStream;
            this.name = string;
            this.out = outputStream;
        }

        public void run() {
            try {
                String string;
                PrintWriter printWriter = null;
                if (this.out != null) {
                    printWriter = new PrintWriter(this.out);
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.in));
                while ((string = bufferedReader.readLine()) != null) {
                    if (printWriter == null) continue;
                    printWriter.println(string);
                }
                if (printWriter != null) {
                    printWriter.flush();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

