/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import megamek.common.Compute;
import megamek.common.Coords;

public class Minefield
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1556863068173491352L;
    public static final int TYPE_CONVENTIONAL = 0;
    public static final int TYPE_COMMAND_DETONATED = 1;
    public static final int TYPE_VIBRABOMB = 2;
    public static final int TYPE_ACTIVE = 3;
    public static final int TYPE_EMP = 4;
    public static final int TYPE_INFERNO = 5;
    public static final int TRIGGER_NONE = 0;
    public static final int CLEAR_NUMBER_WEAPON = 5;
    public static final int CLEAR_NUMBER_INFANTRY = 10;
    public static final int CLEAR_NUMBER_INFANTRY_ACCIDENT = 5;
    public static final int[] CLEAR_NUMBER_SWEEPER = new int[]{6, 9};
    public static final int[] CLEAR_NUMBER_SWEEPER_ACCIDENT = new int[]{2, 3};
    public static final int TO_HIT_SIDE = 0;
    public static final int TO_HIT_TABLE = 2;
    public static final int MAX_DAMAGE = 30;
    public static final String IMAGE_FILE = "data/images/hexes/minefieldsign.gif";
    private static String[] names = new String[]{"Conventional", "Command-detonated", "Vibrabomb", "Active", "EMP", "Inferno"};
    public static int TYPE_SIZE = names.length;
    private Coords coords = null;
    private int playerId = -1;
    private int density = 5;
    private int type = -1;
    private int setting = 0;
    private boolean oneUse = false;
    private boolean sea = false;
    private int depth = 0;
    private boolean detonated = false;

    private Minefield() {
    }

    public static Minefield createMinefield(Coords coords, int n, int n2, int n3) {
        return Minefield.createMinefield(coords, n, n2, n3, 0);
    }

    public static Minefield createMinefield(Coords coords, int n, int n2, int n3, boolean bl, int n4) {
        return Minefield.createMinefield(coords, n, n2, n3, 0, bl, n4);
    }

    public static Minefield createMinefield(Coords coords, int n, int n2, int n3, int n4) {
        return Minefield.createMinefield(coords, n, n2, n3, n4, false, 0);
    }

    public static Minefield createMinefield(Coords coords, int n, int n2, int n3, int n4, boolean bl, int n5) {
        Minefield minefield = new Minefield();
        minefield.type = n2;
        minefield.density = n3;
        minefield.coords = coords;
        minefield.playerId = n;
        minefield.setting = n4;
        minefield.sea = bl;
        minefield.depth = n5;
        return minefield;
    }

    public static String getDisplayableName(int n) {
        if (n >= 0 && n < TYPE_SIZE) {
            return names[n];
        }
        throw new IllegalArgumentException("Unknown mine type");
    }

    public Object clone() {
        Minefield minefield = new Minefield();
        minefield.playerId = this.playerId;
        minefield.coords = this.coords;
        minefield.density = this.density;
        minefield.oneUse = this.oneUse;
        minefield.type = this.type;
        minefield.sea = this.sea;
        minefield.depth = this.depth;
        return minefield;
    }

    public boolean equals(Object object) {
        Minefield minefield;
        try {
            minefield = (Minefield)object;
        }
        catch (Exception exception) {
            return false;
        }
        return minefield.playerId == this.playerId && minefield.coords.equals(this.coords) && minefield.type == this.type;
    }

    public void setDensity(int n) {
        this.density = n;
    }

    public Coords getCoords() {
        return this.coords;
    }

    public int getDensity() {
        return this.density;
    }

    public int getTrigger() {
        if (this.density < 15) {
            return 9;
        }
        if (this.density < 25) {
            return 8;
        }
        return 7;
    }

    public boolean isSeaBased() {
        return this.sea;
    }

    public boolean isOneUse() {
        return this.oneUse;
    }

    public int getSetting() {
        return this.setting;
    }

    public int getType() {
        return this.type;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getName() {
        return names[this.getType()];
    }

    public int getPlayerId() {
        return this.playerId;
    }

    public void setDetonated(boolean bl) {
        this.detonated = bl;
    }

    public boolean hasDetonated() {
        return this.detonated;
    }

    public void checkReduction(int n, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = Compute.d6(2) + n >= this.getTrigger() || bl && this.getType() != 0 && this.getType() != 5;
        if (this.getType() == 0 && this.getDensity() < 10) {
            bl2 = false;
        }
        if (bl2) {
            this.setDensity(this.getDensity() - 5);
        }
    }
}

