/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.Hashtable;
import megamek.common.ITerrain;
import megamek.common.ITerrainFactory;
import megamek.common.TerrainFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Terrains
implements ITerrainFactory {
    public static final int WOODS = 1;
    public static final int WATER = 2;
    public static final int ROUGH = 3;
    public static final int RUBBLE = 4;
    public static final int JUNGLE = 5;
    public static final int SAND = 6;
    public static final int TUNDRA = 7;
    public static final int MAGMA = 8;
    public static final int FIELDS = 9;
    public static final int INDUSTRIAL = 10;
    public static final int SPACE = 11;
    public static final int PAVEMENT = 12;
    public static final int ROAD = 13;
    public static final int SWAMP = 14;
    public static final int MUD = 15;
    public static final int RAPIDS = 16;
    public static final int ICE = 17;
    public static final int SNOW = 18;
    public static final int FIRE = 19;
    public static final int SMOKE = 20;
    public static final int GEYSER = 21;
    public static final int BUILDING = 22;
    public static final int BLDG_CF = 23;
    public static final int BLDG_ELEV = 24;
    public static final int BLDG_BASEMENT = 25;
    public static final int BRIDGE = 26;
    public static final int BRIDGE_CF = 27;
    public static final int BRIDGE_ELEV = 28;
    public static final int FUEL_TANK = 29;
    public static final int FUEL_TANK_CF = 30;
    public static final int FUEL_TANK_ELEV = 31;
    public static final int FUEL_TANK_MAGN = 32;
    public static final int IMPASSABLE = 33;
    public static final int ELEVATOR = 34;
    public static final int FORTIFIED = 35;
    public static final int SCREEN = 36;
    public static final int FLUFF = 37;
    public static final int ARMS = 38;
    public static final int LEGS = 39;
    private static final String[] names = new String[]{"none", "woods", "water", "rough", "rubble", "jungle", "sand", "tundra", "magma", "planted_fields", "heavy_industrial", "space", "pavement", "road", "swamp", "mud", "rapids", "ice", "snow", "fire", "smoke", "geyser", "building", "bldg_cf", "bldg_elev", "bldg_basement", "bridge", "bridge_cf", "bridge_elev", "fuel_tank", "fuel_tank_cf", "fuel_tank_elev", "fuel_tank_magn", "impassable", "elevator", "fortified", "screen", "fluff", "arms", "legs"};
    public static final int SIZE = names.length;
    private static Hashtable<String, Integer> hash;
    private static ITerrainFactory factory;

    public static String getName(int n) {
        return names[n];
    }

    public static String getDisplayName(int n, int n2) {
        switch (n) {
            case 1: {
                if (n2 == 1) {
                    return "light woods";
                }
                if (n2 == 2) {
                    return "heavy woods";
                }
                if (n2 == 3) {
                    return "ultra-heavy woods";
                }
                return "woods (unknown)";
            }
            case 3: {
                if (n2 == 1) {
                    return "rough";
                }
                if (n2 == 2) {
                    return "ultra rough";
                }
                return "rough (unknown)";
            }
            case 4: {
                if (n2 < 6) {
                    return "rubble";
                }
                if (n2 > 5) {
                    return "ultra rubble";
                }
                return "rubble (unknown)";
            }
            case 2: {
                return "water (depth " + n2 + ")";
            }
            case 12: {
                return "pavement";
            }
            case 13: {
                return "road";
            }
            case 19: {
                if (n2 == 1) {
                    return "fire";
                }
                if (n2 == 2) {
                    return "inferno fire";
                }
                return "fire (unknown)";
            }
            case 20: {
                if (n2 == 1) {
                    return "light smoke";
                }
                if (n2 == 2) {
                    return "heavy smoke";
                }
                return "smoke (unknown)";
            }
            case 14: {
                if (n2 == 1) {
                    return "swamp";
                }
                if (n2 == 2 || n2 == 3) {
                    return "quicksand";
                }
                return "swamp";
            }
            case 17: {
                return "ice";
            }
            case 35: {
                return "improved position";
            }
            case 21: {
                if (n2 == 1) {
                    return "dormant";
                }
                if (n2 == 2) {
                    return "active";
                }
                if (n2 == 3) {
                    return "magma vent";
                }
                return "geyser (unknown)";
            }
            case 5: {
                if (n2 == 1) {
                    return "light jungle";
                }
                if (n2 == 2) {
                    return "heavy jungle";
                }
                if (n2 == 3) {
                    return "ultra-heavy jungle";
                }
                return "jungle (unknown)";
            }
            case 8: {
                if (n2 == 1) {
                    return "magma crust";
                }
                if (n2 == 2) {
                    return "magma liquid";
                }
                return "magma (unknown)";
            }
            case 15: {
                return "mud";
            }
            case 16: {
                if (n2 == 1) {
                    return "rapids";
                }
                if (n2 == 2) {
                    return "torrent";
                }
                return "rapids (unknown)";
            }
            case 6: {
                return "sand";
            }
            case 18: {
                if (n2 == 1) {
                    return "thin snow";
                }
                if (n2 == 2) {
                    return "heavy snow";
                }
                return "snow (unknown)";
            }
            case 7: {
                return "tundra";
            }
            case 11: {
                return "space";
            }
            case 36: {
                return "screen";
            }
            case 9: {
                return "planted fields";
            }
            case 10: {
                return "heavy industrial zone (height " + n2 + ")";
            }
            case 33: {
                return "impassable terrain";
            }
            case 34: {
                return "elevator";
            }
        }
        return null;
    }

    public static int getType(String string) {
        Integer n = Terrains.getHash().get(string);
        if (n instanceof Integer) {
            return n;
        }
        return 0;
    }

    public static ITerrainFactory getTerrainFactory() {
        if (factory == null) {
            factory = new TerrainFactory();
        }
        return factory;
    }

    protected static Hashtable<String, Integer> getHash() {
        if (hash == null) {
            hash = new Hashtable(SIZE);
            for (int i = 0; i < names.length; ++i) {
                hash.put(names[i], new Integer(i));
            }
        }
        return hash;
    }

    @Override
    public ITerrain createTerrain(int n, int n2) {
        return Terrains.getTerrainFactory().createTerrain(n, n2);
    }

    @Override
    public ITerrain createTerrain(int n, int n2, boolean bl, int n3) {
        return Terrains.getTerrainFactory().createTerrain(n, n2, bl, n3);
    }

    @Override
    public ITerrain createTerrain(String string) {
        return Terrains.getTerrainFactory().createTerrain(string);
    }

    @Override
    public ITerrain createTerrain(ITerrain iTerrain) {
        return Terrains.getTerrainFactory().createTerrain(iTerrain);
    }

    public static int getTerrainFactor(int n, int n2) {
        switch (n) {
            case 1: {
                if (n2 == 1) {
                    return 50;
                }
                if (n2 == 2) {
                    return 90;
                }
                if (n2 == 3) {
                    return 130;
                }
                return 50;
            }
            case 3: {
                return 200;
            }
            case 12: {
                return 200;
            }
            case 13: {
                return 150;
            }
            case 17: {
                return 40;
            }
            case 5: {
                if (n2 == 1) {
                    return 50;
                }
                if (n2 == 2) {
                    return 90;
                }
                if (n2 == 3) {
                    return 130;
                }
                return 50;
            }
            case 8: {
                if (n2 == 1) {
                    return 30;
                }
                return 0;
            }
            case 6: {
                return 100;
            }
            case 18: {
                if (n2 == 1) {
                    return 15;
                }
                if (n2 == 2) {
                    return 30;
                }
                return 15;
            }
            case 7: {
                return 70;
            }
            case 9: {
                return 30;
            }
        }
        return 0;
    }
}

