/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import megamek.common.ASFBay;
import megamek.common.Bay;
import megamek.common.EquipmentType;
import megamek.common.HeavyVehicleBay;
import megamek.common.HitData;
import megamek.common.Jumpship;
import megamek.common.LightVehicleBay;
import megamek.common.MechBay;
import megamek.common.Mounted;
import megamek.common.SmallCraftBay;

public class Warship
extends Jumpship
implements Serializable {
    private static final long serialVersionUID = 4650692419224312511L;
    public static final int LOC_NOSE = 0;
    public static final int LOC_FLS = 1;
    public static final int LOC_FRS = 2;
    public static final int LOC_AFT = 3;
    public static final int LOC_ALS = 4;
    public static final int LOC_ARS = 5;
    public static final int LOC_LBS = 6;
    public static final int LOC_RBS = 7;
    protected static String[] LOCATION_ABBRS = new String[]{"NOS", "FLS", "FRS", "AFT", "ALS", "ARS", "LBS", "RBS"};
    protected static String[] LOCATION_NAMES = new String[]{"Nose", "Left Front Side", "Right Front Side", "Aft", "Aft Left Side", "Aft Right Side", "Left Broadsides", "Right Broadsides"};
    private int[] damThresh = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private int[] standard_damage = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private int kf_integrity = 0;
    private int sail_integrity = 0;

    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public int locations() {
        return 8;
    }

    public void setThresh(int n, int n2) {
        this.damThresh[n2] = n;
    }

    public int getThresh(int n) {
        return this.damThresh[n];
    }

    public void autoSetThresh() {
        for (int i = 0; i < this.locations(); ++i) {
            this.initializeThresh(i);
        }
    }

    public void setKFIntegrity(int n) {
        this.kf_integrity = n;
    }

    public int getKFIntegrity() {
        return this.kf_integrity;
    }

    public void setSailIntegrity(int n) {
        this.sail_integrity = n;
    }

    public int getSailIntegrity() {
        return this.sail_integrity;
    }

    public void initializeSailIntegrity() {
        int n = 1 + (int)Math.round((30.0 + (double)this.weight / 20000.0) / 20.0);
        this.setSailIntegrity(n);
    }

    public void initializeKFIntegrity() {
        int n = (int)Math.round(2.0 + 0.4525 * (double)this.weight / 25000.0);
        this.setKFIntegrity(n);
    }

    public boolean canJump() {
        return this.kf_integrity > 0;
    }

    public void initializeThresh(int n) {
        int n2 = (int)Math.ceil((double)this.getArmor(n) / 10.0);
        this.setThresh(n2, n);
    }

    public int getStandardDamage(int n) {
        return this.standard_damage[n];
    }

    public void resetStandardDamage() {
        for (int i = 0; i < this.locations(); ++i) {
            this.standard_damage[i] = 0;
        }
    }

    public void addStandardDamage(int n, HitData hitData) {
        this.standard_damage[hitData.getLocation()] = this.standard_damage[hitData.getLocation()] + n;
    }

    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        int n2 = 11;
        switch (mounted.getLocation()) {
            case 0: {
                n2 = 11;
                break;
            }
            case 2: {
                n2 = 17;
                break;
            }
            case 1: {
                n2 = 16;
                break;
            }
            case 5: {
                n2 = 19;
                break;
            }
            case 4: {
                n2 = 18;
                break;
            }
            case 3: {
                n2 = 22;
                break;
            }
            case 6: {
                n2 = 20;
                break;
            }
            case 7: {
                n2 = 21;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return this.rollArcs(n2);
    }

    public double getCost() {
        double d = 0.0;
        d += (double)(200000.0f + 10.0f * this.weight);
        d += 200000.0;
        d += (double)(5000 * (this.getNCrew() + this.getNPassenger()));
        d += 80000.0;
        d += 100000.0;
        d += (double)(10000 * this.getArcswGuns());
        d += (double)(100000 * this.getSI());
        d += 25000.0;
        d += (double)(100000 * this.getDocks());
        double d2 = (double)((float)this.getOriginalWalkMP() * this.weight) * 0.06;
        d += d2 * 1000.0;
        d += (double)((float)(500 * this.getOriginalWalkMP()) * this.weight) / 100.0;
        d += 1000.0;
        if (this.hasHPG()) {
            d += 1.0E9;
        }
        d += (double)(200 * this.getFuel()) / this.getFuelPerTon();
        d += this.getArmorWeight(this.locations() - 2) * EquipmentType.getArmorCost(this.armorType);
        int n = 2000 + 4000 * this.getHeatType();
        d += (double)(n * this.getHeatSinks());
        double d3 = 0.0;
        d3 += (double)(60000000 + 75000000 * this.getDocks());
        d3 += (double)(25000000 + 5000000 * this.getDocks());
        d3 += 5.0E7;
        d3 += (double)(50000 * this.getKFIntegrity());
        d3 += (double)(50000 * Math.round(30.0f + this.weight / 20000.0f));
        d3 += (double)(500000 + 200000 * this.getDocks());
        d3 *= 5.0;
        if (this.hasLF()) {
            d3 *= 3.0;
        }
        d += d3;
        d += (double)(5000000 * this.getGravDeck());
        d += (double)(10000000 * this.getGravDeckLarge());
        d += (double)(40000000 * this.getGravDeckHuge());
        d += (double)this.getWeaponsAndEquipmentCost();
        int n2 = 0;
        int n3 = 0;
        for (Bay bay : this.getTransportBays()) {
            n2 += bay.getDoors();
            if (bay instanceof MechBay || bay instanceof ASFBay || bay instanceof SmallCraftBay) {
                n3 += 20000 * bay.totalSpace;
            }
            if (!(bay instanceof LightVehicleBay) && !(bay instanceof HeavyVehicleBay)) continue;
            n3 += 20000 * bay.totalSpace;
        }
        d += (double)(n3 + n2 * 1000);
        double d4 = 2.0;
        return Math.round((d += (double)(5000 * (this.getLifeBoats() + this.getEscapePods()))) * d4);
    }

    public boolean hasActiveECM() {
        if (!this.game.getOptions().booleanOption("stratops_ecm") || !this.game.getBoard().inSpace()) {
            return super.hasActiveECM();
        }
        return this.getECMRange() >= 0;
    }

    public int getECMRange() {
        if (!this.game.getOptions().booleanOption("stratops_ecm") || !this.game.getBoard().inSpace()) {
            return super.getECMRange();
        }
        int n = 2;
        n = n - this.getSensorHits() - this.getCICHits();
        return n;
    }

    public int getAdjacentArcCW(int n) {
        switch (n) {
            case 11: {
                return 17;
            }
            case 16: {
                return 11;
            }
            case 17: {
                return 21;
            }
            case 18: {
                return 20;
            }
            case 19: {
                return 22;
            }
            case 20: {
                return 16;
            }
            case 21: {
                return 19;
            }
            case 22: {
                return 18;
            }
        }
        return Integer.MIN_VALUE;
    }

    public int getAdjacentArcCCW(int n) {
        switch (n) {
            case 11: {
                return 16;
            }
            case 17: {
                return 11;
            }
            case 16: {
                return 20;
            }
            case 18: {
                return 22;
            }
            case 19: {
                return 21;
            }
            case 20: {
                return 18;
            }
            case 21: {
                return 17;
            }
            case 22: {
                return 19;
            }
        }
        return Integer.MIN_VALUE;
    }

    public double getBVTypeModifier() {
        return 0.8;
    }
}

