/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.verifier;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.WeaponType;
import megamek.common.util.StringUtil;
import megamek.common.verifier.Armor;
import megamek.common.verifier.Structure;
import megamek.common.verifier.TestEntity;
import megamek.common.verifier.TestEntityOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMech
extends TestEntity {
    private Mech mech = null;

    public TestMech(Mech mech, TestEntityOption testEntityOption, String string) {
        super(testEntityOption, mech.getEngine(), TestMech.getArmor(mech), TestMech.getStructure(mech));
        this.mech = mech;
        this.fileString = string;
    }

    private static Structure getStructure(Mech mech) {
        int n = mech.getStructureType();
        int n2 = 0;
        if (mech.isClan()) {
            n2 |= 1;
        }
        return new Structure(n, n2);
    }

    private static Armor getArmor(Mech mech) {
        int n = mech.getArmorType();
        int n2 = 0;
        if (mech.isClanArmor()) {
            n2 |= 1;
        }
        return new Armor(n, n2);
    }

    @Override
    public Entity getEntity() {
        return this.mech;
    }

    @Override
    public boolean isTank() {
        return false;
    }

    @Override
    public boolean isMech() {
        return true;
    }

    @Override
    public float getWeightMisc() {
        return 0.0f;
    }

    public float getWeightCockpit() {
        float f = 3.0f;
        if (this.mech.getCockpitType() == 2) {
            f = 2.0f;
        } else if (this.mech.getCockpitType() == 1) {
            f = 4.0f;
        } else if (this.mech.getCockpitType() == 3) {
            f = 6.0f;
        } else if (this.mech.getCockpitType() == 4) {
            f = 3.0f;
        } else if (this.mech.getCockpitType() == 6) {
            f = 5.0f;
        } else if (this.mech.getCockpitType() == 7) {
            f = 5.0f;
        }
        return f;
    }

    public float getWeightGyro() {
        float f = (float)Math.ceil((float)this.engine.getRating() / 100.0f);
        if (this.mech.getGyroType() == 1) {
            f /= 2.0f;
        } else if (this.mech.getGyroType() == 2) {
            f = (float)((double)f * 1.5);
        } else if (this.mech.getGyroType() == 3) {
            f *= 2.0f;
        }
        f = TestMech.ceil(f, this.getWeightCeilingGyro());
        return f;
    }

    @Override
    public float getWeightControls() {
        return this.getWeightCockpit() + this.getWeightGyro();
    }

    @Override
    public int getCountHeatSinks() {
        return this.mech.heatSinks();
    }

    @Override
    public int getWeightHeatSinks() {
        return this.mech.heatSinks() - this.engine.getWeightFreeEngineHeatSinks();
    }

    @Override
    public boolean hasDoubleHeatSinks() {
        return this.mech.heatSinks() != this.mech.getHeatCapacity();
    }

    @Override
    public String printWeightMisc() {
        return "";
    }

    @Override
    public String printWeightControls() {
        StringBuffer stringBuffer = new StringBuffer(StringUtil.makeLength(this.mech.getCockpitTypeString() + ":", this.getPrintSize() - 5));
        stringBuffer.append(TestMech.makeWeightString(this.getWeightCockpit()));
        stringBuffer.append("\n");
        stringBuffer.append(StringUtil.makeLength(this.mech.getGyroTypeString() + ":", this.getPrintSize() - 5));
        stringBuffer.append(TestMech.makeWeightString(this.getWeightGyro()));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public Mech getMech() {
        return this.mech;
    }

    public int countCriticalSlotsFromEquipInLocation(Entity entity, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < entity.getNumberOfCriticals(n2); ++i) {
            CriticalSlot criticalSlot = entity.getCritical(n2, i);
            if (criticalSlot == null || criticalSlot.getType() == 0 || criticalSlot.getType() != 1 || criticalSlot.getIndex() != n) continue;
            ++n3;
        }
        return n3;
    }

    public boolean criticalSlotsAllocated(Entity entity, Mounted mounted, Vector<Serializable> vector) {
        int n;
        int n2 = entity.getEquipmentNum(mounted);
        int n3 = mounted.getLocation();
        EquipmentType equipmentType = mounted.getType();
        int n4 = 0;
        n4 = equipmentType instanceof MiscType ? this.calcMiscCrits((MiscType)equipmentType) : equipmentType.getCriticals(entity);
        int n5 = 0;
        if (n3 == -1) {
            return true;
        }
        if (equipmentType.isSpreadable() && !equipmentType.getName().equals("Targeting Computer")) {
            if (equipmentType instanceof MiscType && equipmentType.hasFlag(65536L)) {
                if (this.countCriticalSlotsFromEquipInLocation(entity, n2, 5) != 2) {
                    return false;
                }
                if (this.countCriticalSlotsFromEquipInLocation(entity, n2, 4) != 2) {
                    return false;
                }
                if (this.countCriticalSlotsFromEquipInLocation(entity, n2, 7) != 2) {
                    return false;
                }
                if (this.countCriticalSlotsFromEquipInLocation(entity, n2, 6) != 2) {
                    return false;
                }
                if (this.countCriticalSlotsFromEquipInLocation(entity, n2, 3) != 2) {
                    return false;
                }
                if (this.countCriticalSlotsFromEquipInLocation(entity, n2, 2) != 2) {
                    return false;
                }
            }
            if (equipmentType instanceof MiscType && equipmentType.hasFlag(0x8000000000L)) {
                for (n = 0; n < entity.locations(); ++n) {
                    if (this.countCriticalSlotsFromEquipInLocation(entity, n2, n) == 1) continue;
                    return false;
                }
            }
            for (n = 0; n < entity.locations(); ++n) {
                n5 += this.countCriticalSlotsFromEquipInLocation(entity, n2, n);
            }
        } else {
            n5 = this.countCriticalSlotsFromEquipInLocation(entity, n2, n3);
        }
        if (equipmentType instanceof WeaponType && mounted.isSplit()) {
            n = 0;
            for (int i = 0; i < entity.locations(); ++i) {
                if (i == n3 || (n = this.countCriticalSlotsFromEquipInLocation(entity, n2, i)) == 0 || n3 != Mech.mostRestrictiveLoc(i, n3)) continue;
                n5 += n;
                break;
            }
        }
        if (n5 == n4) {
            return true;
        }
        vector.addElement(mounted);
        vector.addElement(new Integer(n4));
        vector.addElement(new Integer(n5));
        return false;
    }

    public void checkCriticalSlotsForEquipment(Entity entity, Vector<Mounted> vector, Vector<Serializable> vector2, Vector<Integer> vector3) {
        int n = 0;
        for (Mounted mounted : entity.getEquipment()) {
            if (mounted.getLocation() == -1) {
                if (mounted.getType() instanceof AmmoType && mounted.getShotsLeft() <= 1) continue;
                if (!(mounted.getType() instanceof MiscType)) {
                    vector.addElement(mounted);
                    continue;
                }
                MiscType miscType = (MiscType)mounted.getType();
                if (miscType.hasFlag(1L) || miscType.hasFlag(2L)) {
                    ++n;
                    continue;
                }
                vector.addElement(mounted);
                continue;
            }
            if (this.criticalSlotsAllocated(entity, mounted, vector2)) continue;
        }
        if (n > this.engine.integralHeatSinkCapacity() || n < this.engine.integralHeatSinkCapacity() && n != ((Mech)entity).heatSinks() && !entity.isOmni()) {
            vector3.addElement(new Integer(n));
        }
    }

    public void checkCriticals() {
        Vector<Mounted> vector = new Vector<Mounted>();
        Vector<Serializable> vector2 = new Vector<Serializable>();
        Vector<Integer> vector3 = new Vector<Integer>();
        this.checkCriticalSlotsForEquipment(this.mech, vector, vector2, vector3);
    }

    public boolean correctCriticals(StringBuffer stringBuffer) {
        Vector<Mounted> vector = new Vector<Mounted>();
        Vector<Serializable> vector2 = new Vector<Serializable>();
        Vector<Integer> vector3 = new Vector<Integer>();
        this.checkCriticalSlotsForEquipment(this.mech, vector, vector2, vector3);
        boolean bl = true;
        if (!vector.isEmpty()) {
            stringBuffer.append("Unallocated Equipment:\n");
            for (Mounted mounted : vector) {
                stringBuffer.append(mounted.getType().getInternalName()).append("\n");
            }
            bl = false;
        }
        if (!vector2.isEmpty()) {
            stringBuffer.append("Allocated Equipment:\n");
            Enumeration<Serializable> enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                Mounted mounted;
                mounted = (Mounted)enumeration.nextElement();
                int n = (Integer)enumeration.nextElement();
                int n2 = (Integer)enumeration.nextElement();
                stringBuffer.append(mounted.getType().getInternalName()).append(" has ").append(n).append(" Slots, but ").append(n2).append(" Slots are allocated!").append("\n");
            }
            bl = false;
        }
        if (!vector3.isEmpty()) {
            int n = vector3.elements().nextElement();
            stringBuffer.append(n).append(" of ").append(this.engine.integralHeatSinkCapacity()).append(" possible Internal Heat Sinks!").append("\n");
            bl = false;
        }
        if (!this.checkSystemCriticals(stringBuffer)) {
            bl = false;
        }
        return bl;
    }

    private boolean checkSystemCriticals(StringBuffer stringBuffer) {
        boolean bl = true;
        int n = this.engine.getSideTorsoCriticalSlots().length;
        if (n != this.mech.getNumberOfCriticals(0, 3, 3) || n != this.mech.getNumberOfCriticals(0, 3, 2)) {
            bl = false;
        }
        if (this.engine.getCenterTorsoCriticalSlots(this.mech.getGyroType()).length != this.mech.getNumberOfCriticals(0, 3, 1)) {
            bl = false;
        }
        if (!bl) {
            stringBuffer.append("Engine: Incorrect number of criticals allocated.\n");
        }
        return bl;
    }

    public String printArmorLocProp(int n, int n2) {
        return " is greater then " + Integer.toString(n2) + "!";
    }

    public boolean correctArmor(StringBuffer stringBuffer) {
        boolean bl = true;
        for (int i = 0; i < this.mech.locations(); ++i) {
            if (i == 0) {
                if (this.mech.getOArmor(0) <= 9) continue;
                stringBuffer.append(this.printArmorLocation(0)).append(this.printArmorLocProp(0, 9)).append("\n");
                bl = false;
                continue;
            }
            if (this.mech.getOArmor(i) + (this.mech.hasRearArmor(i) ? this.mech.getOArmor(i, true) : 0) <= 2 * this.mech.getOInternal(i)) continue;
            stringBuffer.append(this.printArmorLocation(i)).append(this.printArmorLocProp(i, 2 * this.mech.getOInternal(i))).append("\n");
            bl = false;
        }
        return bl;
    }

    public boolean correctMovement(StringBuffer stringBuffer) {
        if (this.mech.getJumpMP(false) > this.mech.getOriginalRunMPwithoutMASC() && !this.mech.hasJumpBoosters() && !this.mech.hasWorkingMisc(0x400000000000L, -1L)) {
            stringBuffer.append("Jump MP exceeds run MP\n");
            return false;
        }
        if (this.mech.getJumpMP(false) > this.mech.getOriginalWalkMP() && this.mech.getJumpType() != 2 && !this.mech.hasWorkingMisc(0x400000000000L, -1L)) {
            stringBuffer.append("Jump MP exceeds walk MP without IJJs");
            return false;
        }
        return true;
    }

    @Override
    public boolean correctEntity(StringBuffer stringBuffer) {
        return this.correctEntity(stringBuffer, true);
    }

    @Override
    public boolean correctEntity(StringBuffer stringBuffer, boolean bl) {
        boolean bl2 = true;
        if (this.skip()) {
            return true;
        }
        if (!this.correctWeight(stringBuffer)) {
            stringBuffer.insert(0, this.printTechLevel() + this.printShortMovement());
            stringBuffer.append(this.printWeightCalculation());
            bl2 = false;
        }
        if (!this.engine.engineValid) {
            stringBuffer.append(this.engine.problem.toString()).append("\n\n");
            bl2 = false;
        }
        if (this.getCountHeatSinks() < this.engine.getWeightFreeEngineHeatSinks()) {
            stringBuffer.append("Heat Sinks:\n");
            stringBuffer.append(" Engine    " + this.engine.integralHeatSinkCapacity() + "\n");
            stringBuffer.append(" Total     " + this.getCountHeatSinks() + "\n");
            stringBuffer.append(" Required  " + this.engine.getWeightFreeEngineHeatSinks() + "\n");
            bl2 = false;
        }
        if (this.showCorrectArmor() && !this.correctArmor(stringBuffer)) {
            bl2 = false;
        }
        if (this.showCorrectCritical() && !this.correctCriticals(stringBuffer)) {
            bl2 = false;
        }
        if (this.showFailedEquip() && this.hasFailedEquipment(stringBuffer)) {
            bl2 = false;
        }
        if (this.hasIllegalTechLevels(stringBuffer, bl)) {
            bl2 = false;
        }
        if (this.hasIllegalEquipmentCombinations(stringBuffer)) {
            bl2 = false;
        }
        bl2 = bl2 && this.correctMovement(stringBuffer);
        return bl2;
    }

    @Override
    public StringBuffer printEntity() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Mech: ").append(this.mech.getDisplayName()).append("\n");
        stringBuffer.append("Found in: ").append(this.fileString).append("\n");
        stringBuffer.append(this.printTechLevel());
        stringBuffer.append(this.printShortMovement());
        if (this.correctWeight(stringBuffer, true, true)) {
            stringBuffer.append("Weight: ").append(this.getWeight()).append(" (").append(this.calculateWeight()).append(")\n");
        }
        stringBuffer.append(this.printWeightCalculation()).append("\n");
        stringBuffer.append(this.printArmorPlacement());
        this.correctArmor(stringBuffer);
        stringBuffer.append(this.printLocations());
        this.correctCriticals(stringBuffer);
        this.printFailedEquipment(stringBuffer);
        return stringBuffer;
    }

    @Override
    public String getName() {
        return "Mech: " + this.mech.getDisplayName();
    }

    @Override
    public float getArmoredComponentWeight() {
        float f = 0.0f;
        for (int i = 0; i <= 7; ++i) {
            for (int j = 0; j < this.mech.getNumberOfCriticals(i); ++j) {
                CriticalSlot criticalSlot = this.mech.getCritical(i, j);
                if (criticalSlot == null || !criticalSlot.isArmored()) continue;
                f += 0.5f;
                if (criticalSlot.getType() != 0 || criticalSlot.getIndex() != 2) continue;
                f += 0.5f;
            }
        }
        return f;
    }
}

