/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.AmmoType;
import megamek.common.IGame;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AttackHandler;
import megamek.common.weapons.BarracudaHandler;
import megamek.common.weapons.BarracudaTHandler;
import megamek.common.weapons.CapitalMissileWeapon;
import megamek.server.Server;

public class BarracudaTWeapon
extends CapitalMissileWeapon {
    private static final long serialVersionUID = 8756042527483383101L;

    public BarracudaTWeapon() {
        this.techLevel = 1;
        this.name = "Barracuda-T";
        this.setInternalName(this.name);
        this.addLookupName("BarracudaT");
        this.heat = 10;
        this.damage = 2;
        this.ammoType = 59;
        this.shortRange = 20;
        this.mediumRange = 30;
        this.longRange = 40;
        this.extremeRange = 50;
        this.tonnage = 100.0f;
        this.bv = 461.0;
        this.cost = 100000.0;
        this.atClass = 19;
        this.shortAV = 2.0;
        this.medAV = 2.0;
        this.longAV = 2.0;
        this.extAV = 2.0;
        this.maxRange = 4;
        this.toHitModifier = -2;
    }

    protected AttackHandler getCorrectHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        AmmoType ammoType = (AmmoType)iGame.getEntity(weaponAttackAction.getEntityId()).getEquipment(weaponAttackAction.getWeaponId()).getLinked().getType();
        if (ammoType.hasFlag(1024L)) {
            return new BarracudaTHandler(toHitData, weaponAttackAction, iGame, server);
        }
        return new BarracudaHandler(toHitData, weaponAttackAction, iGame, server);
    }
}

