/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.IOException;
import org.gradle.api.NonNullApi;
import org.gradle.internal.serialize.Decoder;

@NonNullApi
public class DecoderExtensions {
    public static short[] readLengthPrefixedShorts(Decoder decoder) throws IOException {
        int length = decoder.readInt();
        short[] array = new short[length];
        DecoderExtensions.readShorts(decoder, array);
        return array;
    }

    public static void readShorts(Decoder decoder, short[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            array[i] = decoder.readShort();
        }
    }

    public static int[] readLengthPrefixedInts(Decoder decoder) throws IOException {
        int length = decoder.readInt();
        int[] array = new int[length];
        DecoderExtensions.readInts(decoder, array);
        return array;
    }

    public static void readInts(Decoder decoder, int[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            array[i] = decoder.readInt();
        }
    }

    public static long[] readLengthPrefixedLongs(Decoder decoder) throws IOException {
        int length = decoder.readInt();
        long[] array = new long[length];
        DecoderExtensions.readLongs(decoder, array);
        return array;
    }

    public static void readLongs(Decoder decoder, long[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            array[i] = decoder.readLong();
        }
    }

    public static float[] readLengthPrefixedFloats(Decoder decoder) throws IOException {
        int length = decoder.readInt();
        float[] array = new float[length];
        DecoderExtensions.readFloats(decoder, array);
        return array;
    }

    public static void readFloats(Decoder decoder, float[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            array[i] = decoder.readFloat();
        }
    }

    public static double[] readLengthPrefixedDoubles(Decoder decoder) throws IOException {
        int length = decoder.readInt();
        double[] array = new double[length];
        DecoderExtensions.readDoubles(decoder, array);
        return array;
    }

    public static void readDoubles(Decoder decoder, double[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            array[i] = decoder.readDouble();
        }
    }

    public static char[] readLengthPrefixedChars(Decoder decoder) throws IOException {
        int length = decoder.readInt();
        char[] array = new char[length];
        DecoderExtensions.readChars(decoder, array);
        return array;
    }

    public static void readChars(Decoder decoder, char[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            array[i] = (char)decoder.readInt();
        }
    }

    public static boolean[] readLengthPrefixedBooleans(Decoder decoder) throws IOException {
        int length = decoder.readInt();
        boolean[] array = new boolean[length];
        DecoderExtensions.readBooleans(decoder, array);
        return array;
    }

    public static void readBooleans(Decoder decoder, boolean[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            array[i] = decoder.readBoolean();
        }
    }
}

