/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.AbstractProperty;
import org.gradle.api.internal.provider.CollectionPropertyInternal;
import org.gradle.api.internal.provider.CollectionSupplier;
import org.gradle.api.internal.provider.Collector;
import org.gradle.api.internal.provider.Collectors;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValidatingValueCollector;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.HasMultipleValues;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.Pair;
import org.gradle.internal.evaluation.EvaluationScopeContext;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCollectionProperty<T, C extends Collection<T>>
extends AbstractProperty<C, CollectionSupplier<T, C>>
implements CollectionPropertyInternal<T, C> {
    private final Class<? extends Collection> collectionType;
    private final Class<T> elementType;
    private final Supplier<ImmutableCollection.Builder<T>> collectionFactory;
    private final ValueCollector<T> valueCollector;
    private CollectionSupplier<T, C> defaultValue;

    AbstractCollectionProperty(PropertyHost host, Class<? extends Collection> collectionType, Class<T> elementType, Supplier<ImmutableCollection.Builder<T>> collectionFactory) {
        super(host);
        this.collectionType = collectionType;
        this.elementType = elementType;
        this.collectionFactory = collectionFactory;
        this.valueCollector = new ValidatingValueCollector<T>(collectionType, elementType, ValueSanitizers.forType(elementType));
        this.init();
    }

    private void init() {
        this.defaultValue = this.emptySupplier();
        this.init(this.defaultValue, this.noValueSupplier());
    }

    @Override
    protected CollectionSupplier<T, C> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    protected CollectionSupplier<T, C> getDefaultConvention() {
        return this.noValueSupplier();
    }

    private CollectionSupplier<T, C> emptySupplier() {
        return new EmptySupplier();
    }

    private CollectionSupplier<T, C> noValueSupplier() {
        return new NoValueSupplier(ValueSupplier.Value.missing());
    }

    protected abstract C emptyCollection();

    protected Configurer getConfigurer(boolean ignoreAbsent) {
        return new Configurer(ignoreAbsent);
    }

    protected void withActualValue(Action<Configurer> action) {
        this.setToConventionIfUnset();
        action.execute((Object)this.getConfigurer(true));
    }

    @Override
    protected boolean isDefaultConvention() {
        return this.isNoValueSupplier((CollectionSupplier)this.getConventionSupplier());
    }

    private boolean isNoValueSupplier(CollectionSupplier<T, C> valueSupplier) {
        return valueSupplier instanceof NoValueSupplier;
    }

    public void add(T element) {
        this.getConfigurer(false).add(element);
    }

    public void add(Provider<? extends T> providerOfElement) {
        this.getConfigurer(false).add(providerOfElement);
    }

    @SafeVarargs
    public final void addAll(T ... elements) {
        this.getConfigurer(false).addAll(elements);
    }

    public void addAll(Iterable<? extends T> elements) {
        this.getConfigurer(false).addAll(elements);
    }

    public void addAll(Provider<? extends Iterable<? extends T>> provider) {
        this.getConfigurer(false).addAll(provider);
    }

    @Override
    public void append(T element) {
        this.withActualValue((Action<Configurer>)((Action)it -> it.add(element)));
    }

    @Override
    public void append(Provider<? extends T> provider) {
        this.withActualValue((Action<Configurer>)((Action)it -> it.add(provider)));
    }

    @Override
    @SafeVarargs
    public final void appendAll(T ... elements) {
        this.withActualValue((Action<Configurer>)((Action)it -> it.addAll(elements)));
    }

    @Override
    public void appendAll(Iterable<? extends T> elements) {
        this.withActualValue((Action<Configurer>)((Action)it -> it.addAll(elements)));
    }

    @Override
    public void appendAll(Provider<? extends Iterable<? extends T>> provider) {
        this.withActualValue((Action<Configurer>)((Action)it -> it.addAll(provider)));
    }

    @Override
    public int size() {
        return ((Collection)this.calculateOwnPresentValue().getWithoutSideEffect()).size();
    }

    private void addExplicitCollector(Collector<T> collector, boolean ignoreAbsent) {
        this.assertCanMutate();
        CollectionSupplier<T, C> explicitValue = this.getExplicitValue(this.defaultValue);
        this.setSupplier(explicitValue.plus(collector, ignoreAbsent));
    }

    @Override
    @Nonnull
    public Class<C> getType() {
        return (Class)Cast.uncheckedNonnullCast(this.collectionType);
    }

    @Override
    public Class<T> getElementType() {
        return this.elementType;
    }

    public void fromState(ValueSupplier.ExecutionTimeValue<? extends C> value) {
        if (value.isMissing()) {
            this.setSupplier(this.noValueSupplier());
        } else if (value.hasFixedValue()) {
            this.setSupplier(new FixedSupplier(this, (Collection)value.getFixedValue(), (ValueSupplier.SideEffect)Cast.uncheckedCast(value.getSideEffect())));
        } else {
            CollectingSupplier asSupplier = (CollectingSupplier)Cast.uncheckedNonnullCast(value.getChangingValue());
            this.setSupplier(asSupplier);
        }
    }

    @Override
    public void setFromAnyValue(Object object) {
        if (object instanceof Provider) {
            this.set((Provider)Cast.uncheckedCast((Object)object));
        } else {
            if (object != null && !(object instanceof Iterable)) {
                throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using an instance of type %s.", this.collectionType.getName(), object.getClass().getName()));
            }
            this.set((Iterable)Cast.uncheckedCast((Object)object));
        }
    }

    public void set(@javax.annotation.Nullable Iterable<? extends T> elements) {
        if (elements == null) {
            this.unsetValueAndDefault();
        } else {
            this.setSupplier(this.newSupplierOf(new Collectors.ElementsFromCollection<T>(elements)));
        }
    }

    public void set(Provider<? extends Iterable<? extends T>> provider) {
        CollectionPropertyInternal collectionProp;
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the value of a property using a null provider.");
        }
        ProviderInternal<Iterable<T>> p = Providers.internal(provider);
        if (p.getType() != null && !Iterable.class.isAssignableFrom(p.getType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using a provider of type %s.", this.collectionType.getName(), p.getType().getName()));
        }
        if (p instanceof CollectionPropertyInternal && !this.elementType.isAssignableFrom((collectionProp = (CollectionPropertyInternal)Cast.uncheckedCast(p)).getElementType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s with element type %s using a provider with element type %s.", this.collectionType.getName(), this.elementType.getName(), collectionProp.getElementType().getName()));
        }
        this.setSupplier(this.newSupplierOf(new Collectors.ElementsFromCollectionProvider(p)));
    }

    private void unsetValueAndDefault() {
        this.defaultValue = this.noValueSupplier();
        this.unset();
    }

    public HasMultipleValues<T> value(@javax.annotation.Nullable Iterable<? extends T> elements) {
        this.set(elements);
        return this;
    }

    public HasMultipleValues<T> value(Provider<? extends Iterable<? extends T>> provider) {
        this.set(provider);
        return this;
    }

    public HasMultipleValues<T> empty() {
        this.setSupplier(this.emptySupplier());
        return this;
    }

    @Override
    protected ValueSupplier.Value<? extends C> calculateValueFrom(EvaluationScopeContext context, CollectionSupplier<T, C> value, ValueSupplier.ValueConsumer consumer) {
        return value.calculateValue(consumer);
    }

    @Override
    protected CollectionSupplier<T, C> finalValue(EvaluationScopeContext context, CollectionSupplier<T, C> value, ValueSupplier.ValueConsumer consumer) {
        ValueSupplier.Value<C> result = value.calculateValue(consumer);
        if (!result.isMissing()) {
            return new FixedSupplier(this, (Collection)result.getWithoutSideEffect(), (ValueSupplier.SideEffect)Cast.uncheckedCast(result.getSideEffect()));
        }
        if (result.getPathToOrigin().isEmpty()) {
            return this.noValueSupplier();
        }
        return new NoValueSupplier(result);
    }

    @Override
    protected ValueSupplier.ExecutionTimeValue<? extends C> calculateOwnExecutionTimeValue(EvaluationScopeContext context, CollectionSupplier<T, C> value) {
        return value.calculateExecutionTimeValue();
    }

    public HasMultipleValues<T> convention(@javax.annotation.Nullable Iterable<? extends T> elements) {
        if (elements == null) {
            this.unsetConvention();
        } else {
            this.setConvention(this.newSupplierOf(new Collectors.ElementsFromCollection<T>(elements)));
        }
        return this;
    }

    public HasMultipleValues<T> convention(Provider<? extends Iterable<? extends T>> provider) {
        this.setConvention(this.newSupplierOf(new Collectors.ElementsFromCollectionProvider(Providers.internal(provider))));
        return this;
    }

    @Override
    protected String describeContents() {
        String typeDisplayName = this.collectionType.getSimpleName().toLowerCase(Locale.ROOT);
        return String.format("%s(%s, %s)", typeDisplayName, this.elementType, this.describeValue());
    }

    private CollectingSupplier<T, C> newSupplierOf(Collector<T> value) {
        return new CollectingSupplier<T, C>(this.getType(), this.collectionFactory, this.valueCollector, value);
    }

    private static boolean isAbsentIgnoring(Collector<?> collector) {
        return collector instanceof AbsentIgnoringCollector;
    }

    private static <T> Collector<T> ignoreAbsentIfNeeded(Collector<T> collector, boolean ignoreAbsent) {
        if (ignoreAbsent && !AbstractCollectionProperty.isAbsentIgnoring(collector)) {
            return new AbsentIgnoringCollector(collector);
        }
        return collector;
    }

    public void replace(Transformer<? extends @Nullable Provider<? extends Iterable<? extends T>>, ? super Provider<C>> transformation) {
        Provider newValue = (Provider)transformation.transform(this.shallowCopy());
        if (newValue != null) {
            this.set(newValue);
        } else {
            this.set((Iterable)null);
        }
    }

    private static class CollectingSupplier<T, C extends Collection<T>>
    extends AbstractMinimalProvider<C>
    implements CollectionSupplier<T, C> {
        private final Class<C> type;
        private final Supplier<ImmutableCollection.Builder<T>> collectionFactory;
        private final ValueCollector<T> valueCollector;
        private final ArrayList<Collector<T>> collectors;
        private final int size;

        public CollectingSupplier(Class<C> type, Supplier<ImmutableCollection.Builder<T>> collectionFactory, ValueCollector<T> valueCollector, Collector<T> value) {
            this(type, collectionFactory, valueCollector, Lists.newArrayList((Object[])new Collector[]{value}), 1);
        }

        private CollectingSupplier(Class<C> type, Supplier<ImmutableCollection.Builder<T>> collectionFactory, ValueCollector<T> valueCollector, ArrayList<Collector<T>> collectors, int size) {
            this.type = type;
            this.collectionFactory = collectionFactory;
            this.valueCollector = valueCollector;
            this.collectors = collectors;
            this.size = size;
        }

        @Override
        protected ValueSupplier.Value<? extends C> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            return this.calculateValue(consumer);
        }

        @Override
        @javax.annotation.Nullable
        public Class<C> getType() {
            return this.type;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            for (Collector collector : Lists.reverse(this.getCollectors())) {
                if (!collector.calculatePresence(consumer)) {
                    return false;
                }
                if (!AbstractCollectionProperty.isAbsentIgnoring(collector)) continue;
                return true;
            }
            assert (this.size > 0);
            return true;
        }

        @Override
        public ValueSupplier.Value<C> calculateValue(ValueSupplier.ValueConsumer consumer) {
            ImmutableCollection.Builder<T> builder = this.collectionFactory.get();
            ValueSupplier.Value<Void> compositeResult = ValueSupplier.Value.present();
            for (Collector<T> collector : this.getCollectors()) {
                if (compositeResult.isMissing() && !AbstractCollectionProperty.isAbsentIgnoring(collector)) continue;
                ValueSupplier.Value<Void> result = collector.collectEntries(consumer, this.valueCollector, builder);
                if (result.isMissing()) {
                    builder = this.collectionFactory.get();
                    compositeResult = result;
                    continue;
                }
                if (compositeResult.isMissing()) {
                    assert (AbstractCollectionProperty.isAbsentIgnoring(collector));
                    compositeResult = result;
                    continue;
                }
                assert (!compositeResult.isMissing());
                compositeResult = compositeResult.withSideEffect(ValueSupplier.SideEffect.fixedFrom(result));
            }
            if (compositeResult.isMissing()) {
                return compositeResult.asType();
            }
            return ValueSupplier.Value.of((Collection)Cast.uncheckedNonnullCast((Object)builder.build())).withSideEffect(ValueSupplier.SideEffect.fixedFrom(compositeResult));
        }

        @Override
        public CollectionSupplier<T, C> plus(Collector<T> addedCollector, boolean ignoreAbsent) {
            Preconditions.checkState((this.collectors.size() == this.size ? 1 : 0) != 0, (Object)"Something has been appended to this collector already");
            this.collectors.add(AbstractCollectionProperty.ignoreAbsentIfNeeded(addedCollector, ignoreAbsent));
            return new CollectingSupplier<T, C>(this.type, this.collectionFactory, this.valueCollector, this.collectors, this.size + 1);
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends C> calculateExecutionTimeValue() {
            List<Pair<Collector<T>, ValueSupplier.ExecutionTimeValue<Iterable<T>>>> collectorsWithValues = this.collectExecutionTimeValues();
            if (collectorsWithValues.isEmpty()) {
                return ValueSupplier.ExecutionTimeValue.missing();
            }
            List<ValueSupplier.ExecutionTimeValue<Iterable<T>>> values = collectorsWithValues.stream().map(Pair::getRight).collect(Collectors.toList());
            boolean fixed = true;
            boolean changingContent = false;
            for (ValueSupplier.ExecutionTimeValue executionTimeValue : values) {
                assert (!executionTimeValue.isMissing());
                if (executionTimeValue.isChangingValue()) {
                    fixed = false;
                    continue;
                }
                if (!executionTimeValue.hasChangingContent()) continue;
                changingContent = true;
            }
            if (fixed) {
                return this.getFixedExecutionTimeValue(values, changingContent);
            }
            return ValueSupplier.ExecutionTimeValue.changingValue(new CollectingSupplier<T, C>(this.type, this.collectionFactory, this.valueCollector, collectorsWithValues.stream().map((? super T pair) -> {
                Collector<T> elements = this.toCollector((ValueSupplier.ExecutionTimeValue)pair.getRight());
                return AbstractCollectionProperty.ignoreAbsentIfNeeded(elements, AbstractCollectionProperty.isAbsentIgnoring((Collector)pair.getLeft()));
            }).collect(Collectors.toCollection(ArrayList::new)), collectorsWithValues.size()));
        }

        private Collector<T> toCollector(ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>> value) {
            Preconditions.checkArgument((!value.isMissing() ? 1 : 0) != 0, (Object)"Cannot get a collector for the missing value");
            if (value.isChangingValue() || value.hasChangingContent() || value.getSideEffect() != null) {
                return new Collectors.ElementsFromCollectionProvider(value.toProvider());
            }
            return new Collectors.ElementsFromCollection<T>(value.getFixedValue());
        }

        private List<Collector<T>> getCollectors() {
            return this.collectors.subList(0, this.size);
        }

        private List<Pair<Collector<T>, ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>>>> collectExecutionTimeValues() {
            ArrayList executionTimeValues = new ArrayList();
            ArrayList<Pair> candidates = new ArrayList<Pair>();
            for (Collector collector : Lists.reverse(this.getCollectors())) {
                ValueSupplier.ExecutionTimeValue result = collector.calculateExecutionTimeValue();
                if (result.isMissing()) {
                    return Lists.reverse(executionTimeValues);
                }
                if (AbstractCollectionProperty.isAbsentIgnoring(collector)) {
                    executionTimeValues.addAll(candidates);
                    executionTimeValues.add(Pair.of((Object)collector, result));
                    candidates.clear();
                    continue;
                }
                candidates.add(Pair.of((Object)collector, result));
            }
            executionTimeValues.addAll(candidates);
            return Lists.reverse(executionTimeValues);
        }

        private ValueSupplier.ExecutionTimeValue<C> getFixedExecutionTimeValue(List<ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>>> values, boolean changingContent) {
            ImmutableCollection.Builder<T> builder = this.collectionFactory.get();
            ValueSupplier.SideEffectBuilder sideEffectBuilder = ValueSupplier.SideEffect.builder();
            for (ValueSupplier.ExecutionTimeValue<Iterable<T>> value : values) {
                builder.addAll(value.getFixedValue());
                sideEffectBuilder.add(ValueSupplier.SideEffect.fixedFrom(value));
            }
            ValueSupplier.ExecutionTimeValue<Collection> mergedValue = ValueSupplier.ExecutionTimeValue.fixedValue((Collection)Cast.uncheckedNonnullCast((Object)builder.build()));
            if (changingContent) {
                mergedValue = mergedValue.withChangingContent();
            }
            return mergedValue.withSideEffect(sideEffectBuilder.build());
        }

        private Stream<ValueSupplier.ValueProducer> getProducers() {
            return this.collectors.stream().map(ValueSupplier::getProducer);
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return new ValueSupplier.ValueProducer(){

                @Override
                public void visitProducerTasks(Action<? super Task> visitor) {
                    this.getProducers().forEach(c -> c.visitProducerTasks(visitor));
                }

                @Override
                public boolean isKnown() {
                    return this.getProducers().anyMatch(ValueSupplier.ValueProducer::isKnown);
                }

                @Override
                public void visitDependencies(TaskDependencyResolveContext context) {
                    this.getProducers().forEach(c -> c.visitDependencies(context));
                }

                @Override
                public void visitContentProducerTasks(Action<? super Task> visitor) {
                    this.getProducers().forEach(c -> c.visitContentProducerTasks(visitor));
                }
            };
        }

        @Override
        protected String toStringNoReentrance() {
            StringBuilder sb = new StringBuilder();
            this.getCollectors().forEach(collector -> {
                if (sb.length() > 0) {
                    sb.append(" + ");
                }
                sb.append(collector.toString());
            });
            return sb.toString();
        }
    }

    private class EmptySupplier
    implements CollectionSupplier<T, C> {
        private EmptySupplier() {
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.Value<? extends C> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(AbstractCollectionProperty.this.emptyCollection());
        }

        @Override
        public CollectionSupplier<T, C> plus(Collector<T> collector, boolean ignoreAbsent) {
            return AbstractCollectionProperty.this.newSupplierOf(AbstractCollectionProperty.ignoreAbsentIfNeeded(collector, ignoreAbsent));
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends C> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(AbstractCollectionProperty.this.emptyCollection());
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.noProducer();
        }

        public String toString() {
            return "[]";
        }
    }

    class NoValueSupplier
    implements CollectionSupplier<T, C> {
        private final ValueSupplier.Value<? extends C> value;

        public NoValueSupplier(ValueSupplier.Value<? extends C> value) {
            assert (value.isMissing());
            this.value = value.asType();
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return false;
        }

        @Override
        public ValueSupplier.Value<? extends C> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return this.value;
        }

        @Override
        public CollectionSupplier<T, C> plus(Collector<T> collector, boolean ignoreAbsent) {
            return ignoreAbsent ? AbstractCollectionProperty.this.newSupplierOf(AbstractCollectionProperty.ignoreAbsentIfNeeded(collector, ignoreAbsent)) : this;
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends C> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.missing();
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private class Configurer {
        private final boolean ignoreAbsent;

        public Configurer(boolean ignoreAbsent) {
            this.ignoreAbsent = ignoreAbsent;
        }

        protected void addCollector(Collector<T> collector) {
            AbstractCollectionProperty.this.addExplicitCollector(collector, this.ignoreAbsent);
        }

        public void add(T element) {
            Preconditions.checkNotNull(element, (String)"Cannot add a null element to a property of type %s.", (Object)AbstractCollectionProperty.this.collectionType.getSimpleName());
            this.addCollector(new Collectors.SingleElement(element));
        }

        public void add(Provider<? extends T> providerOfElement) {
            this.addCollector(new Collectors.ElementFromProvider(Providers.internal(providerOfElement)));
        }

        @SafeVarargs
        public final void addAll(T ... elements) {
            this.addCollector(new Collectors.ElementsFromArray(elements));
        }

        public void addAll(Iterable<? extends T> elements) {
            this.addCollector(new Collectors.ElementsFromCollection(elements));
        }

        public void addAll(Provider<? extends Iterable<? extends T>> provider) {
            this.addCollector(new Collectors.ElementsFromCollectionProvider(Providers.internal(provider)));
        }
    }

    private static class FixedSupplier
    implements CollectionSupplier<T, C> {
        private final C value;
        private final ValueSupplier.SideEffect<? super C> sideEffect;
        final /* synthetic */ AbstractCollectionProperty this$0;

        public FixedSupplier(@javax.annotation.Nullable C value, ValueSupplier.SideEffect<? super C> sideEffect) {
            this.this$0 = var1_1;
            this.value = value;
            this.sideEffect = sideEffect;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.Value<? extends C> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(this.value).withSideEffect(this.sideEffect);
        }

        @Override
        public CollectionSupplier<T, C> plus(Collector<T> collector, boolean ignoreAbsent) {
            return this.this$0.newSupplierOf(new FixedValueCollector((Collection)this.value, this.sideEffect, null)).plus(collector, ignoreAbsent);
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends C> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(this.value).withSideEffect(this.sideEffect);
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static class AbsentIgnoringCollector<T>
    implements Collector<T> {
        private final Collector<T> delegate;

        private AbsentIgnoringCollector(Collector<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, ValueCollector<T> collector, ImmutableCollection.Builder<T> dest) {
            ImmutableList.Builder candidateEntries = ImmutableList.builder();
            ValueSupplier.Value<Void> value = this.delegate.collectEntries(consumer, collector, (ImmutableCollection.Builder<T>)candidateEntries);
            if (value.isMissing()) {
                return ValueSupplier.Value.present();
            }
            dest.addAll((Iterable)candidateEntries.build());
            return ValueSupplier.Value.present().withSideEffect(ValueSupplier.SideEffect.fixedFrom(value));
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>> calculateExecutionTimeValue() {
            ValueSupplier.ExecutionTimeValue<Iterable<T>> executionTimeValue = this.delegate.calculateExecutionTimeValue();
            return executionTimeValue.isMissing() ? ValueSupplier.ExecutionTimeValue.fixedValue(ImmutableList.of()) : executionTimeValue;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return this.delegate.getProducer();
        }
    }

    private static class FixedValueCollector<T, C extends Collection<T>>
    implements Collector<T> {
        @javax.annotation.Nullable
        private final ValueSupplier.SideEffect<? super C> sideEffect;
        private final C collection;

        private FixedValueCollector(C collection, @javax.annotation.Nullable ValueSupplier.SideEffect<? super C> sideEffect) {
            this.collection = collection;
            this.sideEffect = sideEffect;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, ValueCollector<T> collector, ImmutableCollection.Builder<T> dest) {
            collector.addAll((Iterable<T>)this.collection, dest);
            return this.sideEffect != null ? ValueSupplier.Value.present().withSideEffect(ValueSupplier.SideEffect.fixed(this.collection, this.sideEffect)) : ValueSupplier.Value.present();
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(this.collection).withSideEffect(this.sideEffect);
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        public String toString() {
            return this.collection.toString();
        }

        /* synthetic */ FixedValueCollector(Collection x0, ValueSupplier.SideEffect x1, 1 x2) {
            this(x0, x1);
        }
    }
}

