/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import kotlin.jvm.functions.Function0;
import org.gradle.api.internal.provider.ProviderResolutionStrategy;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;

public class DeferredUtil {
    @Nullable
    public static Object unpack(@Nullable Object deferred) {
        return DeferredUtil.unpack(ProviderResolutionStrategy.REQUIRE_PRESENT, deferred);
    }

    @Nullable
    public static Object unpackOrNull(@Nullable Object deferred) {
        return DeferredUtil.unpack(ProviderResolutionStrategy.ALLOW_ABSENT, deferred);
    }

    @Nullable
    private static Object unpack(ProviderResolutionStrategy providerResolutionStrategy, @Nullable Object deferred) {
        if (deferred == null) {
            return null;
        }
        Object value = DeferredUtil.unpackNestableDeferred(deferred);
        if (value instanceof Provider) {
            return providerResolutionStrategy.resolve((Provider)value);
        }
        if (value instanceof Factory) {
            return ((Factory)value).create();
        }
        return value;
    }

    public static boolean isDeferred(Object value) {
        return value instanceof Provider || value instanceof Factory || DeferredUtil.isNestableDeferred(value);
    }

    public static boolean isNestableDeferred(@Nullable Object value) {
        return value instanceof Callable || DeferredUtil.isKotlinFunction0Deferrable(value);
    }

    @Nullable
    public static Object unpackNestableDeferred(@Nullable Object deferred) {
        Object current = deferred;
        while (DeferredUtil.isNestableDeferred(current)) {
            if (current instanceof Callable) {
                current = UncheckedException.uncheckedCall((Callable)((Callable)current));
                continue;
            }
            current = DeferredUtil.unpackKotlinFunction0(current);
        }
        return current;
    }

    private static boolean isKotlinFunction0Deferrable(@Nullable Object value) {
        return value instanceof Function0;
    }

    @Nullable
    private static Object unpackKotlinFunction0(Object value) {
        return ((Function0)value).invoke();
    }
}

