/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildprocess.execution;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.launcher.exec.BuildActionExecutor;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;

public class StartParamsValidatingActionExecutor
implements BuildActionExecutor<BuildActionParameters, BuildRequestContext> {
    private final BuildActionExecutor<BuildActionParameters, BuildRequestContext> delegate;

    public StartParamsValidatingActionExecutor(BuildActionExecutor<BuildActionParameters, BuildRequestContext> delegate) {
        this.delegate = delegate;
    }

    public BuildActionResult execute(BuildAction action, BuildActionParameters actionParameters, BuildRequestContext requestContext) {
        StartParameterInternal startParameter = action.getStartParameter();
        File customBuildFile = (File)DeprecationLogger.whileDisabled(() -> ((StartParameter)startParameter).getBuildFile());
        if (customBuildFile != null) {
            StartParamsValidatingActionExecutor.validateIsFileAndExists(customBuildFile, "build file");
        }
        if (startParameter.getProjectDir() != null && !startParameter.getProjectDir().isDirectory()) {
            if (!startParameter.getProjectDir().exists()) {
                throw new IllegalArgumentException(String.format("The specified project directory '%s' does not exist.", startParameter.getProjectDir()));
            }
            throw new IllegalArgumentException(String.format("The specified project directory '%s' is not a directory.", startParameter.getProjectDir()));
        }
        File customSettingsFile = (File)DeprecationLogger.whileDisabled(() -> ((StartParameter)startParameter).getSettingsFile());
        if (customSettingsFile != null) {
            StartParamsValidatingActionExecutor.validateIsFileAndExists(customSettingsFile, "settings file");
        }
        for (File initScript : startParameter.getInitScripts()) {
            StartParamsValidatingActionExecutor.validateIsFileAndExists(initScript, "initialization script");
        }
        return this.delegate.execute(action, (Object)actionParameters, (Object)requestContext);
    }

    private static void validateIsFileAndExists(File file, String fileType) {
        if (!file.isFile()) {
            if (!file.exists()) {
                throw new IllegalArgumentException(String.format("The specified %s '%s' does not exist.", fileType, file));
            }
            throw new IllegalArgumentException(String.format("The specified %s '%s' is not a file.", fileType, file));
        }
    }
}

