/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FilePermissions;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.DefaultFilePermissions;
import org.gradle.api.internal.file.archive.AbstractArchiveFileTree;
import org.gradle.api.internal.file.archive.AbstractArchiveFileTreeElement;
import org.gradle.api.internal.file.archive.DecompressionCoordinator;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.provider.Provider;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.hash.FileHasher;

public class ZipFileTree
extends AbstractArchiveFileTree {
    private static final String ZIP_ENTRY_PREFIX = "zip entry";
    private final Provider<File> fileProvider;
    private final Chmod chmod;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final FileHasher fileHasher;
    private final TemporaryFileProvider temporaryExtractionDir;

    public ZipFileTree(Provider<File> zipFile, Chmod chmod, DirectoryFileTreeFactory directoryFileTreeFactory, FileHasher fileHasher, DecompressionCoordinator decompressionCoordinator, TemporaryFileProvider temporaryExtractionDir) {
        super(decompressionCoordinator);
        this.fileProvider = zipFile;
        this.chmod = chmod;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.fileHasher = fileHasher;
        this.temporaryExtractionDir = temporaryExtractionDir;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return String.format("ZIP '%s'", this.fileProvider.getOrNull());
    }

    public DirectoryFileTree getMirror() {
        return this.directoryFileTreeFactory.create(this.getExpandedDir());
    }

    public void visit(FileVisitor visitor) {
        File zipFile = (File)this.fileProvider.get();
        if (!zipFile.exists()) {
            throw new InvalidUserDataException(String.format("Cannot expand %s as it does not exist.", this.getDisplayName()));
        }
        if (!zipFile.isFile()) {
            throw new InvalidUserDataException(String.format("Cannot expand %s as it is not a file.", this.getDisplayName()));
        }
        File expandedDir = this.getExpandedDir();
        this.decompressionCoordinator.exclusiveAccessTo(expandedDir, () -> {
            AtomicBoolean stopFlag = new AtomicBoolean();
            try (ZipFile zip = ((ZipFile.Builder)ZipFile.builder().setFile(zipFile)).get();){
                Iterator<ZipArchiveEntry> sortedEntries = this.entriesSortedByName(zip);
                while (!stopFlag.get() && sortedEntries.hasNext()) {
                    ZipArchiveEntry entry = sortedEntries.next();
                    DetailsImpl details = new DetailsImpl(zipFile, expandedDir, entry, zip, stopFlag, this.chmod);
                    if (entry.isDirectory()) {
                        visitor.visitDir((FileVisitDetails)details);
                        continue;
                    }
                    visitor.visitFile((FileVisitDetails)details);
                }
            }
            catch (GradleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new GradleException(String.format("Cannot expand %s.", this.getDisplayName()), (Throwable)e);
            }
        });
    }

    private Iterator<ZipArchiveEntry> entriesSortedByName(ZipFile zip) {
        TreeMap<String, ZipArchiveEntry> entriesByName = new TreeMap<String, ZipArchiveEntry>();
        Enumeration entries = zip.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
            entriesByName.put(entry.getName(), entry);
        }
        return entriesByName.values().iterator();
    }

    @Override
    public Provider<File> getBackingFileProvider() {
        return this.fileProvider;
    }

    private File getExpandedDir() {
        File zipFile = (File)this.fileProvider.get();
        String expandedDirName = "zip_" + this.fileHasher.hash(zipFile);
        return this.temporaryExtractionDir.newTemporaryDirectory(new String[]{".cache", "expanded", expandedDirName});
    }

    private static final class DetailsImpl
    extends AbstractArchiveFileTreeElement {
        private final File originalFile;
        private final ZipArchiveEntry entry;
        private final ZipFile zip;

        public DetailsImpl(File originalFile, File expandedDir, ZipArchiveEntry entry, ZipFile zip, AtomicBoolean stopFlag, Chmod chmod) {
            super(chmod, expandedDir, stopFlag);
            this.originalFile = originalFile;
            this.entry = entry;
            this.zip = zip;
        }

        public String getDisplayName() {
            return String.format("%s '%s!%s'", ZipFileTree.ZIP_ENTRY_PREFIX, this.originalFile, this.entry.getName());
        }

        @Override
        protected String getEntryName() {
            return this.entry.getName();
        }

        protected ZipArchiveEntry getArchiveEntry() {
            return this.entry;
        }

        public InputStream open() {
            try {
                return this.zip.getInputStream(this.entry);
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }

        public FilePermissions getPermissions() {
            int unixMode = this.entry.getUnixMode() & 0x1FF;
            if (unixMode != 0) {
                return new DefaultFilePermissions(unixMode);
            }
            return super.getPermissions();
        }
    }
}

