/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import com.google.common.annotations.VisibleForTesting;
import java.util.Locale;
import java.util.concurrent.ScheduledExecutorService;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedScheduledExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.util.NumberUtil;
import org.gradle.launcher.daemon.server.health.gc.DefaultGarbageCollectionMonitor;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionInfo;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionMonitor;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionStats;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectorMonitoringStrategy;
import org.gradle.launcher.daemon.server.stats.DaemonRunningStats;

@ServiceScope(value={Scope.Global.class})
public class DaemonHealthStats
implements Stoppable {
    private final DaemonRunningStats runningStats;
    private final ManagedScheduledExecutor scheduler;
    private final GarbageCollectionInfo gcInfo;
    private GarbageCollectionMonitor gcMonitor;

    public DaemonHealthStats(DaemonRunningStats runningStats, GarbageCollectorMonitoringStrategy strategy, ExecutorFactory executorFactory) {
        this.runningStats = runningStats;
        this.scheduler = executorFactory.createScheduled("Daemon health stats", 1);
        this.gcInfo = new GarbageCollectionInfo();
        this.gcMonitor = new DefaultGarbageCollectionMonitor(strategy, (ScheduledExecutorService)this.scheduler);
    }

    @VisibleForTesting
    DaemonHealthStats(DaemonRunningStats runningStats, GarbageCollectionInfo gcInfo, GarbageCollectionMonitor gcMonitor) {
        this.runningStats = runningStats;
        this.scheduler = null;
        this.gcInfo = gcInfo;
        this.gcMonitor = gcMonitor;
    }

    @VisibleForTesting
    public GarbageCollectionMonitor getGcMonitor() {
        return this.gcMonitor;
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }

    public GarbageCollectionStats getHeapStats() {
        return this.gcMonitor.getHeapStats();
    }

    public GarbageCollectionStats getNonHeapStats() {
        return this.gcMonitor.getNonHeapStats();
    }

    public String getHealthInfo() {
        GarbageCollectionStats nonHeapStats;
        StringBuilder message = new StringBuilder();
        message.append(String.format("[uptime: %s, performance: %s%%", this.runningStats.getPrettyUpTime(), this.getCurrentPerformance()));
        GarbageCollectionStats heapStats = this.gcMonitor.getHeapStats();
        if (heapStats.isValid()) {
            message.append(String.format(Locale.ENGLISH, ", GC rate: %.2f/s", heapStats.getGcRate()));
            message.append(String.format(", heap usage: %s%% of %s", heapStats.getUsedPercent(), NumberUtil.formatBytes((Long)heapStats.getMaxSizeInBytes())));
        }
        if ((nonHeapStats = this.gcMonitor.getNonHeapStats()).isValid()) {
            message.append(String.format(", non-heap usage: %s%% of %s", nonHeapStats.getUsedPercent(), NumberUtil.formatBytes((Long)nonHeapStats.getMaxSizeInBytes())));
        }
        message.append("]");
        return message.toString();
    }

    private int getCurrentPerformance() {
        long collectionTime = this.gcInfo.getCollectionTime();
        long allBuildsTime = this.runningStats.getAllBuildsTime();
        if (collectionTime > 0L && collectionTime < allBuildsTime) {
            return 100 - NumberUtil.percentOf((long)collectionTime, (long)allBuildsTime);
        }
        return 100;
    }
}

