/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.SoftwareComponentVariant;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.ExactVersionSelector;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.provider.MergeProvider;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.internal.component.IvyPublishingAwareVariant;
import org.gradle.api.publish.internal.mapping.DependencyCoordinateResolverFactory;
import org.gradle.api.publish.internal.mapping.ResolvedCoordinates;
import org.gradle.api.publish.internal.mapping.VariantDependencyResolver;
import org.gradle.api.publish.internal.validation.PublicationErrorChecker;
import org.gradle.api.publish.internal.validation.PublicationWarningsCollector;
import org.gradle.api.publish.internal.validation.VariantWarningCollector;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.IvyConfigurationContainer;
import org.gradle.api.publish.ivy.internal.dependency.DefaultIvyDependency;
import org.gradle.api.publish.ivy.internal.dependency.DefaultIvyDependencySet;
import org.gradle.api.publish.ivy.internal.dependency.DefaultIvyExcludeRule;
import org.gradle.api.publish.ivy.internal.dependency.IvyDependency;
import org.gradle.api.publish.ivy.internal.dependency.IvyExcludeRule;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyConfigurationContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public class IvyComponentParser {
    @VisibleForTesting
    public static final String UNSUPPORTED_FEATURE = " contains dependencies that cannot be represented in a published ivy descriptor.";
    @VisibleForTesting
    public static final String PUBLICATION_WARNING_FOOTER = "These issues indicate information that is lost in the published 'ivy.xml' metadata file, which may be an issue if the published library is consumed by an old Gradle version or Apache Ivy.\nThe 'module' metadata file, which is used by Gradle 6+ is not affected.";
    private static final Logger LOG = Logging.getLogger(IvyComponentParser.class);
    private static final String API_VARIANT = "api";
    private static final String API_ELEMENTS_VARIANT = "apiElements";
    private static final String RUNTIME_VARIANT = "runtime";
    private static final String RUNTIME_ELEMENTS_VARIANT = "runtimeElements";
    private final Instantiator instantiator;
    private final PlatformSupport platformSupport;
    private final NotationParser<Object, IvyArtifact> ivyArtifactParser;
    private final DocumentationRegistry documentationRegistry;
    private final CollectionCallbackActionDecorator collectionCallbackActionDecorator;
    private final DependencyCoordinateResolverFactory dependencyCoordinateResolverFactory;

    @Inject
    public IvyComponentParser(Instantiator instantiator, PlatformSupport platformSupport, NotationParser<Object, IvyArtifact> ivyArtifactParser, DocumentationRegistry documentationRegistry, CollectionCallbackActionDecorator collectionCallbackActionDecorator, DependencyCoordinateResolverFactory dependencyCoordinateResolverFactory) {
        this.instantiator = instantiator;
        this.platformSupport = platformSupport;
        this.ivyArtifactParser = ivyArtifactParser;
        this.documentationRegistry = documentationRegistry;
        this.collectionCallbackActionDecorator = collectionCallbackActionDecorator;
        this.dependencyCoordinateResolverFactory = dependencyCoordinateResolverFactory;
    }

    public IvyConfigurationContainer parseConfigurations(SoftwareComponentInternal component) {
        IvyConfigurationContainer configurations = (IvyConfigurationContainer)this.instantiator.newInstance(DefaultIvyConfigurationContainer.class, new Object[]{this.instantiator, this.collectionCallbackActionDecorator});
        IvyConfiguration defaultConfiguration = (IvyConfiguration)configurations.maybeCreate("default");
        for (SoftwareComponentVariant variant : component.getUsages()) {
            String conf = IvyComponentParser.mapVariantNameToIvyConfiguration(variant.getName());
            configurations.maybeCreate(conf);
            if (!IvyComponentParser.defaultShouldExtend(variant)) continue;
            defaultConfiguration.extend(conf);
        }
        return configurations;
    }

    private static boolean defaultShouldExtend(SoftwareComponentVariant variant) {
        if (!(variant instanceof IvyPublishingAwareVariant)) {
            return true;
        }
        if (((IvyPublishingAwareVariant)variant).isOptional()) {
            return false;
        }
        return !IvyComponentParser.isJavaApiVariant(variant.getName());
    }

    private static boolean isJavaRuntimeVariant(String variantName) {
        return RUNTIME_VARIANT.equals(variantName) || RUNTIME_ELEMENTS_VARIANT.equals(variantName);
    }

    private static boolean isJavaApiVariant(String variantName) {
        return API_VARIANT.equals(variantName) || API_ELEMENTS_VARIANT.equals(variantName);
    }

    public Set<IvyArtifact> parseArtifacts(SoftwareComponentInternal component) {
        LinkedHashSet<IvyArtifact> artifacts = new LinkedHashSet<IvyArtifact>();
        HashMap<String, IvyArtifact> seenArtifacts = new HashMap<String, IvyArtifact>();
        for (SoftwareComponentVariant variant : component.getUsages()) {
            String conf = IvyComponentParser.mapVariantNameToIvyConfiguration(variant.getName());
            for (PublishArtifact publishArtifact : variant.getArtifacts()) {
                String key = IvyComponentParser.artifactKey(publishArtifact);
                IvyArtifact ivyArtifact = (IvyArtifact)seenArtifacts.get(key);
                if (ivyArtifact == null) {
                    ivyArtifact = (IvyArtifact)this.ivyArtifactParser.parseNotation((Object)publishArtifact);
                    ivyArtifact.setConf(conf);
                    seenArtifacts.put(key, ivyArtifact);
                    artifacts.add(ivyArtifact);
                    continue;
                }
                ivyArtifact.setConf(ivyArtifact.getConf() + "," + conf);
            }
        }
        return artifacts;
    }

    private static String artifactKey(PublishArtifact publishArtifact) {
        return publishArtifact.getName() + ":" + publishArtifact.getType() + ":" + publishArtifact.getExtension() + ":" + publishArtifact.getClassifier();
    }

    public Provider<ParsedDependencyResult> parseDependencies(SoftwareComponentInternal component, VersionMappingStrategyInternal versionMappingStrategy) {
        PublicationErrorChecker.checkForUnpublishableAttributes((SoftwareComponentInternal)component, (DocumentationRegistry)this.documentationRegistry);
        List parsedVariants = (List)component.getUsages().stream().map(variant -> this.dependencyCoordinateResolverFactory.createCoordinateResolvers((SoftwareComponentVariant)variant, versionMappingStrategy).map(resolvers -> IvyComponentParser.getDependenciesForVariant((SoftwareComponentVariant)variant, resolvers.getVariantResolver(), this.platformSupport))).collect(ImmutableList.toImmutableList());
        return new MergeProvider(parsedVariants).map(variants -> {
            DefaultIvyDependencySet ivyDependencies = (DefaultIvyDependencySet)((Object)((Object)this.instantiator.newInstance(DefaultIvyDependencySet.class, new Object[]{this.collectionCallbackActionDecorator})));
            HashMap<String, VariantWarningCollector> warnings = new HashMap<String, VariantWarningCollector>();
            for (ParsedVariantDependencyResult variant : variants) {
                ivyDependencies.addAll(variant.dependencies);
                warnings.put(variant.name, variant.warnings);
            }
            return new ParsedDependencyResult(ivyDependencies, new PublicationWarningsCollector(warnings, LOG, UNSUPPORTED_FEATURE, "", PUBLICATION_WARNING_FOOTER, "suppressIvyMetadataWarningsFor"));
        });
    }

    private static ParsedVariantDependencyResult getDependenciesForVariant(SoftwareComponentVariant variant, VariantDependencyResolver dependencyResolver, PlatformSupport platformSupport) {
        VariantWarningCollector warnings = new VariantWarningCollector();
        Set dependencies = variant.getDependencies();
        ArrayList<IvyDependency> ivyDependencies = new ArrayList<IvyDependency>(dependencies.size());
        VariantDependencyFactory dependencyFactory = new VariantDependencyFactory(dependencyResolver, warnings);
        for (ModuleDependency dependency : dependencies) {
            String confMapping = IvyComponentParser.confMappingFor(variant, dependency);
            if (platformSupport.isTargetingPlatform((HasConfigurableAttributes)dependency)) {
                warnings.addUnsupported(String.format("%s:%s:%s declared as platform", dependency.getGroup(), dependency.getName(), dependency.getVersion()));
            }
            ivyDependencies.add(dependencyFactory.convertDependency(dependency, confMapping));
        }
        if (!variant.getDependencyConstraints().isEmpty()) {
            for (DependencyConstraint constraint : variant.getDependencyConstraints()) {
                warnings.addUnsupported(String.format("%s:%s:%s declared as a dependency constraint", constraint.getGroup(), constraint.getName(), constraint.getVersion()));
            }
        }
        if (!variant.getCapabilities().isEmpty()) {
            for (Capability capability : variant.getCapabilities()) {
                warnings.addVariantUnsupported(String.format("Declares capability %s:%s:%s which cannot be mapped to Ivy", capability.getGroup(), capability.getName(), capability.getVersion()));
            }
        }
        return new ParsedVariantDependencyResult(variant.getName(), ivyDependencies, warnings);
    }

    public Set<IvyExcludeRule> parseGlobalExcludes(SoftwareComponentInternal component) {
        LinkedHashSet<IvyExcludeRule> globalExcludes = new LinkedHashSet<IvyExcludeRule>();
        for (SoftwareComponentVariant variant : component.getUsages()) {
            String conf = IvyComponentParser.mapVariantNameToIvyConfiguration(variant.getName());
            for (ExcludeRule excludeRule : variant.getGlobalExcludes()) {
                globalExcludes.add(new DefaultIvyExcludeRule(excludeRule, conf));
            }
        }
        return globalExcludes;
    }

    private static String confMappingFor(SoftwareComponentVariant variant, ModuleDependency dependency) {
        String conf = IvyComponentParser.mapVariantNameToIvyConfiguration(variant.getName());
        String targetConfiguration = dependency.getTargetConfiguration();
        String confMappingTarget = targetConfiguration == null ? "default" : IvyComponentParser.mapVariantNameToIvyConfiguration(dependency.getTargetConfiguration());
        return conf + "->" + confMappingTarget;
    }

    private static String mapVariantNameToIvyConfiguration(String variantName) {
        if (IvyComponentParser.isJavaApiVariant(variantName)) {
            return "compile";
        }
        if (IvyComponentParser.isJavaRuntimeVariant(variantName)) {
            return RUNTIME_VARIANT;
        }
        return variantName;
    }

    private static class VariantDependencyFactory {
        private final VariantDependencyResolver dependencyResolver;
        private final VariantWarningCollector warnings;

        public VariantDependencyFactory(VariantDependencyResolver dependencyResolver, VariantWarningCollector warnings) {
            this.dependencyResolver = dependencyResolver;
            this.warnings = warnings;
        }

        private IvyDependency convertDependency(ModuleDependency dependency, String confMapping) {
            ResolvedCoordinates coordinates = this.resolveDependency(dependency);
            String revConstraint = null;
            if (!(dependency instanceof ProjectDependency) && dependency.getVersion() != null && VariantDependencyFactory.isDynamicVersion(dependency.getVersion())) {
                revConstraint = dependency.getVersion();
            }
            return new DefaultIvyDependency(coordinates.getGroup(), coordinates.getName(), Strings.nullToEmpty((String)coordinates.getVersion()), confMapping, dependency.isTransitive(), revConstraint, dependency.getArtifacts(), dependency.getExcludeRules());
        }

        private ResolvedCoordinates resolveDependency(ModuleDependency dependency) {
            if (!dependency.getAttributes().isEmpty()) {
                this.warnings.addUnsupported(String.format("dependency on %s declared with Gradle attributes", dependency));
            }
            if (!dependency.getCapabilitySelectors().isEmpty()) {
                this.warnings.addUnsupported(String.format("dependency on %s declared with Gradle capabilities", dependency));
            }
            if (dependency instanceof ProjectDependency) {
                return this.dependencyResolver.resolveVariantCoordinates((ProjectDependency)dependency, this.warnings);
            }
            if (dependency instanceof ExternalDependency) {
                ResolvedCoordinates coordinates = this.dependencyResolver.resolveVariantCoordinates((ExternalDependency)dependency, this.warnings);
                if (coordinates != null) {
                    return coordinates;
                }
                return this.convertDeclaredCoordinates(dependency.getGroup(), dependency.getName(), dependency.getVersion());
            }
            throw new GradleException("Unsupported dependency type: " + dependency.getClass().getName());
        }

        private ResolvedCoordinates convertDeclaredCoordinates(String organization, String module, @Nullable String version) {
            if (version == null) {
                this.warnings.addUnsupported(String.format("%s:%s declared without version", organization, module));
            }
            return ResolvedCoordinates.create((String)organization, (String)module, (String)version);
        }

        private static boolean isDynamicVersion(String version) {
            return !ExactVersionSelector.isExact((String)version);
        }
    }

    private static class ParsedVariantDependencyResult {
        private final String name;
        private final List<IvyDependency> dependencies;
        private final VariantWarningCollector warnings;

        public ParsedVariantDependencyResult(String name, List<IvyDependency> dependencies, VariantWarningCollector warnings) {
            this.name = name;
            this.dependencies = dependencies;
            this.warnings = warnings;
        }
    }

    public static class ParsedDependencyResult {
        private final DefaultIvyDependencySet dependencies;
        private final PublicationWarningsCollector warnings;

        public ParsedDependencyResult(DefaultIvyDependencySet ivyDependencies, PublicationWarningsCollector warnings) {
            this.dependencies = ivyDependencies;
            this.warnings = warnings;
        }

        public DefaultIvyDependencySet getDependencies() {
            return this.dependencies;
        }

        public PublicationWarningsCollector getWarnings() {
            return this.warnings;
        }
    }
}

