/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependents.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.reporting.dependents.internal.DependentComponentsRenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.NodeRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;

public class DependentComponentsGraphRenderer {
    private final GraphRenderer renderer;
    private final DependentBinaryNodeRenderer nodeRenderer;
    private final ShowDependentPredicate showDependentPredicate;

    public DependentComponentsGraphRenderer(GraphRenderer renderer, boolean showNonBuildable, boolean showTestSuites) {
        this.renderer = renderer;
        this.nodeRenderer = new DependentBinaryNodeRenderer();
        this.showDependentPredicate = new ShowDependentPredicate(showNonBuildable, showTestSuites);
    }

    public void render(DependentComponentsRenderableDependency root) {
        this.renderChildren(this.getChildren(root));
    }

    private void renderChildren(Set<? extends RenderableDependency> children) {
        this.renderer.startChildren();
        int idx = 0;
        for (RenderableDependency renderableDependency : children) {
            boolean last = idx++ == children.size() - 1;
            this.doRender(renderableDependency, last);
        }
        this.renderer.completeChildren();
    }

    private void doRender(RenderableDependency node, boolean last) {
        this.renderer.visit(output -> this.nodeRenderer.renderNode((StyledTextOutput)output, node, false), last);
        this.renderChildren(this.getChildren(node));
    }

    public boolean hasSeenTestSuite() {
        return this.nodeRenderer.seenTestSuite;
    }

    public boolean hasHiddenTestSuite() {
        return this.showDependentPredicate.hiddenTestSuite;
    }

    public boolean hasHiddenNonBuildable() {
        return this.showDependentPredicate.hiddenNonBuildable;
    }

    private Set<? extends RenderableDependency> getChildren(RenderableDependency node) {
        return Sets.filter(node.getChildren(), (Predicate)this.showDependentPredicate);
    }

    private static class DependentBinaryNodeRenderer
    implements NodeRenderer {
        private boolean seenTestSuite;

        private DependentBinaryNodeRenderer() {
        }

        @Override
        public void renderNode(StyledTextOutput output, RenderableDependency node, boolean alreadyRendered) {
            output.text((Object)node.getName());
            if (node instanceof DependentComponentsRenderableDependency) {
                DependentComponentsRenderableDependency dep = (DependentComponentsRenderableDependency)node;
                if (dep.isTestSuite()) {
                    output.withStyle(StyledTextOutput.Style.Info).text((Object)" (t)");
                    this.seenTestSuite = true;
                }
                if (!dep.isBuildable()) {
                    output.withStyle(StyledTextOutput.Style.Info).text((Object)" NOT BUILDABLE");
                }
            }
        }
    }

    private static class ShowDependentPredicate
    implements Predicate<RenderableDependency> {
        private final boolean showNonBuildable;
        private final boolean showTestSuites;
        private boolean hiddenNonBuildable;
        private boolean hiddenTestSuite;

        private ShowDependentPredicate(boolean showNonBuildable, boolean showTestSuites) {
            this.showNonBuildable = showNonBuildable;
            this.showTestSuites = showTestSuites;
        }

        public boolean apply(@Nullable RenderableDependency node) {
            if (node instanceof DependentComponentsRenderableDependency) {
                boolean hideTestSuite;
                DependentComponentsRenderableDependency dep = (DependentComponentsRenderableDependency)node;
                boolean hideNonBuildable = !dep.isBuildable() && !this.showNonBuildable;
                boolean bl = hideTestSuite = dep.isTestSuite() && !this.showTestSuites;
                if (hideNonBuildable) {
                    this.hiddenNonBuildable = true;
                }
                if (hideTestSuite) {
                    this.hiddenTestSuite = true;
                }
                return !hideNonBuildable && !hideTestSuite;
            }
            return false;
        }
    }
}

