/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.wasm.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirFunctionTypeParameter;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.wasm.FirWasmErrors;
import org.jetbrains.kotlin.fir.analysis.wasm.checkers.FirWasmJsCodeHelpersKt;
import org.jetbrains.kotlin.fir.analysis.wasm.checkers.FirWasmJsExportHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.WasmStandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/wasm/checkers/declaration/FirWasmJsInteropTypesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "Position", "checkers.wasm"})
@SourceDebugExtension(value={"SMAP\nFirWasmJsInteropTypesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWasmJsInteropTypesChecker.kt\norg/jetbrains/kotlin/fir/analysis/wasm/checkers/declaration/FirWasmJsInteropTypesChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1557#2:142\n1628#2,3:143\n1863#2,2:146\n*S KotlinDebug\n*F\n+ 1 FirWasmJsInteropTypesChecker.kt\norg/jetbrains/kotlin/fir/analysis/wasm/checkers/declaration/FirWasmJsInteropTypesChecker\n*L\n101#1:142\n101#1:143,3\n101#1:146,2\n*E\n"})
public final class FirWasmJsInteropTypesChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirWasmJsInteropTypesChecker INSTANCE = new FirWasmJsInteropTypesChecker();

    private FirWasmJsInteropTypesChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block7: {
            Object object;
            FirSession session2;
            block6: {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                session2 = context.getSession();
                if (!(FirWasmJsInteropTypesChecker.check$isExternalJsInteropDeclaration(declaration, session2) || FirWasmJsInteropTypesChecker.check$isJsCodeDeclaration(declaration) || FirWasmJsExportHelpersKt.isJsExportedDeclaration(declaration, session2))) {
                    return;
                }
                if (declaration.getSource() instanceof KtFakeSourceElement) {
                    return;
                }
                if (declaration instanceof FirTypeParameterRefsOwner) {
                    object = ((FirTypeParameterRefsOwner)((Object)declaration)).getTypeParameters().iterator();
                    while (object.hasNext()) {
                        FirTypeParameterRef typeParameter = (FirTypeParameterRef)object.next();
                        for (FirResolvedTypeRef upperBound : typeParameter.getSymbol().getResolvedBounds()) {
                            FirWasmJsInteropTypesChecker.check$checkSupportInJsInterop(upperBound, reporter, context, session2, Position.TYPE_PARAMETER_UPPER_BOUND, typeParameter.getSource());
                        }
                    }
                }
                if (!((object = declaration) instanceof FirProperty)) break block6;
                FirWasmJsInteropTypesChecker.check$checkSupportInJsInterop(((FirProperty)declaration).getReturnTypeRef(), reporter, context, session2, Position.PROPERTY_TYPE, ((FirProperty)declaration).getSource());
                break block7;
            }
            if (!(object instanceof FirFunction)) break block7;
            for (FirValueParameter valueParameter2 : ((FirFunction)declaration).getValueParameters()) {
                Position position = valueParameter2.isVararg() ? Position.VARARG_VALUE_PARAMETER_TYPE : Position.VALUE_PARAMETER_TYPE;
                FirWasmJsInteropTypesChecker.check$checkSupportInJsInterop(valueParameter2.getReturnTypeRef(), reporter, context, session2, position, valueParameter2.getSource());
            }
            FirWasmJsInteropTypesChecker.check$checkSupportInJsInterop(((FirFunction)declaration).getReturnTypeRef(), reporter, context, session2, Position.RETURN_TYPE, ((FirFunction)declaration).getSource());
        }
    }

    private static final boolean check$isExternalJsInteropDeclaration(FirDeclaration $declaration, FirSession session2) {
        boolean isEffectivelyExternal = FirWebCommonHelpersKt.isEffectivelyExternal($declaration.getSymbol(), session2);
        boolean hasWasmImportAnnotation = FirAnnotationUtilsKt.hasAnnotation($declaration.getAnnotations(), WasmStandardClassIds.Annotations.WasmImport, session2);
        return isEffectivelyExternal && !hasWasmImportAnnotation;
    }

    private static final boolean check$isJsCodeDeclaration(FirDeclaration $declaration) {
        FirDeclaration firDeclaration = $declaration;
        return firDeclaration instanceof FirSimpleFunction ? FirWasmJsCodeHelpersKt.hasValidJsCodeBody((FirSimpleFunction)$declaration) : (firDeclaration instanceof FirProperty ? FirWasmJsCodeHelpersKt.hasValidJsCodeBody((FirProperty)$declaration) : false);
    }

    private static final boolean check$isSupportedInJsInterop(ConeKotlinType $this$check_u24isSupportedInJsInterop, FirSession session2, Position position) {
        if (ConeBuiltinTypeUtilsKt.isUnit($this$check_u24isSupportedInJsInterop) || ConeBuiltinTypeUtilsKt.isNothing($this$check_u24isSupportedInJsInterop)) {
            return position == Position.RETURN_TYPE || position == Position.FUNCTION_TYPE_RETURN_TYPE;
        }
        if (ConeBuiltinTypeUtilsKt.isPrimitiveOrNullablePrimitive($this$check_u24isSupportedInJsInterop)) {
            return true;
        }
        if (ConeBuiltinTypeUtilsKt.isUnsignedTypeOrNullableUnsignedType($this$check_u24isSupportedInJsInterop)) {
            return true;
        }
        if (ConeBuiltinTypeUtilsKt.isString($this$check_u24isSupportedInJsInterop) || ConeBuiltinTypeUtilsKt.isNullableString($this$check_u24isSupportedInJsInterop)) {
            return true;
        }
        if ($this$check_u24isSupportedInJsInterop instanceof ConeTypeParameterType) {
            return true;
        }
        if (FunctionalTypeUtilsKt.isBasicFunctionType($this$check_u24isSupportedInJsInterop, session2)) {
            return true;
        }
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol($this$check_u24isSupportedInJsInterop, session2);
        return firRegularClassSymbol != null ? FirWebCommonHelpersKt.isEffectivelyExternal(firRegularClassSymbol, session2) : false;
    }

    /*
     * WARNING - void declaration
     */
    private static final void check$checkSupportInJsInterop(FirTypeRef $this$check_u24checkSupportInJsInterop, DiagnosticReporter $reporter, CheckerContext $context, FirSession session2, Position position, KtSourceElement fallbackSource) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        FirFunctionTypeRef functionTypeRef;
        ConeKotlinType it = FirTypeUtilsKt.getConeType($this$check_u24checkSupportInJsInterop);
        boolean $i$a$-let-FirWasmJsInteropTypesChecker$check$checkSupportInJsInterop$type$22 = false;
        ConeKotlinType unexpandedType = position == Position.VARARG_VALUE_PARAMETER_TYPE ? ArrayUtilsKt.varargElementType(it) : it;
        ConeKotlinType type2 = TypeExpansionUtilsKt.fullyExpandedType$default(unexpandedType, session2, null, 2, null);
        if (!FirWasmJsInteropTypesChecker.check$isSupportedInJsInterop(type2, session2, position)) {
            KtSourceElement ktSourceElement = $this$check_u24checkSupportInJsInterop.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = fallbackSource;
            }
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)ktSourceElement, FirWasmErrors.INSTANCE.getWRONG_JS_INTEROP_TYPE(), (Object)type2, (Object)position.getDescription(), (DiagnosticContext)$context, null, 32, null);
            return;
        }
        FirResolvedTypeRef firResolvedTypeRef = $this$check_u24checkSupportInJsInterop instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$check_u24checkSupportInJsInterop : null;
        FirTypeRef $i$a$-let-FirWasmJsInteropTypesChecker$check$checkSupportInJsInterop$type$22 = firResolvedTypeRef != null ? firResolvedTypeRef.getDelegatedTypeRef() : null;
        FirFunctionTypeRef firFunctionTypeRef = $i$a$-let-FirWasmJsInteropTypesChecker$check$checkSupportInJsInterop$type$22 instanceof FirFunctionTypeRef ? (FirFunctionTypeRef)$i$a$-let-FirWasmJsInteropTypesChecker$check$checkSupportInJsInterop$type$22 : null;
        if (firFunctionTypeRef == null) {
            return;
        }
        FirFunctionTypeRef $this$check_u24checkSupportInJsInterop_u24lambda_u242 = functionTypeRef = firFunctionTypeRef;
        boolean bl = false;
        Iterable $this$map$iv = $this$check_u24checkSupportInJsInterop_u24lambda_u242.getParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            FirFunctionTypeParameter firFunctionTypeParameter = (FirFunctionTypeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(p0.getReturnTypeRef());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirTypeRef parameterTypeRef = (FirTypeRef)element$iv;
            boolean bl3 = false;
            FirWasmJsInteropTypesChecker.check$checkSupportInJsInterop(parameterTypeRef, $reporter, $context, session2, Position.FUNCTION_TYPE_PARAMETER_TYPE, functionTypeRef.getSource());
        }
        FirWasmJsInteropTypesChecker.check$checkSupportInJsInterop($this$check_u24checkSupportInJsInterop_u24lambda_u242.getReturnTypeRef(), $reporter, $context, session2, Position.FUNCTION_TYPE_RETURN_TYPE, functionTypeRef.getSource());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/wasm/checkers/declaration/FirWasmJsInteropTypesChecker$Position;", "", "description", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "TYPE_PARAMETER_UPPER_BOUND", "PROPERTY_TYPE", "VALUE_PARAMETER_TYPE", "VARARG_VALUE_PARAMETER_TYPE", "RETURN_TYPE", "FUNCTION_TYPE_PARAMETER_TYPE", "FUNCTION_TYPE_RETURN_TYPE", "checkers.wasm"})
    private static final class Position
    extends Enum<Position> {
        @NotNull
        private final String description;
        public static final /* enum */ Position TYPE_PARAMETER_UPPER_BOUND = new Position("upper bound of JS interop type parameter");
        public static final /* enum */ Position PROPERTY_TYPE = new Position("type of JS interop property");
        public static final /* enum */ Position VALUE_PARAMETER_TYPE = new Position("value parameter type of JS interop function");
        public static final /* enum */ Position VARARG_VALUE_PARAMETER_TYPE = new Position("value parameter type of JS interop function");
        public static final /* enum */ Position RETURN_TYPE = new Position("return type of JS interop function");
        public static final /* enum */ Position FUNCTION_TYPE_PARAMETER_TYPE = new Position("parameter type of JS interop function type");
        public static final /* enum */ Position FUNCTION_TYPE_RETURN_TYPE = new Position("return type of JS interop function type");
        private static final /* synthetic */ Position[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Position(String description) {
            this.description = description;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String value2) {
            return Enum.valueOf(Position.class, value2);
        }

        @NotNull
        public static EnumEntries<Position> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = positionArray = new Position[]{Position.TYPE_PARAMETER_UPPER_BOUND, Position.PROPERTY_TYPE, Position.VALUE_PARAMETER_TYPE, Position.VARARG_VALUE_PARAMETER_TYPE, Position.RETURN_TYPE, Position.FUNCTION_TYPE_PARAMETER_TYPE, Position.FUNCTION_TYPE_RETURN_TYPE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

