/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog;

import com.declarativa.interprolog.AbstractPrologEngine;
import com.declarativa.interprolog.PrologOutputListener;
import com.declarativa.interprolog.util.GoalFromJava;
import com.declarativa.interprolog.util.GoalToExecute;
import com.declarativa.interprolog.util.IPAbortedException;
import com.declarativa.interprolog.util.IPException;
import com.declarativa.interprolog.util.IPInterruptedException;
import com.declarativa.interprolog.util.IPPrologError;
import com.declarativa.interprolog.util.OutputHandler;
import com.declarativa.interprolog.util.OutputListener;
import com.declarativa.interprolog.util.PrologOutputObjectStream;
import com.declarativa.interprolog.util.Recognizer;
import com.declarativa.interprolog.util.RecognizerListener;
import com.declarativa.interprolog.util.ResultFromProlog;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public abstract class SubprocessEngine
extends AbstractPrologEngine {
    Process prolog;
    PrintWriter prologStdin;
    OutputHandler stdoutHandler;
    OutputHandler stderrHandler;
    ServerSocket serverSocket;
    protected Socket socket;
    ServerSocket intServerSocket = null;
    Socket intSocket = null;
    String interruptCommand = null;
    Vector listeners = new Vector();
    protected boolean available;
    Recognizer promptTrigger = this.peer.makePromptRecognizer();
    Recognizer breakTrigger = this.peer.makeBreakRecognizer();
    private RecognizerListener errorHandler = null;
    Recognizer errorTrigger = new Recognizer("++Error", true);
    private String abortMessage;
    static /* synthetic */ Class class$java$lang$System;

    public synchronized void addPrologOutputListener(PrologOutputListener prologOutputListener) {
        ClientRecognizer clientRecognizer = new ClientRecognizer(prologOutputListener);
        this.listeners.addElement(clientRecognizer);
        this.addPrologStdoutListener(clientRecognizer);
        this.addPrologStderrListener(clientRecognizer);
    }

    public synchronized void removePrologOutputListener(PrologOutputListener prologOutputListener) {
        int n = 0;
        while (n < this.listeners.size()) {
            ClientRecognizer clientRecognizer = (ClientRecognizer)this.listeners.elementAt(n);
            if (clientRecognizer.client == prologOutputListener) {
                this.listeners.removeElementAt(n);
                this.removePrologStdoutListener(clientRecognizer);
                this.removePrologStderrListener(clientRecognizer);
            }
            ++n;
        }
    }

    public void addPrologStdoutListener(OutputListener outputListener) {
        this.stdoutHandler.addOutputListener(outputListener);
    }

    public void addPrologStderrListener(OutputListener outputListener) {
        this.stderrHandler.addOutputListener(outputListener);
    }

    public void removePrologStdoutListener(OutputListener outputListener) {
        this.stdoutHandler.removeOutputListener(outputListener);
    }

    public void removePrologStderrListener(OutputListener outputListener) {
        this.stderrHandler.removeOutputListener(outputListener);
    }

    public SubprocessEngine(String string, boolean bl, boolean bl2) {
        super(string, bl, bl2);
        Object object;
        if (System.getProperty("java.version").compareTo("1.3") >= 0) {
            Runtime.getRuntime().addShutdownHook(new 1());
        } else {
            try {
                object = (class$java$lang$System != null ? class$java$lang$System : (class$java$lang$System = SubprocessEngine.class$("java.lang.System"))).getMethod("runFinalizersOnExit", Boolean.TYPE);
                ((Method)object).invoke(null, new Boolean(true));
            }
            catch (Exception exception) {}
        }
        try {
            object = new 2();
            this.promptTrigger.addRecognizerListener((RecognizerListener)object);
            this.breakTrigger.addRecognizerListener((RecognizerListener)object);
            if (string == null) {
                string = this.prologBinDirectoryOrCommand;
            }
            this.prolog = this.createProcess(string);
            this.stdoutHandler = new OutputHandler(this.prolog.getInputStream(), bl ? System.err : null, "stdout");
            this.stderrHandler = new OutputHandler(this.prolog.getErrorStream(), bl ? System.err : null, "stderr");
            this.setDetectPromptAndBreak(true);
            this.stdoutHandler.start();
            this.stderrHandler.start();
            Thread.yield();
            this.prologStdin = new PrintWriter(this.prolog.getOutputStream());
            this.loadInitialFile();
            String string2 = "127.0.0.1";
            this.progressMessage("Allocating the ServerSocket...");
            this.serverSocket = new ServerSocket(0);
            this.progressMessage("server port:" + this.serverSocket.getLocalPort());
            this.command("ipinitialize('" + string2 + "'," + this.serverSocket.getLocalPort() + "," + this.registerJavaObject(this) + "," + bl + ")");
            this.progressMessage("Waiting for the socket to accept...");
            this.socket = this.serverSocket.accept();
            this.progressMessage("Teaching examples to Prolog...");
            PrologOutputObjectStream prologOutputObjectStream = this.buildPrologOutputObjectStream(this.socket.getOutputStream());
            ObjectOutputStream objectOutputStream = prologOutputObjectStream.getObjectStream();
            this.teachIPobjects(objectOutputStream);
            this.teachBasicObjects(objectOutputStream);
            prologOutputObjectStream.flush();
            this.progressMessage("Sent all examples...");
            this.waitUntilAvailable();
            this.setupCallbackServer();
            this.prepareInterrupt(string2);
            this.waitUntilAvailable();
            this.progressMessage("Ended SubprocessEngine constructor");
        }
        catch (IOException iOException) {
            throw new IPException("Could not launch Prolog executable:" + iOException);
        }
    }

    public SubprocessEngine(String string, boolean bl) {
        this(string, bl, true);
    }

    public SubprocessEngine(String string) {
        this(string, false);
    }

    public SubprocessEngine(boolean bl) {
        this(null, bl);
    }

    public SubprocessEngine() {
        this(false);
    }

    protected PrologOutputObjectStream buildPrologOutputObjectStream(OutputStream outputStream) throws IOException {
        return new PrologOutputObjectStream(outputStream);
    }

    protected Process createProcess(String string) throws IOException {
        this.progressMessage("Launching subprocess " + string);
        return Runtime.getRuntime().exec(string);
    }

    public void setDebug(boolean bl) {
        this.stdoutHandler.setDebugStream(bl ? System.err : null);
        this.stderrHandler.setDebugStream(bl ? System.err : null);
        super.setDebug(bl);
    }

    public boolean isAvailable() {
        return this.available;
    }

    protected void setupCallbackServer() {
        this.prologHandler = new 3();
        this.progressMessage("Starting up callback service...");
        this.prologHandler.setName("Prolog handler");
        this.prologHandler.start();
    }

    protected Object receiveObject() throws IOException {
        this.progressMessage("entering receiveObject()");
        Object object = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(this.socket.getInputStream());
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            object = classNotFoundException;
        }
        this.progressMessage("exiting receiveObject():" + object);
        return object;
    }

    protected void sendObject(Object object) throws IOException {
        this.progressMessage("entering sendObject(" + object + ")");
        PrologOutputObjectStream prologOutputObjectStream = this.buildPrologOutputObjectStream(this.socket.getOutputStream());
        prologOutputObjectStream.writeObject(object);
        prologOutputObjectStream.flush();
        this.progressMessage("exiting sendObject(" + object + ")");
    }

    public synchronized void shutdown() {
        super.shutdown();
        this.available = false;
        this.stdoutHandler.setIgnoreStreamEnd(true);
        this.stderrHandler.setIgnoreStreamEnd(true);
        try {
            this.socket.close();
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            throw new IPException("Problems closing sockets:" + iOException);
        }
        if (this.intServerSocket != null) {
            try {
                try {
                    this.intSocket.close();
                    this.intServerSocket.close();
                }
                catch (IOException iOException) {
                    throw new IPException("Problems closing sockets:" + iOException);
                }
                Object var2_4 = null;
                this.prolog.destroy();
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                this.prolog.destroy();
                throw throwable;
            }
        }
        this.prologHandler.interrupt();
    }

    protected void finalize() throws Throwable {
        if (this.prolog != null) {
            this.prolog.destroy();
        }
    }

    protected void setDetectPromptAndBreak(boolean bl) {
        if (bl == this.isDetectingPromptAndBreak()) {
            return;
        }
        if (bl) {
            this.stdoutHandler.addOutputListener(this.promptTrigger);
            this.stdoutHandler.addOutputListener(this.breakTrigger);
            this.stderrHandler.addOutputListener(this.promptTrigger);
            this.stderrHandler.addOutputListener(this.breakTrigger);
        } else {
            this.stdoutHandler.removeOutputListener(this.promptTrigger);
            this.stdoutHandler.removeOutputListener(this.breakTrigger);
            this.stderrHandler.removeOutputListener(this.promptTrigger);
            this.stderrHandler.removeOutputListener(this.breakTrigger);
        }
    }

    protected boolean isDetectingPromptAndBreak() {
        return this.stdoutHandler.hasListener(this.promptTrigger) && this.stdoutHandler.hasListener(this.breakTrigger);
    }

    public synchronized void sendAndFlush(String string) {
        this.available = false;
        this.prologStdin.print(string);
        this.prologStdin.flush();
    }

    public void sendAndFlushLn(String string) {
        this.sendAndFlush(String.valueOf(string) + AbstractPrologEngine.nl);
    }

    protected void prepareInterrupt(String string) throws IOException {
        if (AbstractPrologEngine.isWindowsOS()) {
            this.intServerSocket = new ServerSocket(0);
            this.command("setupWindowsInterrupt('" + string + "'," + this.intServerSocket.getLocalPort() + ")");
            this.intSocket = this.intServerSocket.accept();
        } else {
            this.waitUntilAvailable();
            Object[] objectArray = this.deterministicGoal("getPrologPID(N), ipObjectSpec('java.lang.Integer',Integer,[N],_)", "[Integer]");
            this.progressMessage("Found Prolog process ID");
            if (objectArray != null) {
                this.interruptCommand = "/bin/kill -s INT " + objectArray[0];
            } else {
                throw new IPException("Could not find Prolog's PID");
            }
        }
    }

    protected abstract void doInterrupt();

    public boolean realCommand(String string) {
        this.progressMessage("COMMAND:" + string + ".");
        this.sendAndFlushLn(String.valueOf(string) + ".");
        return true;
    }

    public Object[] deterministicGoal(String string, String string2, Object[] objectArray, String string3) {
        boolean bl = false;
        Object[] objectArray2 = this;
        synchronized (objectArray2) {
            if (!this.topGoalHasStarted) {
                this.topGoalHasStarted = true;
                bl = true;
            }
        }
        if (bl) {
            if (!this.isIdle()) {
                throw new IPException("Inconsistency in deterministicGoal:");
            }
            objectArray2 = this.firstGoal(string, string2, objectArray, string3);
            return objectArray2;
        }
        return super.deterministicGoal(string, string2, objectArray, string3);
    }

    protected Object[] firstGoal(String string, String string2, Object[] objectArray, String string3) {
        Object[] objectArray2 = null;
        int n = this.incGoalTimestamp();
        try {
            try {
                GoalFromJava goalFromJava = this.makeDGoalObject(string, string2, objectArray, string3, n);
                this.progressMessage("Prepared GoalFromJava:" + goalFromJava);
                this.progressMessage("Schedulling (first) goal " + string + ", timestamp " + n + " in thread " + Thread.currentThread().getName());
                GoalToExecute goalToExecute = new GoalToExecute(goalFromJava);
                goalToExecute.setFirstGoalStatus();
                this.scheduleGoal(goalToExecute);
                goalToExecute.prologWasCalled();
                this.pushDGthread(goalToExecute.getCallerThread());
                this.sendObject(goalFromJava);
                this.realCommand("deterministicGoal");
                ResultFromProlog resultFromProlog = goalToExecute.waitForResult();
                this.progressMessage("got dG result for timestamp " + n);
                if (resultFromProlog == null) {
                    throw new IPException("Problems in goal result");
                }
                if (goalToExecute.wasAborted()) {
                    throw new IPAbortedException(String.valueOf(string) + " was aborted");
                }
                if (goalToExecute.wasInterrupted()) {
                    throw new IPInterruptedException(String.valueOf(string) + " was interrupted");
                }
                if (resultFromProlog.wasInterrupted(this)) {
                    throw new IPInterruptedException(String.valueOf(string) + " was interrupted, Prolog detected");
                }
                if (resultFromProlog.error != null) {
                    throw new IPPrologError(resultFromProlog.error);
                }
                if (resultFromProlog.timestamp != n) {
                    throw new IPException("bad timestamp in deterministicGoal, got " + resultFromProlog.timestamp + " instead of " + this.goalTimestamp);
                }
                if (resultFromProlog.succeeded) {
                    objectArray2 = resultFromProlog.rVars;
                }
            }
            catch (IPException iPException) {
                throw iPException;
            }
            catch (Exception exception) {
                throw new IPException("Problem in deterministicGoal:" + exception);
            }
            Object var8_12 = null;
            this.topGoalHasStarted = false;
            this.progressMessage("Leaving firstGoal for " + string + ", timestamp " + n + " isIdle()==" + this.isIdle());
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            this.topGoalHasStarted = false;
            this.progressMessage("Leaving firstGoal for " + string + ", timestamp " + n + " isIdle()==" + this.isIdle());
            throw throwable;
        }
        return objectArray2;
    }

    protected Object doSomething() {
        if (this.onlyFirstGoalSchedulled()) {
            return null;
        }
        return super.doSomething();
    }

    protected synchronized boolean onlyFirstGoalSchedulled() {
        return this.isIdle() || this.messagesExecuting.size() == 0 && this.goalsToExecute.size() == 1 && ((GoalToExecute)this.goalsToExecute.elementAt(0)).isFirstGoal();
    }

    protected void setupErrorHandling() {
        this.setDetectPromptAndBreak(false);
        this.stderrHandler.addOutputListener(this.errorTrigger);
        this.abortMessage = "";
        Thread thread = Thread.currentThread();
        this.errorHandler = new 4(thread, this);
        this.errorTrigger.addRecognizerListener(this.errorHandler);
    }

    protected void removeErrorHandling() {
        this.errorTrigger.removeRecognizerListener(this.errorHandler);
        this.stderrHandler.removeOutputListener(this.errorTrigger);
        this.errorHandler = null;
        this.setDetectPromptAndBreak(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ String access$0(SubprocessEngine subprocessEngine) {
        return subprocessEngine.abortMessage;
    }

    static class ClientRecognizer
    extends Recognizer
    implements RecognizerListener {
        PrologOutputListener client;

        ClientRecognizer(PrologOutputListener prologOutputListener) {
            this.client = prologOutputListener;
            this.addRecognizerListener(this);
        }

        public void recognized(Recognizer recognizer, Object object) {
            this.client.print((String)object);
        }
    }

    private final class 1
    extends Thread {
        public void run() {
            if (SubprocessEngine.this.prolog != null) {
                SubprocessEngine.this.prolog.destroy();
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements RecognizerListener {
        public void recognized(Recognizer recognizer, Object object) {
            SubprocessEngine.this.available = true;
            SubprocessEngine.this.progressMessage("I'm available! source:" + recognizer + " extra:" + object);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends Thread {
        public void run() {
            block3: {
                try {
                    while (!SubprocessEngine.this.shutingDown) {
                        SubprocessEngine.this.progressMessage("Waiting to receive object");
                        Object object = SubprocessEngine.this.receiveObject();
                        SubprocessEngine.this.progressMessage("Received object:" + object);
                        Object object2 = SubprocessEngine.this.handleCallback(object);
                        SubprocessEngine.this.progressMessage("Handled object and computed:" + object2);
                        if (object2 == null) continue;
                        SubprocessEngine.this.sendObject(object2);
                    }
                }
                catch (IOException iOException) {
                    if (SubprocessEngine.this.shutingDown) break block3;
                    IPException iPException = new IPException("Bad exception in setupCallbackServer", iOException);
                    SubprocessEngine.this.endAllTasks(iPException);
                    throw iPException;
                }
            }
        }

        /* synthetic */ 3() {
        }
    }

    private static final class 4
    implements RecognizerListener {
        private final /* synthetic */ Thread val$current;
        private final /* synthetic */ SubprocessEngine this$0;

        public void recognized(Recognizer recognizer, Object object) {
            this.this$0.abortMessage = (String)object;
            this.val$current.interrupt();
        }

        /* synthetic */ 4(Thread thread, SubprocessEngine subprocessEngine) {
            this.val$current = thread;
            this.this$0 = subprocessEngine;
        }
    }
}

