/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.rundeck.client.util.Json;
import org.rundeck.client.util.Xml;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class QualifiedTypeConverterFactory
extends Converter.Factory {
    private final Converter.Factory jsonFactory;
    private final Converter.Factory xmlFactory;
    private final Converter.Factory defaultFactory;

    public QualifiedTypeConverterFactory(Converter.Factory jsonFactory, Converter.Factory xmlFactory, boolean defaultJson) {
        this.jsonFactory = jsonFactory;
        this.xmlFactory = xmlFactory;
        this.defaultFactory = defaultJson ? jsonFactory : xmlFactory;
    }

    @Override
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        for (Annotation annotation : annotations) {
            if (annotation instanceof Json) {
                return this.jsonFactory.responseBodyConverter(type, annotations, retrofit);
            }
            if (!(annotation instanceof Xml)) continue;
            return this.xmlFactory.responseBodyConverter(type, annotations, retrofit);
        }
        return this.defaultFactory.responseBodyConverter(type, annotations, retrofit);
    }

    @Override
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        for (Annotation annotation : parameterAnnotations) {
            if (annotation instanceof Json) {
                return this.jsonFactory.requestBodyConverter(type, parameterAnnotations, methodAnnotations, retrofit);
            }
            if (!(annotation instanceof Xml)) continue;
            return this.xmlFactory.requestBodyConverter(type, parameterAnnotations, methodAnnotations, retrofit);
        }
        return this.defaultFactory.requestBodyConverter(type, parameterAnnotations, methodAnnotations, retrofit);
    }
}

