package net.sourceforge.ufoai.md2viewer.util;

public class Vector2 {
    private final float x;
    private final float y;

    public Vector2(float x, float y) {
	this.x = x;
	this.y = y;
    }

    public float getX() {
	return x;
    }

    public float getY() {
	return y;
    }

    public float[] getFloats() {
	return new float[] { x, y };
    }

    @Override
    public String toString() {
	return "Vector2 [x=" + x + ", y=" + y + "]";
    }

    @Override
    public int hashCode() {
	final int prime = 31;
	int result = 1;
	result = prime * result + Float.floatToIntBits(x);
	result = prime * result + Float.floatToIntBits(y);
	return result;
    }

    @Override
    public boolean equals(Object obj) {
	if (this == obj)
	    return true;
	if (obj == null)
	    return false;
	if (getClass() != obj.getClass())
	    return false;
	Vector2 other = (Vector2) obj;
	if (Float.floatToIntBits(x) != Float.floatToIntBits(other.x))
	    return false;
	if (Float.floatToIntBits(y) != Float.floatToIntBits(other.y))
	    return false;
	return true;
    }
}
