/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.data;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import jrm.profile.Profile;
import jrm.profile.data.Anyware;
import jrm.profile.data.Entity;
import jrm.profile.data.EntityStatus;
import jrm.profile.data.NameBase;
import jrm.profile.data.Software;
import jrm.xml.EnhancedXMLStreamWriter;
import jrm.xml.SimpleAttribute;

public class Rom
extends Entity
implements Serializable {
    public String bios = null;
    public Integer offset = null;
    public LoadFlag loadflag = null;
    public String value = null;
    public boolean optional = false;
    public String region = null;
    public String date = null;

    public Rom(Anyware parent) {
        super(parent);
    }

    @Override
    public String getName() {
        if (Anyware.merge_mode.isMerge()) {
            if (this.merge == null) {
                if (this.isCollisionMode(false) && this.getParent().isClone()) {
                    return this.parent.name + "/" + this.name;
                }
            } else if (!Profile.curr_profile.getProperty("ignore_merge_name_roms", false)) {
                return this.merge;
            }
        }
        return this.name;
    }

    public String getFullName() {
        if (Anyware.merge_mode.isMerge()) {
            if (this.merge != null && !Profile.curr_profile.getProperty("ignore_merge_name_roms", false)) {
                return this.parent.name + "/" + this.merge;
            }
            return this.parent.name + "/" + this.name;
        }
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rom) {
            if (((Rom)obj).sha1 != null && this.sha1 != null) {
                return ((Rom)obj).sha1.equals(this.sha1);
            }
            if (((Rom)obj).md5 != null && this.md5 != null) {
                return ((Rom)obj).md5.equals(this.md5);
            }
            if (((Rom)obj).crc != null && this.crc != null) {
                return ((Rom)obj).crc.equals(this.crc) && ((Rom)obj).size == this.size;
            }
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.sha1 != null) {
            return this.sha1.hashCode();
        }
        if (this.md5 != null) {
            return this.md5.hashCode();
        }
        if (this.crc != null) {
            return this.crc.hashCode();
        }
        return super.hashCode();
    }

    public String hashString() {
        if (this.sha1 != null) {
            return this.sha1;
        }
        if (this.md5 != null) {
            return this.md5;
        }
        if (this.crc != null) {
            return this.crc;
        }
        return this.getName();
    }

    public static Map<String, Rom> getRomsByName(List<Rom> roms) {
        return roms.stream().collect(Collectors.toMap(NameBase::getNormalizedName, r -> r, (n, r) -> n));
    }

    private static EntityStatus findRomStatus(Anyware parent, Rom rom) {
        for (Rom r : parent.roms) {
            if (rom == r || !rom.equals(r) || r.own_status == EntityStatus.UNKNOWN) continue;
            return r.own_status;
        }
        if (parent.parent != null) {
            if (Anyware.merge_mode.isMerge()) {
                for (Anyware clone : parent.getParent().clones.values()) {
                    if (clone == parent) continue;
                    for (Rom r : clone.roms) {
                        if (!rom.equals(r) || r.own_status == EntityStatus.UNKNOWN) continue;
                        return r.own_status;
                    }
                }
            }
            for (Rom r : parent.getParent().roms) {
                if (!rom.equals(r)) continue;
                return r.getStatus();
            }
            if (parent.parent.parent != null) {
                return Rom.findRomStatus(parent.getParent(), rom);
            }
        } else if (parent.isRomOf() && rom.merge != null) {
            return EntityStatus.OK;
        }
        return null;
    }

    @Override
    public EntityStatus getStatus() {
        EntityStatus status;
        if (this.name.isEmpty()) {
            return EntityStatus.OK;
        }
        if (this.status == Entity.Status.nodump) {
            return EntityStatus.OK;
        }
        if (this.own_status == EntityStatus.UNKNOWN && (status = Rom.findRomStatus(this.getParent(), this)) != null) {
            return status;
        }
        return this.own_status;
    }

    public void export(EnhancedXMLStreamWriter writer, boolean is_mame) throws XMLStreamException, IOException {
        if (this.parent instanceof Software) {
            writer.writeElement("rom", new SimpleAttribute("name", this.name), new SimpleAttribute("size", this.size), new SimpleAttribute("crc", this.crc), new SimpleAttribute("sha1", this.sha1), new SimpleAttribute("merge", this.merge), new SimpleAttribute("status", this.status.getXML(is_mame)), new SimpleAttribute("value", this.value), new SimpleAttribute("loadflag", this.loadflag), new SimpleAttribute("offset", this.offset == null ? null : "0x" + Integer.toHexString(this.offset)));
        } else if (is_mame) {
            writer.writeElement("rom", new SimpleAttribute("name", this.name), new SimpleAttribute("bios", this.bios), new SimpleAttribute("size", this.size), new SimpleAttribute("crc", this.crc), new SimpleAttribute("sha1", this.sha1), new SimpleAttribute("merge", this.merge), new SimpleAttribute("status", this.status.getXML(is_mame)), new SimpleAttribute("optional", this.optional ? "yes" : null), new SimpleAttribute("region", this.region), new SimpleAttribute("offset", this.offset == null ? null : "0x" + Integer.toHexString(this.offset)));
        } else {
            writer.writeElement("rom", new SimpleAttribute("name", this.name), new SimpleAttribute("size", this.size), new SimpleAttribute("crc", this.crc), new SimpleAttribute("sha1", this.sha1), new SimpleAttribute("md5", this.md5), new SimpleAttribute("merge", this.merge), new SimpleAttribute("status", this.status.getXML(is_mame)), new SimpleAttribute("date", this.date));
        }
    }

    public static enum LoadFlag implements Serializable
    {
        LOAD16_BYTE,
        LOAD16_WORD,
        LOAD16_WORD_SWAP,
        LOAD32_BYTE,
        LOAD32_WORD,
        LOAD32_WORD_SWAP,
        LOAD32_DWORD,
        LOAD64_WORD,
        LOAD64_WORD_SWAP,
        RELOAD,
        FILL,
        CONTINUE,
        RELOAD_PLAIN,
        IGNORE;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static LoadFlag getEnum(String value) {
            for (LoadFlag v : LoadFlag.values()) {
                if (!v.name().equalsIgnoreCase(value)) continue;
                return v;
            }
            throw new IllegalArgumentException();
        }
    }
}

