/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.table.TableCellRenderer;
import javax.xml.stream.XMLStreamException;
import jrm.locale.Messages;
import jrm.profile.Profile;
import jrm.profile.data.AnywareList;
import jrm.profile.data.AnywareStatus;
import jrm.profile.data.NameBase;
import jrm.profile.data.Software;
import jrm.profile.data.Systm;
import jrm.ui.profile.data.SoftwareListRenderer;
import jrm.ui.progress.ProgressHandler;
import jrm.xml.EnhancedXMLStreamWriter;
import jrm.xml.SimpleAttribute;

public final class SoftwareList
extends AnywareList<Software>
implements Systm,
Serializable {
    public final StringBuffer description = new StringBuffer();
    private final List<Software> s_list = new ArrayList<Software>();
    private final Map<String, Software> s_byname = new HashMap<String, Software>();
    private transient Map<String, Software> s_filtered_byname = null;

    public SoftwareList() {
        this.initTransient();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransient();
    }

    @Override
    protected void initTransient() {
        super.initTransient();
    }

    @Override
    public boolean add(Software software) {
        software.sl = this;
        this.s_byname.put(software.name, software);
        return this.s_list.add(software);
    }

    @Override
    public int getColumnCount() {
        return SoftwareListRenderer.columns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return SoftwareListRenderer.columns[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return SoftwareListRenderer.columnsTypes[columnIndex];
    }

    @Override
    public TableCellRenderer getColumnRenderer(int columnIndex) {
        return SoftwareListRenderer.columnsRenderers[columnIndex];
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        return SoftwareListRenderer.columnsWidths[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.getFilteredList().size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Software software = this.getFilteredList().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return software;
            }
            case 1: {
                return software;
            }
            case 2: {
                return software.description.toString();
            }
            case 3: {
                return String.format("%d/%d", software.countHave(), software.roms.size() + software.disks.size());
            }
            case 4: {
                return software.cloneof != null ? this.s_byname.get(software.cloneof) : null;
            }
            case 5: {
                return software.selected;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 5;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 5 && aValue instanceof Boolean) {
            Software software = this.getFilteredList().get(rowIndex);
            software.selected = (Boolean)aValue;
        }
    }

    @Override
    public List<Software> getList() {
        return this.s_list;
    }

    @Override
    public Systm.Type getType() {
        return Systm.Type.SOFTWARELIST;
    }

    @Override
    public Systm getSystem() {
        return this;
    }

    @Override
    public String toString() {
        return "[" + (Object)((Object)this.getType()) + "] " + this.description.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Stream<Software> getFilteredStream() {
        boolean filterIncludeClones = Profile.curr_profile.getProperty("filter.InclClones", true);
        boolean filterIncludeDisks = Profile.curr_profile.getProperty("filter.InclDisks", true);
        Software.Supported filterMinSoftwareSupportedLevel = Software.Supported.valueOf(Profile.curr_profile.getProperty("filter.MinSoftwareSupportedLevel", Software.Supported.no.toString()));
        String filterYearMin = Profile.curr_profile.getProperty("filter.YearMin", "");
        String filterYearMax = Profile.curr_profile.getProperty("filter.YearMax", "????");
        return this.getList().stream().filter(t -> {
            if (t.year.length() > 0) {
                if (filterYearMin.compareTo(t.year.toString()) > 0) {
                    return false;
                }
                if (filterYearMax.compareTo(t.year.toString()) < 0) {
                    return false;
                }
            }
            if (filterMinSoftwareSupportedLevel == Software.Supported.partial && t.supported == Software.Supported.no) {
                return false;
            }
            if (filterMinSoftwareSupportedLevel == Software.Supported.yes && t.supported != Software.Supported.yes) {
                return false;
            }
            if (!filterIncludeClones && t.isClone()) {
                return false;
            }
            if (!filterIncludeDisks && t.disks.size() > 0) {
                return false;
            }
            return t.getSystem().isSelected();
        });
    }

    @Override
    protected List<Software> getFilteredList() {
        if (this.filtered_list == null) {
            this.filtered_list = this.getFilteredStream().filter(t -> AnywareList.filter.contains(t.getStatus())).sorted().collect(Collectors.toList());
        }
        return this.filtered_list;
    }

    @Override
    public long countAll() {
        return this.getFilteredStream().count();
    }

    @Override
    public long countHave() {
        return this.getFilteredStream().filter(t -> t.getStatus() == AnywareStatus.COMPLETE).count();
    }

    public void export(EnhancedXMLStreamWriter writer, boolean filtered, ProgressHandler progress) throws XMLStreamException, IOException {
        writer.writeStartElement("softwarelist", new SimpleAttribute("name", this.name), new SimpleAttribute("description", this.description));
        List<Software> list = filtered ? this.getFilteredStream().collect(Collectors.toList()) : this.getList();
        for (Software s : list) {
            progress.setProgress(String.format(Messages.getString("SoftwareList.Exporting_%s"), s.getFullName()), progress.getValue() + 1);
            if (filtered && !s.selected) continue;
            s.export(writer, null);
        }
        writer.writeEndElement();
    }

    @Override
    public boolean containsName(String name) {
        return this.s_byname.containsKey(name);
    }

    @Override
    public Software getByName(String name) {
        return this.s_byname.get(name);
    }

    @Override
    public Software putByName(Software t) {
        return this.s_byname.put(t.name, t);
    }

    @Override
    public void resetFilteredName() {
        this.s_filtered_byname = this.getFilteredStream().collect(Collectors.toMap(NameBase::getBaseName, Function.identity()));
    }

    @Override
    public boolean containsFilteredName(String name) {
        if (this.s_filtered_byname == null) {
            this.resetFilteredName();
        }
        return this.s_filtered_byname.containsKey(name);
    }

    @Override
    public Software getFilteredByName(String name) {
        if (this.s_filtered_byname == null) {
            this.resetFilteredName();
        }
        return this.s_filtered_byname.get(name);
    }

    @Override
    public TableCellRenderer[] getCellRenderers() {
        return SoftwareListRenderer.columnsRenderers;
    }
}

