/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.basic;

import java.awt.Color;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import jrm.ui.basic.JFileDropMode;

public class JFileDropList
extends JList<File>
implements DropTargetListener {
    private final Color color;
    private final AddDelCallBack addCallBack;
    private JFileDropMode mode = JFileDropMode.FILE;
    private FilenameFilter filter = null;

    public JFileDropList(AddDelCallBack addCallBack) {
        super(new DefaultListModel());
        this.color = this.getBackground();
        this.addCallBack = addCallBack;
        new DropTarget(this, this);
    }

    public void setMode(JFileDropMode mode) {
        this.mode = mode;
    }

    public void setFilter(FilenameFilter filter) {
        this.filter = filter;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        Transferable transferable = dtde.getTransferable();
        if (this.isEnabled() && transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            this.setBackground(Color.decode("#DDFFDD"));
            dtde.acceptDrag(1);
        } else {
            this.setBackground(Color.decode("#FFDDDD"));
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.setBackground(this.color);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        this.setBackground(this.color);
        try {
            Transferable transferable = dtde.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(1);
                List<File> files = ((List)transferable.getTransferData(DataFlavor.javaFileListFlavor)).stream().filter(f -> {
                    if (this.mode == JFileDropMode.DIRECTORY && !f.isDirectory()) {
                        return false;
                    }
                    if (this.mode == JFileDropMode.FILE && !f.isFile()) {
                        return false;
                    }
                    if (this.filter != null) {
                        return this.filter.accept(f.getParentFile(), f.getName());
                    }
                    return true;
                }).collect(Collectors.toList());
                if (files.size() > 0) {
                    this.add(files);
                    dtde.getDropTargetContext().dropComplete(true);
                } else {
                    dtde.getDropTargetContext().dropComplete(false);
                }
            } else {
                dtde.rejectDrop();
            }
        }
        catch (UnsupportedFlavorException e) {
            dtde.rejectDrop();
        }
        catch (Exception e) {
            dtde.rejectDrop();
        }
    }

    public void add(List<File> files) {
        for (File file : files) {
            ((DefaultListModel)this.getModel()).addElement(file);
        }
        this.addCallBack.call(Collections.list(((DefaultListModel)this.getModel()).elements()));
    }

    public void add(File[] files) {
        for (File file : files) {
            ((DefaultListModel)this.getModel()).addElement(file);
        }
        this.addCallBack.call(Collections.list(((DefaultListModel)this.getModel()).elements()));
    }

    public void del(List<File> files) {
        for (File file : files) {
            ((DefaultListModel)this.getModel()).removeElement(file);
        }
        this.addCallBack.call(Collections.list(((DefaultListModel)this.getModel()).elements()));
    }

    public void del(File[] files) {
        for (File file : files) {
            ((DefaultListModel)this.getModel()).removeElement(file);
        }
        this.addCallBack.call(Collections.list(((DefaultListModel)this.getModel()).elements()));
    }

    @Override
    public DefaultListModel<File> getModel() {
        return (DefaultListModel)super.getModel();
    }

    @FunctionalInterface
    public static interface AddDelCallBack {
        public void call(List<File> var1);
    }
}

