/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.argo.uml.diagram.ui;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Vector;
import org.argouml.uml.diagram.deployment.ui.FigComponent;
import org.dbuml.argo.uml.diagram.ui.DBFigure;
import org.dbuml.argo.uml.ui.ActionConnectRegistry;
import org.dbuml.argo.uml.ui.ActionImportDatabases;
import org.dbuml.argo.uml.ui.ActionUpdateCatalog;
import org.dbuml.base.i18n.Translator;
import org.dbuml.base.model.DBModelFacade;
import org.dbuml.base.model.Registry;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.undo.UndoableAction;

public class FigRegistry
extends FigComponent
implements DBFigure {
    private static Color filler = new Color(120, 120, 255);

    public FigRegistry(GraphModel gm, Object node) {
        super(gm, node);
        this.setFillColor(filler);
    }

    public FigRegistry() {
        this.setFillColor(filler);
    }

    public Vector getAdditionalPopUpActions() {
        boolean connected;
        Vector<UndoableAction> popUpActions = new Vector<UndoableAction>();
        Registry registry = DBModelFacade.getInstance().getRegistry(this.getOwner());
        ActionConnectRegistry actionConnect = ActionConnectRegistry.SINGLETON;
        String connectLabel = Translator.getInstance().localize("CONNECT_REGISTRY");
        boolean bl = connected = registry != null && registry.isConnected();
        if (connected) {
            connectLabel = Translator.getInstance().localize("DISCONNECT_REGISTRY");
        }
        actionConnect.putValue("Name", connectLabel);
        actionConnect.putValue("ShortDescription", connectLabel);
        popUpActions.addElement(actionConnect);
        popUpActions.addElement(ActionImportDatabases.SINGLETON);
        popUpActions.addElement(ActionUpdateCatalog.SINGLETON);
        return popUpActions;
    }

    public Vector getPopUpActions(MouseEvent me) {
        Vector popUpActions = super.getPopUpActions(me);
        popUpActions.addAll(this.getAdditionalPopUpActions());
        return popUpActions;
    }

    public void updateLineColor() {
        if (this.isConnected()) {
            this.setLineColor(Color.GREEN);
        } else {
            this.setLineColor(Color.BLACK);
        }
    }

    private boolean isConnected() {
        Registry registry = DBModelFacade.getInstance().getOwningRegistry(this.getOwner());
        return registry != null && registry.isConnected();
    }

    public void postLoad() {
        super.postLoad();
        this.updateLineColor();
    }

    public String placeString() {
        return "new " + this.getDBFigName();
    }

    public String getTipString(MouseEvent me) {
        return this.getDBFigName() + ": " + this.getName();
    }

    public String getDBFigName() {
        return "Registry";
    }
}

