/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.Language;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleChainVisitor;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.ast.CompilationUnit;
import net.sourceforge.pmd.ast.JavaRuleChainVisitor;
import net.sourceforge.pmd.jsp.ast.JspRuleChainVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleChain {
    private final Map<Language, RuleChainVisitor> languageToRuleChainVisitor = new HashMap<Language, RuleChainVisitor>();

    public void add(RuleSet ruleSet) {
        Language language = ruleSet.getLanguage();
        for (Rule r : ruleSet.getRules()) {
            this.add(language, r);
        }
    }

    public void add(Language language, Rule rule) {
        RuleChainVisitor visitor = this.getRuleChainVisitor(language);
        if (visitor != null) {
            visitor.add(rule);
        }
    }

    public void apply(List<CompilationUnit> astCompilationUnits, RuleContext ctx, Language language) {
        RuleChainVisitor visitor = this.getRuleChainVisitor(language);
        if (visitor != null) {
            visitor.visitAll(astCompilationUnits, ctx);
        }
    }

    private RuleChainVisitor getRuleChainVisitor(Language language) {
        RuleChainVisitor visitor;
        if (language == null) {
            language = Language.JAVA;
        }
        if ((visitor = this.languageToRuleChainVisitor.get(language)) == null) {
            if (Language.JAVA.equals(language)) {
                visitor = new JavaRuleChainVisitor();
            } else if (Language.JSP.equals(language)) {
                visitor = new JspRuleChainVisitor();
            } else {
                throw new IllegalArgumentException("Unknown language: " + language);
            }
            this.languageToRuleChainVisitor.put(language, visitor);
        }
        return visitor;
    }
}

