/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.basics.component;

import com.jgoodies.app.gui.basics.component.OpenMonthViewPopupAction;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.components.JGFormattedTextField;
import com.jgoodies.components.JGPasswordField;
import com.jgoodies.components.JGSearchField;
import com.jgoodies.components.JGStripedTable;
import com.jgoodies.components.JGTextArea;
import com.jgoodies.components.JGTextField;
import com.jgoodies.components.internal.TextFieldIcons;
import com.jgoodies.components.renderer.JGDisplayableListCellRenderer;
import com.jgoodies.dialogs.core.CoreDialogResources;
import com.jgoodies.search.CompletionManager;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.text.JTextComponent;

public class AppComponentFactory
extends JGComponentFactory {
    private static final boolean ICON_VISIBLE_ALWAYS = true;
    private static final boolean PROMPT_VISIBLE_WHEN_FOCUSED = true;

    protected AppComponentFactory() {
    }

    public static void installAsCurrent() {
        JGComponentFactory.setCurrent(new AppComponentFactory());
    }

    public static AppComponentFactory getCurrent() {
        return (AppComponentFactory)JGComponentFactory.getCurrent();
    }

    public static void activateOnMouseOver(JTextComponent c) {
        TextComponentRolloverHandler handler = new TextComponentRolloverHandler(c);
        c.addFocusListener(handler);
        c.addMouseListener(handler);
    }

    @Override
    public JGFormattedTextField createDateField() {
        JGFormattedTextField field = super.createDateField();
        field.setIconAction(new OpenMonthViewPopupAction(field));
        field.setButtonPaintedAlways(true);
        return field;
    }

    public JGFormattedTextField createBirthdayField() {
        return this.createDateField();
    }

    @Override
    public <E> JGStripedTable<E> createTable() {
        JGStripedTable table = super.createTable();
        table.setAutoCreateRowSorter(true);
        return table;
    }

    public JButton createOKButton() {
        return this.createButton(CoreDialogResources.getPlainString("common.ok"));
    }

    public <E> JComboBox<E> createDisplayableComboBox(E ... items) {
        return this.createComboBox(JGDisplayableListCellRenderer.INSTANCE, items);
    }

    @Override
    protected void configure(JGTextArea area) {
        area.setPromptVisibleWhenFocused(true);
    }

    @Override
    protected void configure(JGTextField field) {
        field.setIconVisibleAlways(true);
        field.setPromptVisibleWhenFocused(true);
    }

    @Override
    protected void configure(JGFormattedTextField field) {
        field.setIconVisibleAlways(true);
        field.setPromptVisibleWhenFocused(true);
        field.addPropertyChangeListener("editValid", evt -> field.setErrorUnderlinePainted(!field.isEditValid()));
    }

    @Override
    protected void configure(JGPasswordField field) {
        field.setIconVisibleAlways(true);
        field.setPromptVisibleWhenFocused(true);
    }

    @Override
    protected void configure(JGSearchField field) {
        field.setPromptVisibleWhenFocused(true);
    }

    protected <E> JComboBox<E> createComboBoxWithDisplayableRenderer() {
        return this.createComboBox(JGDisplayableListCellRenderer.INSTANCE, (E[])new Object[0]);
    }

    protected JGTextField createCompletionField() {
        JGTextField field = this.createTextField();
        field.setIcon(TextFieldIcons.getSearchIcon());
        field.setIconVisibleAlways(true);
        return field;
    }

    protected JGTextField createCompletionField(CompletionManager manager) {
        JGTextField field = this.createCompletionField();
        manager.install(field);
        return field;
    }

    protected JGTextField createOperationField() {
        JGTextField field = this.createTextField();
        field.setIcon(TextFieldIcons.getEllipsisIcon());
        field.setButtonPaintedAlways(true);
        field.setJGFocusTraversable(true);
        return field;
    }

    public static final class BackgroundRolloverHandler
    extends MouseAdapter
    implements FocusListener {
        private boolean mouseOver;

        public BackgroundRolloverHandler(JTextComponent c) {
            c.setBackground(Color.WHITE);
        }

        @Override
        public void focusGained(FocusEvent evt) {
            this.updateDecoration(evt);
        }

        @Override
        public void focusLost(FocusEvent evt) {
            JTextComponent c = (JTextComponent)evt.getSource();
            this.updateDecoration(c);
            c.select(0, 0);
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            this.mouseOver = true;
            this.updateDecoration(evt);
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            this.mouseOver = false;
            this.updateDecoration(evt);
        }

        private void updateDecoration(EventObject evt) {
            this.updateDecoration((JTextComponent)evt.getSource());
        }

        private void updateDecoration(JTextComponent c) {
            boolean active = c.hasFocus() || this.mouseOver;
            c.setOpaque(active);
        }
    }

    public static final class ButtonRolloverHandler
    extends MouseAdapter
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent evt) {
            ButtonRolloverHandler.updateDecoration(evt);
        }

        @Override
        public void focusLost(FocusEvent evt) {
            ButtonRolloverHandler.updateDecoration(evt);
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            ButtonRolloverHandler.updateDecoration(evt);
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            ButtonRolloverHandler.updateDecoration(evt);
        }

        private static void updateDecoration(EventObject evt) {
            AbstractButton b = (AbstractButton)evt.getSource();
            boolean active = b.hasFocus() || b.getModel().isRollover() || b.isSelected();
            b.setContentAreaFilled(active);
        }
    }

    public static final class TextComponentRolloverHandler
    extends MouseAdapter
    implements FocusListener {
        private final Border originalBorder;
        private final Border replacementBorder;
        private boolean mouseOver;

        TextComponentRolloverHandler(JTextComponent c) {
            this.originalBorder = c.getBorder();
            this.replacementBorder = new CompoundBorder(new EmptyBorder(1, 1, 1, 1), new BasicBorders.MarginBorder());
            this.updateDecoration(c);
        }

        @Override
        public void focusGained(FocusEvent evt) {
            this.updateDecoration(evt);
        }

        @Override
        public void focusLost(FocusEvent evt) {
            JTextComponent c = (JTextComponent)evt.getSource();
            this.updateDecoration(c);
            c.select(0, 0);
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            this.mouseOver = true;
            this.updateDecoration(evt);
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            this.mouseOver = false;
            this.updateDecoration(evt);
        }

        private void updateDecoration(EventObject evt) {
            this.updateDecoration((JTextComponent)evt.getSource());
        }

        private void updateDecoration(JTextComponent c) {
            boolean active = c.hasFocus() || this.mouseOver;
            c.setOpaque(active);
            c.setBorder(active ? this.originalBorder : this.replacementBorder);
        }
    }
}

