/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.basics.format;

import com.jgoodies.app.domain.CodeName;
import com.jgoodies.app.domain.address.BaseAddress;
import com.jgoodies.app.domain.contact.ContactData;
import com.jgoodies.app.domain.user.UserAccount;
import com.jgoodies.app.domain.user.UserRole;
import com.jgoodies.app.gui.basics.format.RelativeDateFormat;
import com.jgoodies.app.gui.basics.format.RelativeDateTimeFormat;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.internal.DateUtils;
import com.jgoodies.common.jsdl.internal.CommonFormats;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

public class AppFormats
extends CommonFormats {
    public static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(3);
    private static final DateFormat SHORTCUT_DATE_FORMAT = new RelativeDateFormat(DATE_FORMAT, true, true);
    private static final DateFormat TIME_FORMAT = DateFormat.getTimeInstance(3);
    private static final DateFormat DATE_TIME_FORMAT = DateFormat.getDateTimeInstance(3, 3);
    private static final DateFormat SHORTCUT_DATE_TIME_FORMAT = new RelativeDateTimeFormat(SHORTCUT_DATE_FORMAT, TIME_FORMAT);

    protected AppFormats() {
    }

    public static String formatDate(LocalDate date) {
        if (AppFormats.isGerman(Locale.getDefault())) {
            return AppFormats.formatTypoDate(date);
        }
        return AppFormats.formatDate(date, false);
    }

    public static String formatDate(LocalDate date, boolean shortcuts) {
        if (date == null) {
            return "";
        }
        return (shortcuts ? SHORTCUT_DATE_FORMAT : DATE_FORMAT).format(DateUtils.toDate(date));
    }

    public static String formatDate(LocalDateTime dateTime, boolean shortcuts) {
        if (dateTime == null) {
            return "";
        }
        return AppFormats.formatDate(dateTime.toLocalDate(), shortcuts);
    }

    public static String formatDateTime(LocalDateTime dateTime, boolean shortcuts) {
        if (dateTime == null) {
            return "";
        }
        return (shortcuts ? SHORTCUT_DATE_TIME_FORMAT : DATE_TIME_FORMAT).format(DateUtils.toDate(dateTime));
    }

    public static String formatTime(LocalDateTime time) {
        if (time == null) {
            return "";
        }
        return TIME_FORMAT.format(DateUtils.toDate(time));
    }

    public static String formatTypoDate(LocalDate date) {
        if (date == null) {
            return "";
        }
        if (!AppFormats.isGerman(Locale.getDefault())) {
            return AppFormats.formatDate(date, false);
        }
        return String.format("%1$te.\u202f%2$d.\u202f%1$tY", date, date.getMonthValue());
    }

    public static String formatTypoDateShort(LocalDate date) {
        if (date == null) {
            return "";
        }
        if (!AppFormats.isGerman(Locale.getDefault())) {
            return AppFormats.formatDate(date, false);
        }
        if (DateUtils.isThisYear(date)) {
            return String.format("%1$te.\u202f%2$d.", date, date.getMonthValue());
        }
        return String.format("%1$te.\u202f%2$d.\u202f%1$ty", date, date.getMonthValue());
    }

    public static String formatTypoDateAbbreviated(LocalDate date) {
        if (date == null) {
            return "";
        }
        if (!AppFormats.isGerman(Locale.getDefault())) {
            return AppFormats.formatDate(date);
        }
        if (DateUtils.isToday(date)) {
            return "Heute";
        }
        if (DateUtils.isThisWeek(date)) {
            return String.format("%ta", date);
        }
        if (DateUtils.isThisMonth(date)) {
            return String.format("%1$ta %1$te.", date);
        }
        return AppFormats.formatTypoDateShort(date);
    }

    public static String formatTypoDateAbbreviated(LocalDateTime date) {
        if (date == null) {
            return "";
        }
        return AppFormats.formatTypoDateAbbreviated(date.toLocalDate()) + ' ' + AppFormats.formatTime(date);
    }

    public static String formatTypoTimeFromTo(String from, String to) {
        return String.format("%1$s\u202f\u2013\u202f%2$s\u202fUhr", from, to);
    }

    public static String formatTypoTimeFromToShort(String from, String to) {
        return String.format("%1$s\u202f\u2013\u202f%2$s", from, to);
    }

    public static String formatMonth(LocalDate date) {
        if (date == null) {
            return "";
        }
        int month = date.getMonthValue();
        int year = date.getYear();
        return String.format("%1$d/%2$d", month, year);
    }

    public static String formatCode(CodeName object) {
        return object == null ? "" : object.getCode();
    }

    public static String formatName(CodeName object) {
        return object == null ? "" : object.getName();
    }

    public static String formatCodeName(CodeName object) {
        return object == null ? "" : object.getCode() + " - " + object.getName();
    }

    public static String formatAddress(Optional<BaseAddress<?>> address, String defaultLine1) {
        return address.isPresent() ? AppFormats.formatAddress(address.get(), defaultLine1) : "";
    }

    public static String formatAddress(BaseAddress<?> address, String defaultLine1) {
        if (address == null) {
            return "";
        }
        boolean hasCountry = address.getCountry() != null && Strings.isNotBlank(address.getCountry().getName());
        boolean zipIsSuffix = hasCountry && address.getCountry().getName().equals("USA");
        StringBuilder builder = new StringBuilder();
        if (Strings.isNotBlank(address.getLine1()) && !address.getLine1().equals(defaultLine1)) {
            builder.append(address.getLine1());
            builder.append('\n');
        }
        if (Strings.isNotBlank(address.getLine2())) {
            builder.append(address.getLine2());
            builder.append('\n');
        }
        if (Strings.isNotBlank(address.getStreetline1())) {
            builder.append(address.getStreetline1());
            builder.append('\n');
        }
        if (Strings.isNotBlank(address.getStreetline2())) {
            builder.append(address.getStreetline2());
            builder.append('\n');
        }
        if (Strings.isNotBlank(address.getZipCode()) && Strings.isNotBlank(address.getCity())) {
            if (!zipIsSuffix) {
                builder.append(address.getZipCode());
                builder.append(' ');
                builder.append(address.getCity());
            } else {
                builder.append(address.getCity());
                builder.append(", ");
                builder.append(address.getZipCode());
            }
        }
        if (hasCountry && !address.getCountry().isDefault()) {
            builder.append(", ");
            builder.append(address.getCountry().getName().toUpperCase());
        }
        return builder.toString();
    }

    public static String formatContactType(ContactData.ContactType type) {
        switch (type) {
            case PHONE: {
                return "Telefon";
            }
            case EMAIL: {
                return "Email";
            }
            case WEB: {
                return "Web";
            }
            case FACEBOOK: {
                return "Facebook";
            }
        }
        throw new IllegalArgumentException("Unknown ContactType " + (Object)((Object)type));
    }

    public static String formatCityAndCountry(BaseAddress<?> address) {
        StringBuilder builder = new StringBuilder(address.getCity());
        if (!address.getCountry().isDefault()) {
            builder.append(", ");
            builder.append(address.getCountry());
        }
        return builder.toString();
    }

    public static String formatZipCityTableCell(BaseAddress<?> adresse) {
        if (adresse == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(adresse.getZipCode());
        builder.append(' ');
        if (!adresse.getCountry().isDefault()) {
            builder.append(adresse.getCity().toUpperCase());
        } else {
            builder.append(adresse.getCity());
        }
        return builder.toString();
    }

    public static String formatUserRoles(UserAccount konto) {
        return konto.getRollen().stream().map(UserRole::getName).collect(Collectors.joining(", "));
    }

    public static String prototypeDate() {
        Date prototype = DateUtils.toDate(LocalDate.of(2020, 11, 11));
        return DateFormat.getDateInstance(2).format(prototype);
    }

    public static String stripWhitespace(String formatted) {
        StringBuilder builder = new StringBuilder();
        Matcher matcher = WHITESPACE_PATTERN.matcher(formatted);
        while (matcher.find()) {
            builder.append(matcher.group());
        }
        return builder.toString();
    }

    public static String formatBorn(LocalDate dateOfBirth) {
        return "*\u202f" + AppFormats.formatTypoDate(dateOfBirth);
    }

    public static String formatAge(LocalDate dateOfBirth) {
        int years = Period.between(dateOfBirth, LocalDate.now()).getYears();
        return String.format("%s Jahre", years);
    }

    private static boolean isGerman(Locale locale) {
        return locale.getLanguage().equals("de");
    }
}

