/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.application;

import com.jgoodies.application.ResourceConverter;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.application.internal.Exceptions;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.internal.DateUtils;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public final class ResourceConverters {
    private static final List<ResourceConverter> CONVERTERS = new CopyOnWriteArrayList<ResourceConverter>();
    private static final Map<Class<?>, ResourceConverter> CONVERTER_MAP = new ConcurrentHashMap();

    private ResourceConverters() {
    }

    public static void register(ResourceConverter converter) {
        Preconditions.checkNotNull(converter, "The %s must not be null.", "converter");
        CONVERTERS.add(0, converter);
        ResourceConverters.invalidateCache();
    }

    public static ResourceConverter forType(Class<?> type) {
        Preconditions.checkNotNull(type, "The %s must not be null.", "type");
        ResourceConverter converter = CONVERTER_MAP.get(type);
        if (converter == null) {
            converter = ResourceConverters.lookUpConverter(type);
            CONVERTER_MAP.put(type, converter);
        }
        return converter;
    }

    private static ResourceConverter lookUpConverter(Class<?> type) {
        return CONVERTERS.stream().filter(converter -> converter.supportsType(type)).findFirst().orElse(null);
    }

    private static void invalidateCache() {
        CONVERTER_MAP.clear();
    }

    static {
        DefaultConverter defaultConverter = new DefaultConverter();
        ResourceConverters.register(defaultConverter);
    }

    private static final class DefaultConverter
    implements ResourceConverter {
        private static final List<Class<?>> SUPPORTED_TYPES = Arrays.asList(Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Calendar.class, Character.class, Character.TYPE, Color.class, Date.class, Dimension.class, Double.class, Double.TYPE, EmptyBorder.class, File.class, Float.class, Float.TYPE, Font.class, Icon.class, ImageIcon.class, Image.class, Insets.class, Integer.class, Integer.TYPE, KeyStroke.class, Long.class, Long.TYPE, LocalDate.class, MessageFormat.class, Point.class, Rectangle.class, Short.class, Short.TYPE, URI.class, URL.class);

        private DefaultConverter() {
        }

        @Override
        public boolean supportsType(Class<?> type) {
            return SUPPORTED_TYPES.stream().anyMatch(supportedType -> supportedType == type);
        }

        @Override
        public Object convert(ResourceMap r, String key, String value, Class<?> type) {
            try {
                if (type == Boolean.class || type == Boolean.TYPE) {
                    return DefaultConverter.convertBoolean(key, value, r);
                }
                if (type == Byte.class || type == Byte.TYPE) {
                    return Byte.decode(value);
                }
                if (type == Calendar.class) {
                    return DefaultConverter.convertCalendar(key, value, r);
                }
                if (type == Character.class || type == Character.TYPE) {
                    if (value.length() != 1) {
                        throw new Exceptions.ResourceConversionException("Character value too long.", r, key, value);
                    }
                    return Character.valueOf(value.charAt(0));
                }
                if (type == Color.class) {
                    return DefaultConverter.convertColor(key, value, r);
                }
                if (type == Date.class) {
                    return DefaultConverter.convertDate(key, value, r);
                }
                if (type == Dimension.class) {
                    return DefaultConverter.convertDimension(key, value, r);
                }
                if (type == Double.class || type == Double.TYPE) {
                    return Double.valueOf(value);
                }
                if (type == EmptyBorder.class) {
                    return DefaultConverter.convertEmptyBorder(key, value, r);
                }
                if (type == File.class) {
                    return new File(value);
                }
                if (type == Float.class || type == Float.TYPE) {
                    return Float.valueOf(value);
                }
                if (type == Font.class) {
                    return DefaultConverter.convertFont(key, value, r);
                }
                if (type == Icon.class || type == ImageIcon.class) {
                    return DefaultConverter.convertImageIcon(key, value, r);
                }
                if (type == Image.class) {
                    return DefaultConverter.convertImage(key, value, r);
                }
                if (type == Insets.class) {
                    return DefaultConverter.convertInsets(key, value, r);
                }
                if (type == Integer.class || type == Integer.TYPE) {
                    return Integer.decode(value);
                }
                if (type == KeyStroke.class) {
                    return DefaultConverter.convertKeyStroke(key, value, r);
                }
                if (type == Long.class || type == Long.TYPE) {
                    return Long.decode(value);
                }
                if (type == LocalDate.class) {
                    return DefaultConverter.convertLocalDate(key, value, r);
                }
                if (type == MessageFormat.class) {
                    return new MessageFormat(value);
                }
                if (type == Point.class) {
                    return DefaultConverter.convertPoint(key, value, r);
                }
                if (type == Rectangle.class) {
                    return DefaultConverter.convertRectangle(key, value, r);
                }
                if (type == Short.class || type == Short.TYPE) {
                    return Short.decode(value);
                }
                if (type == URI.class) {
                    return DefaultConverter.convertURI(key, value, r);
                }
                if (type == URL.class) {
                    return DefaultConverter.convertURL(key, value, r);
                }
                throw new IllegalArgumentException("Unknown type " + type);
            }
            catch (Exceptions.ResourceConversionException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new Exceptions.ResourceConversionException("Invalid " + type + " format.", r, key, value, t);
            }
        }

        private static Boolean convertBoolean(String key, String value, ResourceMap r) {
            if (value.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (value.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            if (value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes")) {
                return Boolean.TRUE;
            }
            if (value.equalsIgnoreCase("off") || value.equalsIgnoreCase("no")) {
                return Boolean.FALSE;
            }
            throw new Exceptions.ResourceConversionException("Illegal boolean format. Must be one of: true, false, yes, no, on, off", r, key, value);
        }

        private static Calendar convertCalendar(String key, String value, ResourceMap r) {
            Date date = DefaultConverter.convertDate(key, value, r);
            if (date == null) {
                return null;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar;
        }

        private static Color convertColor(String key, String value, ResourceMap r) {
            String generalFormatError = "Invalid Color format. Must be one of: AARRGGBB or R, G, B [, A].";
            String[] token = value.split(",");
            switch (token.length) {
                case 1: {
                    if (value.startsWith("#")) {
                        return DefaultConverter.decodeAARRGGBBColor(key, value, r, 1);
                    }
                    if (value.startsWith("0x") || value.startsWith("0X")) {
                        return DefaultConverter.decodeAARRGGBBColor(key, value, r, 2);
                    }
                    throw new Exceptions.ResourceConversionException(generalFormatError, r, key, value, null);
                }
                case 3: 
                case 4: {
                    try {
                        int[] ints = DefaultConverter.parseInts(token);
                        return ints.length == 3 ? new Color(ints[0], ints[1], ints[2]) : new Color(ints[0], ints[1], ints[2], ints[3]);
                    }
                    catch (NumberFormatException e) {
                        throw new Exceptions.ResourceConversionException(generalFormatError, r, key, value, e);
                    }
                }
            }
            throw new Exceptions.ResourceConversionException(generalFormatError, r, key, value, null);
        }

        private static Color decodeAARRGGBBColor(String key, String value, ResourceMap r, int offset) {
            switch (value.length() - offset) {
                case 6: {
                    return Color.decode(value);
                }
                case 8: {
                    return new Color(Long.decode(value).intValue(), true);
                }
            }
            throw new Exceptions.ResourceConversionException("Invalid [AA]RRGGBB Color format.", r, key, value, null);
        }

        private static Date convertDate(String key, String value, ResourceMap r) {
            try {
                DateFormat mediumFormat = DateFormat.getDateInstance(2, Locale.ENGLISH);
                return (Date)mediumFormat.parseObject(value);
            }
            catch (ParseException e1) {
                DateFormat shortFormat = DateFormat.getDateInstance(3, Locale.ENGLISH);
                try {
                    return (Date)shortFormat.parseObject(value);
                }
                catch (Exception e2) {
                    throw new Exceptions.ResourceConversionException("Invalid date format.", r, key, value, e2);
                }
            }
        }

        private static LocalDate convertLocalDate(String key, String value, ResourceMap r) {
            try {
                return LocalDate.parse(value);
            }
            catch (DateTimeParseException e) {
                return DateUtils.toLocalDate(DefaultConverter.convertDate(key, value, r));
            }
        }

        private static Dimension convertDimension(String key, String value, ResourceMap r) {
            try {
                int[] ints = DefaultConverter.decodeInts(value);
                if (ints.length != 2) {
                    throw new Exceptions.ResourceConversionException("Invalid Dimension format. Must be: <int>, <int>.", r, key, value, null);
                }
                return new Dimension(ints[0], ints[1]);
            }
            catch (NumberFormatException e) {
                throw new Exceptions.ResourceConversionException("Invalid Dimension format. Must be: <int>, <int>.", r, key, value, null);
            }
        }

        private static EmptyBorder convertEmptyBorder(String key, String value, ResourceMap r) {
            try {
                int[] ints = DefaultConverter.decodeInts(value);
                if (ints.length != 4) {
                    throw new Exceptions.ResourceConversionException("Invalid EmptyBorder format. Must be: <int>, <int>.", r, key, value, null);
                }
                return new EmptyBorder(ints[0], ints[1], ints[2], ints[3]);
            }
            catch (NumberFormatException e) {
                throw new Exceptions.ResourceConversionException("Invalid EmptyBorder format. Must be: <int>, <int>, <int>, <int>.", r, key, value, null);
            }
        }

        private static Font convertFont(String key, String value, ResourceMap r) {
            if (Strings.isBlank(value)) {
                throw new Exceptions.ResourceConversionException("Missing font description.", r, key, value, null);
            }
            int commaIndex = value.indexOf(44);
            if (commaIndex == -1) {
                return Font.decode(value);
            }
            String formatValue = value.substring(0, commaIndex).trim();
            String pathValue = value.substring(commaIndex + 1).trim();
            if (formatValue.equalsIgnoreCase("TrueType")) {
                return DefaultConverter.convertFontFromURL(key, pathValue, r, "TrueType font", 0);
            }
            if (formatValue.equalsIgnoreCase("Type1")) {
                return DefaultConverter.convertFontFromURL(key, pathValue, r, "Type1 font", 1);
            }
            throw new Exceptions.ResourceConversionException("Invalid font format name '" + formatValue + "'. Must be one of: TrueType, Type1", r, key, value, null);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static Font convertFontFromURL(String key, String value, ResourceMap r, String fontFormatName, int fontFormat) {
            URL url = DefaultConverter.getURL(key, value, r, fontFormatName);
            try (InputStream in = url.openStream();){
                Font font = Font.createFont(fontFormat, in);
                return font;
            }
            catch (IOException e) {
                throw new Exceptions.ResourceConversionException("Invalid " + fontFormatName + " resource.", r, key, value, e);
            }
            catch (FontFormatException e) {
                throw new Exceptions.ResourceConversionException("Invalid " + fontFormatName + " format.", r, key, value, e);
            }
        }

        private static Image convertImage(String key, String value, ResourceMap r) {
            URL url = DefaultConverter.getURL(key, value, r, "image");
            try {
                return ImageIO.read(url);
            }
            catch (IOException e) {
                throw new Exceptions.ResourceConversionException("Can't read image.", r, key, value, e);
            }
        }

        private static ImageIcon convertImageIcon(String key, String value, ResourceMap r) {
            URL url = DefaultConverter.getURL(key, value, r, "image icon");
            return new ImageIcon(url);
        }

        private static Insets convertInsets(String key, String value, ResourceMap r) {
            try {
                int[] ints = DefaultConverter.decodeInts(value);
                if (ints.length != 4) {
                    throw new Exceptions.ResourceConversionException("Invalid Insets format. Must be: <int>, <int>.", r, key, value, null);
                }
                return new Insets(ints[0], ints[1], ints[2], ints[3]);
            }
            catch (NumberFormatException e) {
                throw new Exceptions.ResourceConversionException("Invalid Insets format. Must be: <int>, <int>, <int>, <int>.", r, key, value, null);
            }
        }

        private static KeyStroke convertKeyStroke(String key, String value, ResourceMap r) {
            try {
                AWTKeyStroke keyStroke = AWTKeyStroke.getAWTKeyStroke(value);
                return (KeyStroke)keyStroke;
            }
            catch (Exception e) {
                throw new Exceptions.ResourceConversionException("Invalid KeyStroke format.\nSee the cause below and KeyStroke#getKeyStroke for details.\nValid key stroke examples: ctrl A, shift ctrl B", r, key, value, e);
            }
        }

        private static Point convertPoint(String key, String value, ResourceMap r) {
            try {
                int[] ints = DefaultConverter.decodeInts(value);
                if (ints.length != 2) {
                    throw new Exceptions.ResourceConversionException("Invalid Point format. Must be: <int>, <int>.", r, key, value, null);
                }
                return new Point(ints[0], ints[1]);
            }
            catch (NumberFormatException e) {
                throw new Exceptions.ResourceConversionException("Invalid Point format. Must be: <int>, <int>.", r, key, value, null);
            }
        }

        private static Rectangle convertRectangle(String key, String value, ResourceMap r) {
            try {
                int[] ints = DefaultConverter.decodeInts(value);
                if (ints.length != 4) {
                    throw new Exceptions.ResourceConversionException("Invalid Rectangle format. Must be: <int>, <int>.", r, key, value, null);
                }
                return new Rectangle(ints[0], ints[1], ints[2], ints[3]);
            }
            catch (NumberFormatException e) {
                throw new Exceptions.ResourceConversionException("Invalid Rectangle format. Must be: <int>, <int>, <int>, <int>.", r, key, value, null);
            }
        }

        private static URI convertURI(String key, String value, ResourceMap r) {
            try {
                return new URI(value);
            }
            catch (URISyntaxException e) {
                throw new Exceptions.ResourceConversionException("Invalid URI syntax.", r, key, value, e);
            }
        }

        private static URL convertURL(String key, String value, ResourceMap r) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                String path = r.resolvePath(value);
                URL url = r.getClassLoader().getResource(path);
                if (url != null) {
                    return url;
                }
                throw new Exceptions.ResourceConversionException("Invalid URL.\npath=" + path, r, key, value, e);
            }
        }

        private static URL getURL(String key, String value, ResourceMap r, String objectType) {
            if (Strings.isBlank(value)) {
                throw new Exceptions.ResourceConversionException("Missing " + objectType + " path.", r, key, value, null);
            }
            String path = r.resolvePath(value);
            URL url = r.getClassLoader().getResource(path);
            if (url != null) {
                return url;
            }
            throw new Exceptions.ResourceConversionException("Invalid " + objectType + " path.\nParent path=" + r.getResourceParentPath(), r, key, value, null);
        }

        private static int[] decodeInts(String value) {
            String[] token = value.split(",");
            int[] result = new int[token.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Integer.decode(token[i].trim());
            }
            return result;
        }

        private static int[] parseInts(String[] token) {
            int[] result = new int[token.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Integer.parseInt(token[i].trim());
            }
            return result;
        }

        static {
            KeyStroke.getKeyStroke("ENTER");
        }
    }
}

