/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.application;

import com.jgoodies.application.Application;
import com.jgoodies.application.BlockingScope;
import com.jgoodies.application.InputBlocker;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.swing.internal.AncestorSupport;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.MissingResourceException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingWorker;

public abstract class Task<T, V>
extends SwingWorker<T, V> {
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_MESSAGE = "message";
    public static final String PROPERTY_CANCEL_ALLOWED = "cancelAllowed";
    public static final String PROPERTY_PROGRESS = "progress";
    public static final String PROPERTY_PROGRESS_INDETERMINATE = "progressIndeterminate";
    public static final String PROPERTY_INPUT_BLOCKER = "inputBlocker";
    public static final String PROPERTY_EXTENDED_STATE = "extendedState";
    private final BlockingScope blockingScope;
    private final String resourcePrefix;
    private final ResourceMap resourceMap;
    private String title;
    private String description;
    private String message;
    private boolean cancelAllowed;
    private boolean progressIndeterminate = true;
    private long startTime = -1L;
    private long doneTime = -1L;
    private long messageTime = -1L;
    private InputBlocker inputBlocker;
    private Action action;
    private EventObject eventObject;
    private Component component;
    private Window window;
    static PropertyChangeListener stateChangeHandler = Task::onStateChanged;

    public Task(BlockingScope blockingScope) {
        this(blockingScope, "", null);
    }

    public Task(BlockingScope blockingScope, Class<?> type) {
        this(blockingScope, type.getSimpleName(), Application.getResourceMap(type));
    }

    public Task(BlockingScope blockingScope, String resourcePrefix, ResourceMap resourceMap) {
        Preconditions.checkNotNull(blockingScope, "The %s must not be null.", "blocking scope");
        this.blockingScope = blockingScope;
        this.resourcePrefix = resourcePrefix;
        this.resourceMap = resourceMap;
        if (resourceMap != null) {
            this.title = resourceMap.getString(this.getResourceName(PROPERTY_TITLE), new Object[0]);
            this.description = null;
            try {
                this.description = resourceMap.getString(this.getResourceName(PROPERTY_DESCRIPTION), new Object[0]);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                this.setMessage(resourceMap.getString(this.getResourceName(PROPERTY_MESSAGE), new Object[0]));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        this.inputBlocker = Application.getInstance().getDefaultInputBlocker();
        this.addPropertyChangeListener(stateChangeHandler);
    }

    public final BlockingScope getBlockingScope() {
        return this.blockingScope;
    }

    public final String getResourceName(String suffix) {
        return this.resourcePrefix + '.' + suffix;
    }

    public final ResourceMap getResourceMap() {
        return this.resourceMap;
    }

    public final synchronized String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setTitle(String newTitle) {
        String newValue;
        String oldValue;
        Task task = this;
        synchronized (task) {
            oldValue = this.title;
            this.title = newTitle;
            newValue = newTitle;
        }
        this.firePropertyChange(PROPERTY_TITLE, oldValue, newValue);
    }

    public final synchronized String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setDescription(String newDescription) {
        String newValue;
        String oldValue;
        Task task = this;
        synchronized (task) {
            oldValue = this.description;
            this.description = newDescription;
            newValue = newDescription;
        }
        this.firePropertyChange(PROPERTY_DESCRIPTION, oldValue, newValue);
    }

    public final synchronized String getMessage() {
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setMessage(String newMessage) {
        String newValue;
        String oldValue;
        Task task = this;
        synchronized (task) {
            oldValue = this.message;
            this.message = newMessage;
            newValue = newMessage;
            this.messageTime = System.currentTimeMillis();
        }
        this.firePropertyChange(PROPERTY_MESSAGE, oldValue, newValue);
    }

    protected final void message(String keySuffix, Object ... args) {
        Preconditions.checkState(this.getResourceMap() != null, "Can't format message because this Task lacks a resource map.");
        this.setMessage(this.getResourceMap().getString(this.getResourceName(keySuffix), args));
    }

    public final synchronized boolean isCancelAllowed() {
        return this.cancelAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setCancelAllowed(boolean b) {
        boolean newValue;
        boolean oldValue;
        Task task = this;
        synchronized (task) {
            oldValue = this.cancelAllowed;
            newValue = this.cancelAllowed = b;
        }
        this.firePropertyChange(PROPERTY_CANCEL_ALLOWED, oldValue, newValue);
    }

    public final synchronized boolean isProgressIndeterminate() {
        return this.progressIndeterminate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setProgressIndeterminate(boolean b) {
        boolean newValue;
        boolean oldValue;
        Task task = this;
        synchronized (task) {
            oldValue = this.progressIndeterminate;
            newValue = this.progressIndeterminate = b;
        }
        this.firePropertyChange(PROPERTY_PROGRESS_INDETERMINATE, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getExecutionDuration(TimeUnit unit) {
        long doneT;
        long startT;
        Task task = this;
        synchronized (task) {
            startT = this.startTime;
            doneT = this.doneTime;
        }
        long duration = startT == -1L ? 0L : (doneT == -1L ? System.currentTimeMillis() - startT : doneT - startT);
        return unit.convert(Math.max(0L, duration), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getMessageDuration(TimeUnit unit) {
        long messageT;
        Task task = this;
        synchronized (task) {
            messageT = this.messageTime;
        }
        long dt = messageT == -1L ? 0L : Math.max(0L, System.currentTimeMillis() - messageT);
        return unit.convert(dt, TimeUnit.MILLISECONDS);
    }

    public InputBlocker getInputBlocker() {
        return this.inputBlocker;
    }

    public void setInputBlocker(InputBlocker newInputBlocker) {
        InputBlocker oldBlocker = this.getInputBlocker();
        this.inputBlocker = newInputBlocker;
        this.firePropertyChange(PROPERTY_INPUT_BLOCKER, oldBlocker, newInputBlocker);
    }

    public final Action getAction() {
        return this.action;
    }

    public final void setAction(Action actionToBlock) {
        this.action = actionToBlock;
    }

    public final Component getComponent() {
        return this.component;
    }

    public final void setComponent(Component componentToBlock) {
        this.component = componentToBlock;
    }

    private void setComponent(EventObject evt) {
        this.component = evt == null ? null : AncestorSupport.getComponentFor(evt.getSource());
    }

    public final Window getWindow() {
        return this.window;
    }

    private void setWindow(EventObject evt) {
        this.window = evt == null ? null : AncestorSupport.getWindowFor(evt.getSource());
    }

    public final EventObject getEventObject() {
        return this.eventObject;
    }

    public final void setEventObject(EventObject eventObject) {
        Preconditions.checkState(this.eventObject == null, "The event object must be set once only.");
        this.eventObject = eventObject;
        this.setComponent(eventObject);
        this.setWindow(eventObject);
    }

    public final boolean isPending() {
        return this.getState() == SwingWorker.StateValue.PENDING;
    }

    void enqueue(ExecutorService executorService) {
        this.checkValidBlocking();
        if (this.getBlockingScope() == BlockingScope.NONE) {
            executorService.execute(this);
            return;
        }
        InputBlocker blocker = this.getInputBlocker();
        Preconditions.checkState(blocker != null, "An InputBlocker must be specified for a Task if its blocking scope is not NONE. An individual InputBlocker can be set by Task#setInputBlocker, a default InputBlocker can be set by Application#setDefaultInputBlocker.\nTask=" + this.getTitle());
        if (EventQueue.isDispatchThread()) {
            blocker.block(this);
            executorService.execute(this);
            return;
        }
        EventQueue.invokeLater(() -> {
            blocker.block(this);
            executorService.execute(this);
        });
    }

    @Override
    protected final void done() {
        this.doneTime = System.currentTimeMillis();
        if (this.getBlockingScope() != BlockingScope.NONE) {
            this.getInputBlocker().unblock(this);
        }
        try {
            this.firePropertyChange(PROPERTY_EXTENDED_STATE, null, (Object)ExtendedStateValue.BACKGROUND_DONE);
            if (this.isCancelled()) {
                this.cancelled();
            } else {
                try {
                    this.succeeded(this.get());
                }
                catch (InterruptedException ex) {
                    this.interrupted(ex);
                }
                catch (ExecutionException ex) {
                    this.failed(ex.getCause());
                }
            }
        }
        finally {
            this.finished();
        }
    }

    protected void succeeded(T result) {
    }

    protected void cancelled() {
    }

    protected void failed(Throwable caught) {
        Application.getInstance().handleException(caught, this.getTitle(), Level.SEVERE);
    }

    protected void interrupted(InterruptedException ex) {
    }

    protected void finished() {
    }

    private void checkValidBlocking() {
        switch (this.getBlockingScope()) {
            case NONE: {
                break;
            }
            case ACTION: {
                Preconditions.checkState(this.getAction() != null, this.withTaskInfo("The task has a blocking scope ACTION, but the Action object has not been set. It'll be set by the framework, if you #execute an Action or request it from the ApplicationContext."));
                break;
            }
            case COMPONENT: {
                if (this.getComponent() != null) break;
                Logger logger = Logger.getLogger(this.getClass().getName());
                logger.warning(this.withTaskInfo("The task has a blocking scope COMPONENTbut the event object has not been set, or the event object is null, or the event object lacks a source component."));
                break;
            }
            case WINDOW: {
                if (this.getWindow() != null) break;
                Logger logger = Logger.getLogger(this.getClass().getName());
                logger.warning(this.withTaskInfo("The task has a blocking scope WINDOW but the event object has not been set, or the event object is null, or the event object lacks a source component."));
                break;
            }
            case APPLICATION: {
                break;
            }
        }
    }

    private String withTaskInfo(String message) {
        return Strings.get(message + "\nTask class=%1$s\nTask title=%2$s\nTask description=%3$s\n", this.getClass().getName(), this.getTitle(), this.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onStateChanged(PropertyChangeEvent evt) {
        String propertyName;
        Task task = (Task)evt.getSource();
        block8 : switch (propertyName = evt.getPropertyName()) {
            case "state": {
                SwingWorker.StateValue state = (SwingWorker.StateValue)((Object)evt.getNewValue());
                switch (state) {
                    case PENDING: {
                        throw new IllegalStateException();
                    }
                    case STARTED: {
                        Task task2 = task;
                        synchronized (task2) {
                            task.startTime = System.currentTimeMillis();
                            break block8;
                        }
                    }
                    case DONE: {
                        task.removePropertyChangeListener(stateChangeHandler);
                        break block8;
                    }
                }
                break;
            }
            case "progress": {
                Task task3 = task;
                synchronized (task3) {
                    task.progressIndeterminate = false;
                    break;
                }
            }
        }
    }

    public static enum ExtendedStateValue {
        BACKGROUND_DONE;

    }
}

