/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.beans.IndirectPropertyChangeSupport;
import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.beans.PropertyAccessor;
import com.jgoodies.binding.beans.PropertyAccessors;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.bean.BeanUtils;
import com.jgoodies.common.bean.PropertyUnboundException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BeanAdapter<B>
extends Model {
    public static final String PROPERTY_BEFORE_BEAN = "beforeBean";
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_AFTER_BEAN = "afterBean";
    public static final String PROPERTY_CHANGED = "changed";
    private final ValueModel beanChannel;
    private final boolean observeChanges;
    private final Map<String, SimplePropertyAdapter> propertyAdapters;
    private IndirectPropertyChangeSupport indirectChangeSupport;
    B storedOldBean;
    private boolean changed = false;
    private PropertyChangeListener propertyChangeHandler;
    private PropertyChangeListener beanChangeHandler;

    public BeanAdapter(B bean) {
        this(bean, false);
    }

    public BeanAdapter(B bean, boolean observeChanges) {
        this(new ValueHolder(bean, true), observeChanges);
    }

    public BeanAdapter(ValueModel beanChannel) {
        this(beanChannel, false);
    }

    public BeanAdapter(ValueModel beanChannel, boolean observeChanges) {
        this.beanChannel = beanChannel != null ? beanChannel : new ValueHolder(null, true);
        BeanAdapter.checkBeanChannelIdentityCheck(beanChannel);
        this.observeChanges = observeChanges;
        this.propertyAdapters = new HashMap<String, SimplePropertyAdapter>();
        this.beanChangeHandler = this::onBeanChanged;
        this.beanChannel.addValueChangeListener(this.beanChangeHandler);
        B initialBean = this.getBean();
        if (initialBean != null) {
            if (observeChanges && !BeanUtils.supportsBoundProperties(this.getBeanClass(initialBean))) {
                throw new PropertyUnboundException("The bean must provide support for listening on property changes as described in section 7.4.5 of the Java Bean Specification.");
            }
            this.addChangeHandlerTo(initialBean);
        }
        this.storedOldBean = initialBean;
    }

    public ValueModel getBeanChannel() {
        return this.beanChannel;
    }

    public B getBean() {
        return (B)this.beanChannel.getValue();
    }

    public void setBean(B newBean) {
        this.beanChannel.setValue(newBean);
        this.resetChanged();
    }

    public boolean getObserveChanges() {
        return this.observeChanges;
    }

    public Object getValue(String propertyName) {
        return this.getValueModel(propertyName).getValue();
    }

    public void setValue(String propertyName, Object newValue) {
        this.getValueModel(propertyName).setValue(newValue);
    }

    public void setVetoableValue(String propertyName, Object newValue) throws PropertyVetoException {
        this.getValueModel(propertyName).setVetoableValue(newValue);
    }

    public SimplePropertyAdapter getValueModel(String propertyName) {
        return this.getValueModel(propertyName, null, null);
    }

    public SimplePropertyAdapter getValueModel(String propertyName, String getterName, String setterName) {
        Preconditions.checkNotBlank(propertyName, "The %s must not be null, empty, or whitespace.", "property name");
        SimplePropertyAdapter adaptingModel = this.getPropertyAdapter(propertyName);
        if (adaptingModel == null) {
            adaptingModel = this.createPropertyAdapter(propertyName, getterName, setterName);
            this.propertyAdapters.put(propertyName, adaptingModel);
        } else {
            Preconditions.checkArgument(Objects.equals(getterName, adaptingModel.getterName) && Objects.equals(setterName, adaptingModel.setterName), "You must not invoke this method twice with different getter and/or setter names.");
        }
        return adaptingModel;
    }

    SimplePropertyAdapter getPropertyAdapter(String propertyName) {
        return this.propertyAdapters.get(propertyName);
    }

    protected SimplePropertyAdapter createPropertyAdapter(String propertyName, String getterName, String setterName) {
        return new SimplePropertyAdapter(propertyName, getterName, setterName);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void resetChanged() {
        this.setChanged(false);
    }

    private void setChanged(boolean newValue) {
        boolean oldValue = this.isChanged();
        this.changed = newValue;
        this.firePropertyChange(PROPERTY_CHANGED, oldValue, newValue);
    }

    public synchronized void addBeanPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.indirectChangeSupport == null) {
            this.indirectChangeSupport = new IndirectPropertyChangeSupport(this.beanChannel);
        }
        this.indirectChangeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removeBeanPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.indirectChangeSupport == null) {
            return;
        }
        this.indirectChangeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addBeanPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.indirectChangeSupport == null) {
            this.indirectChangeSupport = new IndirectPropertyChangeSupport(this.beanChannel);
        }
        this.indirectChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removeBeanPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null || this.indirectChangeSupport == null) {
            return;
        }
        this.indirectChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized PropertyChangeListener[] getBeanPropertyChangeListeners() {
        if (this.indirectChangeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.indirectChangeSupport.getPropertyChangeListeners();
    }

    public synchronized PropertyChangeListener[] getBeanPropertyChangeListeners(String propertyName) {
        if (this.indirectChangeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.indirectChangeSupport.getPropertyChangeListeners(propertyName);
    }

    public synchronized void release() {
        this.removeChangeHandlerFrom(this.getBean());
        this.storedOldBean = null;
        if (this.indirectChangeSupport != null) {
            this.indirectChangeSupport.removeAll();
        }
        this.beanChannel.removeValueChangeListener(this.beanChangeHandler);
    }

    private void setBean0(B oldBean, B newBean) {
        this.firePropertyChange(PROPERTY_BEFORE_BEAN, oldBean, newBean, true);
        this.removeChangeHandlerFrom(oldBean);
        this.forwardAllAdaptedValuesChanged(oldBean, newBean);
        this.resetChanged();
        this.addChangeHandlerTo(newBean);
        this.firePropertyChange(PROPERTY_BEAN, oldBean, newBean, true);
        this.firePropertyChange(PROPERTY_AFTER_BEAN, oldBean, newBean, true);
    }

    private void forwardAllAdaptedValuesChanged(B oldBean, B newBean) {
        Object[] adapters;
        for (Object adapter : adapters = this.propertyAdapters.values().toArray()) {
            ((SimplePropertyAdapter)adapter).setBean0(oldBean, newBean);
        }
    }

    private void forwardAllAdaptedValuesChanged() {
        Object[] adapters;
        B currentBean = this.getBean();
        for (Object adapter : adapters = this.propertyAdapters.values().toArray()) {
            ((SimplePropertyAdapter)adapter).fireChange(currentBean);
        }
    }

    private void addChangeHandlerTo(B bean) {
        if (!this.observeChanges || bean == null) {
            return;
        }
        this.propertyChangeHandler = this::onPropertyChanged;
        BeanUtils.addPropertyChangeListener(bean, (Class)null, this.propertyChangeHandler);
    }

    private void removeChangeHandlerFrom(B bean) {
        if (!this.observeChanges || bean == null || this.propertyChangeHandler == null) {
            return;
        }
        BeanUtils.removePropertyChangeListener(bean, (Class)null, this.propertyChangeHandler);
        this.propertyChangeHandler = null;
    }

    private Class<?> getBeanClass(B bean) {
        return bean.getClass();
    }

    private Object getValue0(B bean, PropertyAccessor propertyDescriptor) {
        return bean == null ? null : propertyDescriptor.getValue(bean);
    }

    private void setValue0(B bean, PropertyAccessor propertyDescriptor, Object newValue) throws PropertyVetoException {
        propertyDescriptor.setValue(bean, newValue);
    }

    private static void checkBeanChannelIdentityCheck(ValueModel valueModel) {
        if (!(valueModel instanceof ValueHolder)) {
            return;
        }
        ValueHolder valueHolder = (ValueHolder)valueModel;
        if (!valueHolder.isIdentityCheckEnabled()) {
            throw new IllegalArgumentException("The bean channel must have the identity check enabled.");
        }
    }

    private void onBeanChanged(PropertyChangeEvent evt) {
        Object newBean = evt.getNewValue() != null ? evt.getNewValue() : this.getBean();
        this.setBean0(this.storedOldBean, newBean);
        this.storedOldBean = newBean;
    }

    private void onPropertyChanged(PropertyChangeEvent evt) {
        this.setChanged(true);
        String propertyName = evt.getPropertyName();
        if (propertyName == null) {
            this.forwardAllAdaptedValuesChanged();
        } else {
            SimplePropertyAdapter adapter = this.getPropertyAdapter(propertyName);
            if (adapter != null) {
                adapter.fireChange(evt.getOldValue(), evt.getNewValue());
            }
        }
    }

    public class SimplePropertyAdapter
    extends AbstractValueModel {
        private final String propertyName;
        final String getterName;
        final String setterName;
        private transient PropertyAccessor cachedPropertyDescriptor;
        private Class<?> cachedBeanClass;

        protected SimplePropertyAdapter(String propertyName, String getterName, String setterName) {
            this.propertyName = propertyName;
            this.getterName = getterName;
            this.setterName = setterName;
            Object bean = BeanAdapter.this.getBean();
            if (bean != null) {
                this.getPropertyAccessor(bean);
            }
        }

        @Override
        public Object getValue() {
            Object bean = BeanAdapter.this.getBean();
            if (bean == null) {
                return null;
            }
            return BeanAdapter.this.getValue0(bean, this.getPropertyAccessor(bean));
        }

        @Override
        public void setValue(Object newValue) {
            Object bean = BeanAdapter.this.getBean();
            if (bean == null) {
                return;
            }
            try {
                BeanAdapter.this.setValue0(bean, this.getPropertyAccessor(bean), newValue);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public void setVetoableValue(Object newValue) throws PropertyVetoException {
            Object bean = BeanAdapter.this.getBean();
            if (bean == null) {
                return;
            }
            BeanAdapter.this.setValue0(bean, this.getPropertyAccessor(bean), newValue);
        }

        private PropertyAccessor getPropertyAccessor(B bean) {
            Class beanClass = BeanAdapter.this.getBeanClass(bean);
            if (this.cachedPropertyDescriptor == null || beanClass != this.cachedBeanClass) {
                this.cachedPropertyDescriptor = PropertyAccessors.getProvider().getAccessor(beanClass, this.propertyName, this.getterName, this.setterName);
                this.cachedBeanClass = beanClass;
            }
            return this.cachedPropertyDescriptor;
        }

        protected void fireChange(B currentBean) {
            PropertyAccessor propertyDescriptor;
            boolean isWriteOnly;
            Object newValue = currentBean == null ? null : ((isWriteOnly = (propertyDescriptor = this.getPropertyAccessor(currentBean)).isWriteOnly()) ? null : BeanAdapter.this.getValue0(currentBean, propertyDescriptor));
            this.fireValueChange(null, newValue);
        }

        protected void fireChange(Object oldValue, Object newValue) {
            this.fireValueChange(oldValue, newValue, true);
        }

        protected void setBean0(B oldBean, B newBean) {
            Object newValue;
            boolean isWriteOnly;
            PropertyAccessor propertyAccessor;
            Object oldValue;
            if (oldBean == null) {
                oldValue = null;
            } else {
                propertyAccessor = this.getPropertyAccessor(oldBean);
                isWriteOnly = propertyAccessor.isWriteOnly();
                Object object = oldValue = isWriteOnly ? null : BeanAdapter.this.getValue0(oldBean, propertyAccessor);
            }
            if (newBean == null) {
                newValue = null;
            } else {
                propertyAccessor = this.getPropertyAccessor(newBean);
                isWriteOnly = propertyAccessor.isWriteOnly();
                Object object = newValue = isWriteOnly ? null : BeanAdapter.this.getValue0(newBean, propertyAccessor);
            }
            if (oldValue != null || newValue != null) {
                this.fireValueChange(oldValue, newValue, true);
            }
        }

        @Override
        protected String paramString() {
            Object bean = BeanAdapter.this.getBean();
            String beanType = null;
            Object value = this.getValue();
            String valueType = null;
            String propertyDescriptorName = null;
            String propertyType = null;
            Method propertyGetter = null;
            Method propertySetter = null;
            if (bean != null) {
                beanType = bean.getClass().getName();
                valueType = value == null ? null : value.getClass().getName();
                PropertyAccessor propertyDescriptor = this.getPropertyAccessor(bean);
                propertyDescriptorName = propertyDescriptor.getPropertyName();
                propertyType = propertyDescriptor.getPropertyType().getName();
                propertyGetter = propertyDescriptor.getReadMethod();
                propertySetter = propertyDescriptor.getWriteMethod();
            }
            return "bean=" + bean + "; bean type=" + beanType + "; value=" + value + "; value type=" + valueType + "; property name=" + propertyDescriptorName + "; property type=" + propertyType + "; property getter=" + propertyGetter + "; property setter=" + propertySetter;
        }
    }
}

