/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.chart;

import com.jgoodies.chart.ChartLabel;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;

final class PieChartLabels {
    private static final int PAINT_LABEL_ARC_THRESHOLD = 10;
    private final List<ChartLabel> northEast = new ArrayList<ChartLabel>();
    private final List<ChartLabel> southEast = new ArrayList<ChartLabel>();
    private final List<ChartLabel> southWest = new ArrayList<ChartLabel>();
    private final List<ChartLabel> northWest = new ArrayList<ChartLabel>();

    PieChartLabels() {
    }

    void add(String label, String sizeStr, int startAngle, int stopAngle) {
        int arcAngle = stopAngle - startAngle;
        if (arcAngle < 10) {
            return;
        }
        int angle = (startAngle + stopAngle) / 2;
        ChartLabel cLabel = new ChartLabel(label, sizeStr, startAngle, stopAngle, angle <= 180);
        if (angle <= 90) {
            this.northEast.add(cLabel);
        } else if (angle <= 180) {
            this.southEast.add(cLabel);
        } else if (angle <= 270) {
            this.southWest.add(cLabel);
        } else {
            this.northWest.add(cLabel);
        }
    }

    void doLayout(FontMetrics fm, int width, int height, int radius) {
        PieChartLabels.doLayout(this.northEast, fm, width, height, radius);
        PieChartLabels.doLayout(this.southEast, fm, width, height, radius);
        PieChartLabels.doLayout(this.southWest, fm, width, height, radius);
        PieChartLabels.doLayout(this.northWest, fm, width, height, radius);
    }

    private static void doLayout(List<ChartLabel> chartLabels, FontMetrics fm, int width, int height, int radius) {
        int groupSize = chartLabels.size();
        for (ChartLabel label : chartLabels) {
            label.initializeFrom(fm, width, height, radius, groupSize);
        }
    }

    void paint(JComponent c, Graphics2D g2) {
        g2.setColor(UIManager.getColor("controlText"));
        PieChartLabels.paint(this.northEast, c, g2);
        PieChartLabels.paint(this.southEast, c, g2);
        PieChartLabels.paint(this.southWest, c, g2);
        PieChartLabels.paint(this.northWest, c, g2);
    }

    private static void paint(List<ChartLabel> chartLabels, JComponent c, Graphics2D g2) {
        for (ChartLabel label : chartLabels) {
            label.paint(c, g2);
        }
    }
}

