/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.jsdl.util;

import com.jgoodies.common.base.Preconditions;
import java.awt.Font;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class HTMLUtils {
    private static Font cachedTextFont;
    private static String cachedDefaultRule;

    protected HTMLUtils() {
    }

    public static void addDefaultStyleSheetRuleToSharedStyleSheet() {
        HTMLUtils.addRuleToSharedStyleSheet(HTMLUtils.getDefaultRule());
    }

    public static void addRuleToSharedStyleSheet(String rule) {
        new HTMLEditorKit().getStyleSheet().addRule(rule);
    }

    public static void addDefaultStyleSheetRule(JEditorPane editorPane) {
        HTMLUtils.addStyleSheetRule(editorPane, HTMLUtils.getDefaultRule());
    }

    public static void addDefaultStyleSheetRule(JEditorPane editorPane, Font textFont) {
        HTMLUtils.addStyleSheetRule(editorPane, HTMLUtils.createDefaultRule(textFont));
    }

    public static void addStyleSheetRule(JEditorPane editorPane, String rule) {
        Document document = editorPane.getDocument();
        Preconditions.checkArgument(document instanceof HTMLDocument, "The editor pane must hold an HTMLDocument.");
        ((HTMLDocument)document).getStyleSheet().addRule(rule);
    }

    public static Font getDefaultTextFont() {
        String fontKey = "Label.font";
        return UIManager.getFont(fontKey);
    }

    private static String getDefaultRule() {
        Font textFont = HTMLUtils.getDefaultTextFont();
        if (textFont != cachedTextFont) {
            cachedDefaultRule = HTMLUtils.createDefaultRule(textFont);
            cachedTextFont = textFont;
        }
        return cachedDefaultRule;
    }

    private static String createDefaultRule(Font font) {
        String rule = "body, p, td, a, li { font-family: " + font.getName() + "; font-size: " + font.getSize() + "pt;  }a                  { color: #0066CC; }";
        return rule;
    }
}

