/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components.internal;

import com.jgoodies.components.internal.AbstractUnderlineSupport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

public final class ErrorUnderlineSupport
extends AbstractUnderlineSupport {
    public static final String PROPERTY_ERROR_UNDERLINE_PAINTED = "errorUnderlinePainted";
    private static final ErrorUnderlineSupport INSTANCE = new ErrorUnderlineSupport();

    private ErrorUnderlineSupport() {
    }

    public static boolean isErrorUnderlinePainted(JTextComponent c) {
        return INSTANCE.isEnabled(c);
    }

    public static void setErrorUnderlinePainted(JTextComponent c, boolean newValue) {
        INSTANCE.setEnabled(c, newValue);
    }

    @Override
    protected DefaultHighlighter.DefaultHighlightPainter createHighlightPainter() {
        return new WavyUnderlinePainter();
    }

    private static final class WavyUnderlinePainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        WavyUnderlinePainter() {
            super(Color.RED);
        }

        @Override
        public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
            try {
                Shape shape = c.getUI().getRootView(c).modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                this.paintUnderline(g, WavyUnderlinePainter.outline(WavyUnderlinePainter.bounds(shape)));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
            Rectangle r = null;
            if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                r = WavyUnderlinePainter.bounds(bounds);
            } else {
                try {
                    Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                    r = WavyUnderlinePainter.bounds(shape);
                }
                catch (BadLocationException shape) {
                    // empty catch block
                }
            }
            if (r != null) {
                Rectangle rect = WavyUnderlinePainter.outline(r);
                this.paintUnderline(g, rect);
                return rect;
            }
            return null;
        }

        private void paintUnderline(Graphics g, Rectangle clip) {
            int x;
            int y = clip.y;
            Color oldColor = g.getColor();
            Shape oldClip = g.getClip();
            g.setColor(this.getColor());
            g.clipRect(clip.x, clip.y, clip.width, clip.height);
            int end = x + clip.width;
            for (x = clip.x; x < end; x += 4) {
                g.fillRect(x, y + 2, 1, 1);
                g.fillRect(x + 1, y + 1, 1, 1);
                g.fillRect(x + 2, y, 1, 1);
                g.fillRect(x + 3, y + 1, 1, 1);
            }
            g.setClip(oldClip);
            g.setColor(oldColor);
        }

        private static Rectangle bounds(Shape shape) {
            return shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        }

        private static Rectangle outline(Rectangle r) {
            return new Rectangle(r.x, r.y + r.height - 3, r.width, 3);
        }
    }
}

