/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane.property;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.swing.MnemonicUtils;
import com.jgoodies.components.JGCardPanel;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.components.renderer.JGDefaultListCellRenderer;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.CoreDialogResources;
import com.jgoodies.dialogs.core.internal.PropertyPaneAction;
import com.jgoodies.dialogs.core.internal.TabInfo;
import com.jgoodies.dialogs.core.pane.property.PropertyPane;
import com.jgoodies.dialogs.core.pane.property.PropertyPaneModel;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.layout.Sizes;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;

public final class ListPropertyPane
extends PropertyPane {
    private static final String UI_CLASS_ID = "JSDL.ListPropertyPaneUI";
    private final DefaultListModel<TabInfo> listModel = new DefaultListModel();
    private JList<TabInfo> tabList;
    private JLabel titleLabel;
    private JGCardPanel cardPanel;

    public ListPropertyPane() {
        this(CommandValue.OK, CommandValue.CANCEL);
    }

    public ListPropertyPane(Object okObject, Object cancelObject) {
        this(new Object[]{okObject, cancelObject});
    }

    public ListPropertyPane(Object okObject, Object cancelObject, Object applyObject) {
        this(new Object[]{okObject, cancelObject, applyObject});
    }

    public ListPropertyPane(PropertyPaneModel model) {
        this(PropertyPaneAction.createOKCancelApplyActionsFor(model));
    }

    private ListPropertyPane(Object[] commitObjects) {
        super(null, commitObjects);
        this.setContent(this.buildContent());
    }

    public void addTab(String plainTabText, JComponent tabComponent) {
        this.addTabImpl(plainTabText, null, tabComponent);
    }

    public void addTab(String plainTabText, String markedTitleText, JComponent tabComponent) {
        Preconditions.checkNotBlank(markedTitleText, "The %s must not be null, empty, or whitespace.", "marked title text");
        this.addTabImpl(plainTabText, markedTitleText, tabComponent);
    }

    void addTabImpl(String plainTabText, String markedTitleText, JComponent tabComponent) {
        Preconditions.checkNotBlank(plainTabText, "The %s must not be null, empty, or whitespace.", "tab text");
        Preconditions.checkNotNull(tabComponent, "The %s must not be null.", "tab component");
        this.listModel.addElement(new TabInfo(plainTabText, markedTitleText));
        this.cardPanel.add(plainTabText, tabComponent);
        if (this.listModel.getSize() == 1) {
            this.tabList.setSelectedIndex(0);
        }
    }

    @Override
    protected String layoutGroup() {
        return "ListPropertyPane";
    }

    private void initComponents() {
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        this.tabList = new JList<TabInfo>(this.listModel);
        this.tabList.setCellRenderer(new JGDefaultListCellRenderer<TabInfo>(TabInfo::getTabText));
        this.tabList.setSelectionMode(0);
        this.tabList.setSelectedIndex(0);
        this.tabList.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.tabList.setFixedCellHeight(Sizes.dialogUnitYAsPixel(12, this.tabList));
        this.tabList.getAccessibleContext().setAccessibleName(CoreDialogResources.getString("ListPropertyPane.tabList.accessibleName"));
        this.tabList.getAccessibleContext().setAccessibleDescription(CoreDialogResources.getString("ListPropertyPane.tabList.accessibleDescription"));
        this.titleLabel = factory.createLabel("Tab Title");
        this.titleLabel.setFont(UIManager.getFont("ListPropertyPane.tabTitle.font"));
        this.titleLabel.setForeground(UIManager.getColor("ListPropertyPane.tabTitle.foreground"));
        this.cardPanel = new JGCardPanel();
        this.cardPanel.setOpaque(false);
    }

    private void initEventHandling() {
        this.tabList.getSelectionModel().addListSelectionListener(this::onListSelectionChanged);
    }

    private JComponent buildContent() {
        this.initComponents();
        this.initEventHandling();
        int gapListTabs = UIManager.getInt("ListPropertyPane.default.gap.listTabs");
        int gapTitleTabs = UIManager.getInt("ListPropertyPane.default.gap.titleTabs");
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("[75dlu,pref], %sdlu, pref:grow", gapListTabs)).rows("p, %sdlu, fill:[180dlu,p]:grow", gapTitleTabs)).add(this.tabList).xywh(1, 1, 1, 3)).add(this.titleLabel).xy(3, 1)).add(this.cardPanel).xy(3, 3)).build();
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    private void onListSelectionChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        TabInfo tabInfo = this.getSelectedTab();
        if (tabInfo != null) {
            this.setTabTitle(tabInfo);
            this.setTab(tabInfo);
        }
    }

    private TabInfo getSelectedTab() {
        return this.tabList.getSelectedValue();
    }

    private void setTabTitle(TabInfo info) {
        if (info.getMarkedTitleText() != null) {
            MnemonicUtils.configure(this.titleLabel, info.getMarkedTitleText());
        } else {
            this.titleLabel.setText(info.getTabText());
        }
    }

    private void setTab(TabInfo info) {
        this.cardPanel.showCard(info.getTabText());
    }
}

