/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane.property;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.MessageType;
import com.jgoodies.dialogs.core.internal.JSDLAccessibleRole;
import com.jgoodies.dialogs.core.internal.PropertyPaneAction;
import com.jgoodies.dialogs.core.pane.AbstractStyledPane;
import com.jgoodies.dialogs.core.pane.AbstractStyledPaneVisualConfiguration;
import com.jgoodies.dialogs.core.pane.property.PropertyPaneModel;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class PropertyPane
extends AbstractStyledPane<AbstractStyledPaneVisualConfiguration> {
    private static final String UI_CLASS_ID = "JSDL.PropertyPaneUI";

    public PropertyPane() {
        this(new JLabel("A PropertyPane"), CommandValue.OK, (Object)CommandValue.CANCEL);
    }

    public PropertyPane(JComponent content) {
        this(content, CommandValue.OK, (Object)CommandValue.CANCEL);
    }

    public PropertyPane(JComponent content, Object okObject, Object cancelObject) {
        this(content, new Object[]{okObject, cancelObject});
    }

    public PropertyPane(JComponent content, Object okObject, Object cancelObject, Object applyObject) {
        this(content, new Object[]{okObject, cancelObject, applyObject});
    }

    public PropertyPane(JComponent content, PropertyPaneModel model) {
        this(content, PropertyPaneAction.createOKCancelApplyActionsFor(model));
    }

    protected PropertyPane(JComponent content, Object[] commitObjects) {
        super(MessageType.PLAIN, content, Preconditions.checkNotNull(commitObjects, "The %s must not be null.", "commitObjects"));
        Preconditions.checkArgument(commitObjects.length >= 2, "Missing property pane commit object.\nYou must provide an OK object, a Cancel object, and may provide an optional Apply object.");
        Preconditions.checkArgument(commitObjects.length <= 3, "Too many property pane commit objects.\nYou must provide an OK object, a Cancel object, and may provide an optional Apply object.");
        Preconditions.checkArgument(!(commitObjects[0] instanceof CommandValue) || commitObjects[0] == CommandValue.OK, "If the okObject is a CommandValue it must be CommandValue.OK.");
        Preconditions.checkArgument(!(commitObjects[1] instanceof CommandValue) || commitObjects[1] == CommandValue.CANCEL || commitObjects[1] == CommandValue.CLOSE, "If the cancelObject is a CommandValue it must be CommandValue.CANCEL or CommandValue.CLOSE.");
        Preconditions.checkArgument(commitObjects.length <= 2 || !(commitObjects[2] instanceof CommandValue) || commitObjects[2] == CommandValue.APPLY, "If the applyObject is a CommandValue it must be CommandValue.APPLY.");
        this.setCancelCommand(commitObjects[1]);
        this.updateUI();
    }

    @Override
    protected void setContent(JComponent content) {
        super.setContent(content);
    }

    @Override
    protected String layoutGroup() {
        return "PropertyPane";
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    @Override
    protected AccessibleRole getAccessibleRole() {
        return JSDLAccessibleRole.PROPERTY_PANE;
    }
}

