/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.tabs;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.promise.Promise;
import com.jgoodies.common.promise.Promises;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.common.swing.collect.ArrayListModel;
import com.jgoodies.common.swing.internal.AncestorSupport;
import com.jgoodies.fluent.tabs.Tab;
import com.jgoodies.navigation.views.AbstractViewModel;
import com.jgoodies.navigation.views.View;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class TabModel<T extends Tab>
extends AbstractViewModel<T> {
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_TAB_SEARCH_ENABLED = "tabSearchEnabled";
    private static final int DEFAULT_TAB_SEARCH_WIDTH = 300;
    private Consumer<EventObject> newTabHandler = null;
    private boolean tabSearchEnabled = false;
    private ListCellRenderer<T> tabSearchCellRenderer;
    private int tabSearchWidth = -1;
    private int lastOpenedTab = -1;

    public final boolean isEditable() {
        return this.newTabHandler != null;
    }

    public final void setNewTabHandler(Consumer<EventObject> handler) {
        boolean oldEditable = this.isEditable();
        this.newTabHandler = handler;
        this.firePropertyChange(PROPERTY_EDITABLE, oldEditable, this.isEditable());
    }

    public final boolean isTabSearchEnabled() {
        return this.tabSearchEnabled;
    }

    public final void setTabSearchEnabled(boolean b) {
        Preconditions.checkArgument(!b || this.tabSearchCellRenderer != null, "A tab search renderer must be set, before this feature can be enabled.");
        this.tabSearchEnabled = b;
        this.firePropertyChange(PROPERTY_TAB_SEARCH_ENABLED, this.tabSearchEnabled, this.tabSearchEnabled);
    }

    public final void setTabSearchCellRenderer(ListCellRenderer<T> renderer) {
        this.tabSearchCellRenderer = renderer;
    }

    public final void setTabSearchWidth(int width) {
        this.tabSearchWidth = width;
    }

    public final boolean isSelectedTabCloseable() {
        T tab = this.getSelectedTab();
        return tab != null && tab.isCloseable();
    }

    public final boolean hasCloseableTabs() {
        return this.getTabs().stream().anyMatch(Tab::isCloseable);
    }

    public final boolean hasCloseableOtherTabs() {
        Object selected = this.getSelectedTab();
        return this.getTabs().stream().anyMatch(tab -> tab != selected && tab.isCloseable());
    }

    public final boolean hasCloseableTabsToTheRight(T tab) {
        int tabIndex = this.indexOf(tab);
        Preconditions.checkArgument(tabIndex != -1, "The given tab must be in the tab model:" + this);
        for (int index = tabIndex + 1; index < this.size(); ++index) {
            if (!this.get(index).isCloseable()) continue;
            return true;
        }
        return false;
    }

    public final void addTab(T tab) {
        super.add(tab);
    }

    public final void addTab(int index, T tab) {
        super.add(index, tab);
    }

    public final void removeTab(T tab) {
        super.remove(tab);
    }

    public final void clearTabs() {
        super.clear();
    }

    @Override
    public final int size() {
        return super.size();
    }

    @Override
    public final boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public final T get(int index) {
        return (T)((Tab)super.get(index));
    }

    @Override
    public final int indexOf(T tab) {
        return super.indexOf(tab);
    }

    public final List<T> getTabs() {
        return this.getViews();
    }

    public final List<T> getCloseableTabs() {
        return this.getTabs().stream().filter(Tab::isCloseable).collect(Collectors.toList());
    }

    public final T getSelectedTab() {
        return (T)((Tab)this.getSelectedView());
    }

    public final void setSelectedTab(T tab) {
        this.setSelectedView(tab);
    }

    public final boolean selectById(Object id) {
        int index = this.indexOfId(id);
        if (index == -1) {
            return false;
        }
        this.setSelectedIndex(index);
        return true;
    }

    public final int indexOfId(Object id) {
        return this.indexOf(id, Tab::getId);
    }

    public final Promise<Boolean> closeSelectedTab(EventObject evt) {
        return this.closeTab(evt, this.getSelectedTab());
    }

    public final void closeOtherTabs(EventObject evt) {
        this.closeTabs0(TabModel.windowEventFor(evt), this.size() - 1, 0, this.getSelectedIndex());
    }

    public final void closeTabsToTheRight(EventObject evt, T tab) {
        int tabIndex = this.indexOf(tab);
        Preconditions.checkArgument(tabIndex != -1, "The given tab must be in the tab model:" + this);
        this.closeTabs0(TabModel.windowEventFor(evt), this.size() - 1, tabIndex + 1, -1);
    }

    public Promise<Boolean> closeTab(EventObject evt, T tab) {
        return this.closeTab0(evt, tab);
    }

    private Promise<Boolean> closeTab0(EventObject evt, T tab) {
        return tab.onClosing(evt).thenApply(closingSuccessful -> {
            if (closingSuccessful.booleanValue()) {
                this.remove(tab);
                tab.onClosed(evt);
            }
            return closingSuccessful;
        });
    }

    private Promise<Boolean> closeTabs0(EventObject evt, int index, int endIndex, int omitIndex) {
        if (index < endIndex) {
            this.lastOpenedTab = this.getSelectedIndex();
            return Promise.of(true);
        }
        View tab = this.get(index);
        if (index == omitIndex || !tab.isCloseable()) {
            return this.closeTabs0(evt, index - 1, endIndex, omitIndex);
        }
        return tab.onClosing(evt).thenCompose(arg_0 -> this.lambda$closeTabs0$2((Tab)tab, evt, index, endIndex, omitIndex, arg_0));
    }

    public final Promise<Boolean> onClosing(EventObject evt) {
        ArrayList<T> tabsCopy = new ArrayList<T>(this.getTabs());
        return Promises.allMatch(tabsCopy, tab -> this.closeTab0(evt, tab));
    }

    public void pinTab(T tab) {
        Preconditions.checkState(!tab.isPinned(), "The tab to pin must not be pinned.");
        T selectedTab = this.getSelectedTab();
        this.remove(tab);
        if (tab instanceof Tab.DefaultTab) {
            ((Tab.DefaultTab)tab).setPinned(true);
        }
        this.add(this.firstNonPinnedIndex(), tab);
        this.setSelectedTab(selectedTab);
    }

    public void unpinTab(T tab) {
        Preconditions.checkState(tab.isPinned(), "The tab to unpin must be pinned.");
        T selectedTab = this.getSelectedTab();
        this.remove(tab);
        if (tab instanceof Tab.DefaultTab) {
            ((Tab.DefaultTab)tab).setPinned(false);
        }
        this.add(this.firstNonPinnedIndex(), tab);
        this.setSelectedTab(selectedTab);
    }

    public final void switchToTab(int index) {
        Preconditions.checkArgument(index >= 0, "tab index must be >= 0");
        Preconditions.checkArgument(index < this.size(), "tab index must be < " + this.size());
        this.setSelectedIndex(index);
    }

    public final void switchToLastTab() {
        if (this.size() > 0) {
            this.setSelectedIndex(this.size() - 1);
        }
    }

    public final void switchToNextTab() {
        int newIndex = this.getSelectedIndex() + 1;
        if (newIndex >= this.size()) {
            newIndex = 0;
        }
        this.setSelectedIndex(newIndex);
    }

    public final void switchToPreviousTab() {
        int newIndex = this.getSelectedIndex() - 1;
        if (newIndex < 0) {
            newIndex = this.size() - 1;
        }
        this.setSelectedIndex(newIndex);
    }

    final void onNewTabClicked(EventObject evt) {
        if (this.newTabHandler != null) {
            this.newTabHandler.accept(evt);
        }
    }

    protected void onSearchTabsClicked(EventObject evt) {
        ArrayListModel<T> listModel = new ArrayListModel<T>(this.getTabs());
        JList<T> list = new JList<T>(listModel);
        list.setSelectionMode(0);
        list.setCellRenderer(this.tabSearchCellRenderer);
        JScrollPane scrollPane = new JScrollPane(list);
        scrollPane.setBorder(null);
        scrollPane.getVerticalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        scrollPane.getHorizontalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        JPopupMenu popup = new JPopupMenu();
        popup.putClientProperty("JPopupMenu.noMargin", Boolean.TRUE);
        popup.setFocusable(false);
        popup.add(scrollPane);
        int popupWidth = this.tabSearchWidth != -1 ? this.tabSearchWidth : 300;
        int popupHeight = Math.min(list.getPreferredSize().height + 2, 800);
        Dimension popupSize = ScreenScaling.physicalDimension(popupWidth, popupHeight);
        popup.setPopupSize(popupSize);
        MouseEvent mEvt = (MouseEvent)evt;
        list.addListSelectionListener(e -> {
            this.setSelectedTab((Tab)list.getSelectedValue());
            popup.setVisible(false);
        });
        int x = mEvt.getComponent().getWidth() - popupSize.width;
        int y = mEvt.getComponent().getHeight();
        popup.show(mEvt.getComponent(), x, y);
    }

    @Override
    protected final int insertionIndex() {
        int index;
        if (this.lastOpenedTab == -1) {
            return super.insertionIndex();
        }
        for (index = this.lastOpenedTab + 1; index < this.size() && this.get(index).isPinned(); ++index) {
        }
        return index;
    }

    @Override
    protected final int selectionIndexAfterRemove(int oldSelectedIndex, T view) {
        int openerIndex;
        if (view.getOpenerTabId() != null && (openerIndex = this.indexOfId(view.getOpenerTabId())) != -1 && openerIndex != oldSelectedIndex) {
            return openerIndex;
        }
        return super.selectionIndexAfterRemove(oldSelectedIndex, view);
    }

    @Override
    protected final void updateIndicesOnAdd(int index) {
        this.lastOpenedTab = index;
    }

    @Override
    protected final void updateIndicesOnRemove(int oldViewIndex) {
        this.lastOpenedTab = oldViewIndex == this.lastOpenedTab ? -1 : Math.max(-1, this.lastOpenedTab - 1);
    }

    @Override
    protected final void updateIndicesOnClear() {
        this.lastOpenedTab = -1;
    }

    @Override
    protected final void updateIndicesOnSelect(int index) {
        this.lastOpenedTab = index;
    }

    protected final int firstNonPinnedIndex() {
        int index = 0;
        for (Tab tab : this.getTabs()) {
            if (!tab.isPinned()) {
                return index;
            }
            ++index;
        }
        return index;
    }

    private static EventObject windowEventFor(EventObject evt) {
        return new EventObject(AncestorSupport.getWindowFor(evt));
    }

    private /* synthetic */ Promise lambda$closeTabs0$2(Tab tab, EventObject evt, int index, int endIndex, int omitIndex, Boolean closingSuccessful) {
        if (closingSuccessful.booleanValue()) {
            this.remove(tab);
            tab.onClosed(evt);
            return this.closeTabs0(evt, index - 1, endIndex, omitIndex);
        }
        return Promise.of(false);
    }
}

