/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport;

import com.jgoodies.application.Application;
import com.jgoodies.common.base.Strings;
import com.jgoodies.framework.osx.OSXApplicationMenu;
import com.jgoodies.jdiskreport.domain.PersistencyManager;
import com.jgoodies.jdiskreport.domain.ScanConfiguration;
import com.jgoodies.jdiskreport.domain.ScanResult;
import com.jgoodies.jdiskreport.domain.scan.ConsoleScanLog;
import com.jgoodies.jdiskreport.domain.scan.FileWalkerScanner;
import com.jgoodies.jdiskreport.domain.scan.Scanner;
import com.jgoodies.jdiskreport.gui.application.JDApplication;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public final class JDiskReport {
    public static ScanConfiguration scanConfiguration;
    public static ScanResult scanResult;

    public static void main(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        if (!Locale.GERMAN.getLanguage().equals(Locale.getDefault().getLanguage())) {
            Locale.setDefault(Locale.ENGLISH);
        }
        JDiskReport.dispatch(args);
    }

    private static void dispatch(String[] args) {
        if (args.length != 0) {
            JDiskReport.printUsage();
            return;
        }
        JDiskReport.replaceSecurityManager();
        String pathStr = System.getProperty("path");
        String configFileStr = System.getProperty("config");
        String inputFileStr = System.getProperty("input");
        String outputFileStr = System.getProperty("output");
        System.out.println("path=" + JDiskReport.format(pathStr));
        System.out.println("config=" + JDiskReport.format(configFileStr));
        System.out.println("input=" + JDiskReport.format(inputFileStr));
        System.out.println("output=" + JDiskReport.format(outputFileStr));
        boolean hasPath = Strings.isNotBlank(pathStr);
        boolean hasConfig = Strings.isNotBlank(configFileStr);
        boolean hasInput = Strings.isNotBlank(inputFileStr);
        boolean hasOutput = Strings.isNotBlank(outputFileStr);
        if (hasPath) {
            if (hasConfig) {
                JDiskReport.printUsage();
                return;
            }
            if (hasInput) {
                JDiskReport.printUsage();
                return;
            }
            JDiskReport.onPath(pathStr, outputFileStr);
            return;
        }
        if (hasConfig) {
            if (hasInput) {
                JDiskReport.printUsage();
                return;
            }
            JDiskReport.onConfig(configFileStr, outputFileStr);
            return;
        }
        if (hasInput) {
            if (hasOutput) {
                JDiskReport.printUsage();
                return;
            }
            JDiskReport.onInput(inputFileStr);
            return;
        }
        JDiskReport.showGUI();
    }

    private static void onPath(String pathStr, String outputFileStr) {
        Path scanPath = JDiskReport.toValidPath(pathStr);
        if (scanPath == null) {
            return;
        }
        ScanConfiguration pathConfiguration = new ScanConfiguration(scanPath);
        if (Strings.isNotBlank(outputFileStr)) {
            JDiskReport.scanInBackgroundAndSaveReport(pathConfiguration, outputFileStr);
            return;
        }
        JDiskReport.showGUI(pathConfiguration);
    }

    private static void onConfig(String configFileStr, String outputFileStr) {
        File configFile = JDiskReport.toValidConfigFile(configFileStr);
        if (configFile == null) {
            return;
        }
        ScanConfiguration configuration = PersistencyManager.readScanConfiguration(configFile);
        if (configuration == null) {
            return;
        }
        if (Strings.isNotBlank(outputFileStr)) {
            JDiskReport.scanInBackgroundAndSaveReport(configuration, outputFileStr);
            return;
        }
        JDiskReport.showGUI(configuration);
    }

    private static void onInput(String inputFileStr) {
        File inputFile = JDiskReport.toValidInputFile(inputFileStr);
        if (inputFile == null) {
            return;
        }
        ScanResult result = PersistencyManager.readScanResult(inputFile);
        if (result == null) {
            return;
        }
        JDiskReport.showGUI(result);
    }

    private static void scanInBackgroundAndSaveReport(ScanConfiguration configuration, String outputFileStr) {
        File outputFile = JDiskReport.toValidOutputFile(outputFileStr);
        ConsoleScanLog log = new ConsoleScanLog();
        ScanResult result = JDiskReport.createScanner().scan(configuration, log);
        PersistencyManager.writeScanResult(outputFile, result);
    }

    private static void showGUI(ScanConfiguration configuration) {
        scanConfiguration = configuration;
        JDiskReport.showGUI();
    }

    private static void showGUI(ScanResult result) {
        scanResult = result;
        JDiskReport.showGUI();
    }

    private static void showGUI() {
        OSXApplicationMenu.setAboutName("JDiskReport");
        Application.launch(JDApplication.class, new String[0]);
    }

    public static Scanner createScanner() {
        return new FileWalkerScanner();
    }

    public static Path toValidPath(String pathStr) {
        Path path = Paths.get(pathStr, new String[0]);
        if (!Files.exists(path = path.toAbsolutePath(), new LinkOption[0])) {
            System.err.format("The path %s does not exist.\n", path);
            return null;
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            System.err.format("%s is not a directory.\n", path);
            return null;
        }
        return path;
    }

    private static File toValidConfigFile(String configFileStr) {
        return JDiskReport.toValidFile(configFileStr, "config file");
    }

    private static File toValidInputFile(String inputFileStr) {
        return JDiskReport.toValidFile(inputFileStr, "input file");
    }

    private static File toValidFile(String fileStr, String fileType) {
        Path path = Paths.get(fileStr, new String[0]);
        File file = path.toFile();
        if (!Files.exists(path, new LinkOption[0])) {
            System.err.format("The %s '%s' does not exist.\n", fileType, path);
            return null;
        }
        if (!file.isFile()) {
            System.err.format("The %s '%s' is not a file.\n", fileType, path);
            return null;
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File toValidOutputFile(String outputFileStr) {
        File outputFile = Paths.get(outputFileStr, new String[0]).toFile();
        if (!outputFile.isFile()) {
            System.err.format("The output file '%s' is not a file.\n", outputFile);
            return null;
        }
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            File file = outputFile;
            return file;
        }
        catch (FileNotFoundException ex) {
            System.err.format("The output file '%s' exists but is a directory rather than a regular file, does not exist but cannot be created, or cannot be opened for any other reason.\n", outputFile);
            ex.printStackTrace();
            return null;
        }
        catch (IOException ex) {
            System.err.println("Failed to open the output file: " + outputFile);
            ex.printStackTrace();
            return null;
        }
    }

    private static void printUsage() {
        ResourceBundle bundle = ResourceBundle.getBundle("com.jgoodies.jdiskreport.resources.JDiskReport");
        String rawUsage = bundle.getString("Application.usage");
        String usage = rawUsage.replace("${jdiskreport.jar}", bundle.getString("jdiskreport.jar"));
        System.out.println(usage);
    }

    private static String format(String s) {
        return s == null ? "null" : "'" + s + "'";
    }

    private static void replaceSecurityManager() {
        try {
            System.setSecurityManager(null);
        }
        catch (RuntimeException e) {
            Logger.getLogger("Starter").info("Running with security manager." + e.getLocalizedMessage());
        }
    }
}

