/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.domain;

import com.jgoodies.jdiskreport.domain.DirectorySnapshot;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

public final class FileTreeSnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DirectorySnapshot directorySnapshot;
    private final long directoryCount;
    private final long fileCount;
    private final long filteredFileCount;

    public FileTreeSnapshot(DirectorySnapshot directorySnapshot, long directoryCount, long fileCount, long filteredFileCount) {
        this.directorySnapshot = directorySnapshot;
        this.directoryCount = directoryCount;
        this.fileCount = fileCount;
        this.filteredFileCount = filteredFileCount;
    }

    public DirectorySnapshot getDirectorySnapshot() {
        return this.directorySnapshot;
    }

    public Date getStartTime() {
        return new Date(this.directorySnapshot.startTimeMillis());
    }

    public Date getEndTime() {
        return new Date(this.directorySnapshot.stopTimeMillis());
    }

    public long getScanDurationMillis() {
        return this.directorySnapshot.stopTimeMillis() - this.directorySnapshot.startTimeMillis();
    }

    public long getDirectoryCount() {
        return this.directoryCount;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("FileTreeSnapshot: ");
        this.appendString(builder);
        return builder.toString();
    }

    void appendString(StringBuilder builder) {
        builder.append("\nDirectories=");
        builder.append(this.directoryCount);
        builder.append("\nFiles=");
        builder.append(this.fileCount);
        if (this.filteredFileCount > 0L) {
            builder.append("\nFiltered files=");
            builder.append(this.filteredFileCount);
        }
        builder.append("\nStarted=");
        builder.append(FileTreeSnapshot.formatDateTime(this.getStartTime()));
        builder.append("\nFinished=");
        builder.append(FileTreeSnapshot.formatDateTime(this.getEndTime()));
        builder.append("\nDuration=");
        builder.append(FileTreeSnapshot.formatDuration(this.getScanDurationMillis()));
    }

    private static String formatDateTime(Date time) {
        return DateFormat.getDateTimeInstance(2, 2).format(time);
    }

    private static String formatDuration(long time) {
        long seconds = time / 1000L;
        if (seconds < 60L) {
            return seconds + " seconds";
        }
        long minutes = seconds / 60L;
        seconds %= 60L;
        if (minutes < 60L) {
            return minutes + " minutes, " + seconds + " seconds";
        }
        long hours = minutes / 60L;
        return hours + " hours, " + (minutes %= 60L) + " minutes";
    }
}

