/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.domain.scan;

import com.jgoodies.jdiskreport.domain.DirectorySnapshot;
import com.jgoodies.jdiskreport.domain.FileFilter;
import com.jgoodies.jdiskreport.domain.FileTreeSnapshot;
import com.jgoodies.jdiskreport.domain.ScanConfiguration;
import com.jgoodies.jdiskreport.domain.ScanResult;
import com.jgoodies.jdiskreport.domain.scan.Scanner;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Stack;

public final class FileWalkerScanner
implements Scanner {
    @Override
    public ScanResult scan(ScanConfiguration scanConfiguration, Scanner.ScanLog scanLog) {
        if (!Files.exists(scanConfiguration.getPath(), new LinkOption[0])) {
            scanLog.logWarning("The scan target directory does not exist: " + scanConfiguration.getPath());
            return null;
        }
        Path start = scanConfiguration.getPath();
        ScanFileVisitor visitor = new ScanFileVisitor(scanConfiguration, scanLog);
        try {
            scanLog.logConfiguration(scanConfiguration);
            Files.walkFileTree(start, visitor);
            ScanResult result = visitor.getScanResult();
            scanLog.logSummary(result);
            return result;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static final class ScanFileVisitor
    implements FileVisitor<Path> {
        private final ScanConfiguration configuration;
        private final FileFilter filter;
        private final Scanner.ScanLog scanLog;
        private final Stack<DirectorySnapshot> scanStack;
        private long directoryCount;
        private long fileCount;
        private long filteredFileCount;
        private DirectorySnapshot currentDirectory;

        ScanFileVisitor(ScanConfiguration configuration, Scanner.ScanLog scanLog) {
            this.configuration = configuration;
            this.filter = new FileFilter(configuration);
            this.scanLog = scanLog;
            this.scanStack = new Stack();
            this.directoryCount = 0L;
            this.fileCount = 0L;
            this.filteredFileCount = 0L;
            this.currentDirectory = new DirectorySnapshot("Root");
            this.currentDirectory.startSnapshot();
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            DirectorySnapshot childScan = this.currentDirectory.addDirectory(dir, attrs);
            this.scanStack.push(this.currentDirectory);
            this.currentDirectory = childScan;
            this.currentDirectory.startSnapshot();
            this.scanLog.logDirectory(dir.toFile(), this.scanStack.size());
            ++this.directoryCount;
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            ++this.fileCount;
            if (this.filter != null && !this.filter.accept(file.getFileName(), attrs)) {
                ++this.filteredFileCount;
                return FileVisitResult.CONTINUE;
            }
            if (attrs.isSymbolicLink()) {
                System.out.format("Link: %s%n", file);
                System.out.format("Link size=%d%n", attrs.size());
            } else if (!attrs.isRegularFile() && attrs.isOther()) {
                System.out.format("Other: %s%n", file);
            }
            if (attrs.size() < 0L) {
                this.scanLog.logWarning(String.format("Negative file size: %s%n", file));
            }
            this.currentDirectory.addFile(file, attrs);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            this.scanLog.logWarning(exc.toString());
            this.currentDirectory.addDirectory(file, exc);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            this.finallyVisitDirectory(dir);
            return FileVisitResult.CONTINUE;
        }

        private void finallyVisitDirectory(Path dir) {
            this.currentDirectory.stopSnapshot();
            this.currentDirectory.trimToSize();
            this.currentDirectory = this.scanStack.pop();
        }

        ScanResult getScanResult() {
            this.currentDirectory.stopSnapshot();
            DirectorySnapshot root = this.currentDirectory.getDirectories().get(0);
            FileTreeSnapshot snapshot = new FileTreeSnapshot(root, this.directoryCount, this.fileCount, this.filteredFileCount);
            return new ScanResult(this.configuration, snapshot);
        }
    }
}

