/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.node;

import com.jgoodies.jdiskreport.gui.node.DirectoryNode;
import com.jgoodies.jdiskreport.gui.node.RootNode;
import com.jgoodies.jdiskreport.gui.shared.util.ExtFileSystemView;
import java.io.File;
import javax.swing.Icon;

public abstract class AbstractNode {
    private DirectoryNode parent;
    private File file;

    public abstract String getName();

    public abstract boolean isFileLeaf();

    public File getFile() {
        if (this.file == null) {
            this.file = new File(this.getParent().getFile(), this.getName());
        }
        return this.file;
    }

    public abstract long getSize();

    public abstract long getFileCount();

    public double getAbsoluteSize() {
        long mySize = this.getSize();
        if (mySize == 0L) {
            return 0.0;
        }
        long rootSize = this.getRoot().getSize();
        return rootSize == 0L ? 0.0 : (double)mySize / (double)rootSize;
    }

    public double getRelativeSize() {
        long mySize = this.getSize();
        if (mySize == 0L) {
            return 0.0;
        }
        long parentSize = this.getParent().getSize();
        return parentSize == 0L ? 0.0 : (double)(mySize / parentSize);
    }

    public Icon getIcon(boolean selected) {
        return ExtFileSystemView.getInstance().getIcon(this.getFile(), selected);
    }

    public RootNode getRoot() {
        return this.getParent().getRoot();
    }

    public DirectoryNode getParent() {
        return this.parent;
    }

    void setParent(DirectoryNode parent) {
        this.parent = parent;
    }

    public void clearCachedFiles() {
        this.file = null;
    }
}

