/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.statistic;

import com.jgoodies.common.internal.DateUtils;
import com.jgoodies.jdiskreport.gui.node.FileNode;
import com.jgoodies.jdiskreport.gui.statistic.AbstractDistribution;
import java.time.LocalDate;

abstract class AbstractTimeDistribution
extends AbstractDistribution {
    private static final long[] ROW_BOUNDS = AbstractTimeDistribution.computeRowBounds();

    AbstractTimeDistribution() {
    }

    @Override
    protected int getRowCount() {
        return ROW_BOUNDS.length;
    }

    @Override
    String getKeyPrefix() {
        return "TimeDistribution";
    }

    @Override
    protected void add(FileNode fileNode) {
        long lastModified = this.getTimeValue(fileNode);
        long size = fileNode.getSize();
        int rowCount = this.getRowCount();
        for (int i = rowCount - 1; i >= 0; --i) {
            if (lastModified <= ROW_BOUNDS[i]) continue;
            this.add(i, size, 1L);
            return;
        }
    }

    abstract long getTimeValue(FileNode var1);

    private static long toMillis(LocalDate date) {
        return DateUtils.toDate(date).getTime();
    }

    private static long[] computeRowBounds() {
        LocalDate today = LocalDate.now();
        return new long[]{0L, AbstractTimeDistribution.toMillis(today.minusYears(30L)), AbstractTimeDistribution.toMillis(today.minusYears(20L)), AbstractTimeDistribution.toMillis(today.minusYears(10L)), AbstractTimeDistribution.toMillis(today.minusYears(5L)), AbstractTimeDistribution.toMillis(today.minusYears(2L)), AbstractTimeDistribution.toMillis(today.minusYears(1L)), AbstractTimeDistribution.toMillis(today.minusDays(180L)), AbstractTimeDistribution.toMillis(today.minusDays(90L)), AbstractTimeDistribution.toMillis(today.minusDays(30L)), AbstractTimeDistribution.toMillis(today.minusDays(7L)), AbstractTimeDistribution.toMillis(today.minusDays(1L)), AbstractTimeDistribution.toMillis(today)};
    }
}

