/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.search;

import com.jgoodies.common.swing.Listeners;
import com.jgoodies.search.Completion;
import com.jgoodies.search.CompletionInfoView;
import com.jgoodies.search.CompletionManager;
import com.jgoodies.search.CompletionProcessor2;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

final class CompletionView {
    private final CompletionManager completionManager;
    private final CompletionInfoView completionInfoView;
    private JPopupMenu popup;
    private JList<? extends Completion> completionList;
    private JScrollPane scrollPane;
    private PropertyChangeListener popupMenuVisibleHandler;
    private ListSelectionListener completionSelectionHandler;
    private MouseListener clickHandler;

    CompletionView(CompletionManager completionManager) {
        this.completionManager = completionManager;
        this.completionInfoView = new CompletionInfoView(completionManager, this);
    }

    boolean isVisible() {
        return this.popup != null;
    }

    void setVisible(boolean b) {
        if (!b) {
            this.completionInfoView.hide();
        }
        if (this.isVisible() == b) {
            return;
        }
        if (b) {
            this.show();
        } else {
            this.popup.setVisible(false);
        }
    }

    JPopupMenu getPopup() {
        return this.popup;
    }

    private void initComponents() {
        this.completionList = new JList<Completion>(this.completionManager.getCompletionListModel());
        if (this.completionManager.getComponent() != null) {
            this.completionList.setFont(this.completionManager.getComponent().getFont());
        }
        this.completionList.setSelectionModel(this.completionManager.getCompletionListSelectionModel());
        this.completionList.setCellRenderer(this.completionManager.getCompletionRenderer());
        this.completionList.setVisibleRowCount(CompletionManager.getMaxVisibleCompletions());
        this.scrollPane = new JScrollPane(this.completionList);
        this.scrollPane.setBorder(null);
        this.scrollPane.getVerticalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        this.scrollPane.getHorizontalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        this.popup = new JPopupMenu();
        this.popup.putClientProperty("JPopupMenu.noMargin", Boolean.TRUE);
        this.popup.setFocusable(false);
        this.popup.add(this.scrollPane);
        this.completionList.setFocusable(false);
    }

    private void show() {
        JTextComponent component = this.completionManager.getComponent();
        if (!component.isShowing()) {
            return;
        }
        this.initComponents();
        this.completionInfoView.initTimer();
        this.popupMenuVisibleHandler = this::onPopupMenuVisibleChange;
        this.completionSelectionHandler = this::onCompletionSelectionIndexChanged;
        this.clickHandler = Listeners.mouseClicked(this::onMouseClicked);
        this.popup.addPropertyChangeListener("visible", this.popupMenuVisibleHandler);
        this.completionManager.getCompletionListSelectionModel().addListSelectionListener(this.completionSelectionHandler);
        this.completionList.addMouseListener(this.clickHandler);
        Point origin = this.computePopupOrigin();
        this.popup.setPopupSize(this.computePopupSize());
        this.popup.show(component, origin.x, origin.y);
    }

    private void hide() {
        this.completionInfoView.hide();
        this.popup.removePropertyChangeListener("visible", this.popupMenuVisibleHandler);
        this.completionManager.getCompletionListSelectionModel().removeListSelectionListener(this.completionSelectionHandler);
        this.completionList.removeMouseListener(this.clickHandler);
        this.completionSelectionHandler = null;
        this.popupMenuVisibleHandler = null;
        this.clickHandler = null;
        this.popup = null;
        this.completionList = null;
    }

    private Point computePopupOrigin() {
        JTextComponent component = this.completionManager.getComponent();
        Point defaultOrigin = new Point(0, component.getHeight() - 1);
        if (!this.isCompletionProcessor2()) {
            return defaultOrigin;
        }
        CompletionProcessor2 processor2 = (CompletionProcessor2)this.completionManager.getProcessor();
        int viewIndex = processor2.viewIndex(component.getText(), component.getCaretPosition());
        try {
            Rectangle rec = component.modelToView(viewIndex);
            return new Point(rec.x - 2, rec.y + 1 + rec.height);
        }
        catch (BadLocationException ex) {
            return defaultOrigin;
        }
    }

    private Dimension computePopupSize() {
        int width;
        int componentWidth = this.completionManager.getComponent().getWidth();
        Completion prototype = this.completionManager.getCompletionPrototypeDisplayValue();
        if (prototype == null) {
            width = componentWidth;
        } else {
            ListCellRenderer<Object> renderer = this.completionManager.getCompletionRenderer();
            Component component = renderer.getListCellRendererComponent(this.completionList, prototype, 0, false, false);
            width = component.getPreferredSize().width;
            Insets insets = this.popup.getInsets();
            width += insets.left + insets.right;
            JViewport viewport = this.scrollPane.getViewport();
            if (viewport.getViewSize().height > viewport.getPreferredSize().height) {
                JScrollBar verticalBar = this.scrollPane.getVerticalScrollBar();
                width += verticalBar.getPreferredSize().width;
            }
            if (width < componentWidth && !this.isCompletionProcessor2()) {
                width = componentWidth;
            }
        }
        int height = this.popup.getPreferredSize().height;
        return new Dimension(width, height);
    }

    private boolean isCompletionProcessor2() {
        return this.completionManager.getProcessor() instanceof CompletionProcessor2;
    }

    private void onPopupMenuVisibleChange(PropertyChangeEvent evt) {
        if (this.popup.isVisible()) {
            this.completionManager.completionPopupVisible();
            this.completionInfoView.startTimer();
        } else {
            this.hide();
            this.completionManager.completionPopupClosed();
        }
    }

    private void onCompletionSelectionIndexChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        if (this.completionManager.hasSelection()) {
            this.completionList.ensureIndexIsVisible(this.completionManager.getCompletionSelectionIndex());
            this.completionInfoView.startTimer();
        } else {
            this.completionInfoView.hide();
        }
    }

    private void onMouseClicked(MouseEvent evt) {
        if (this.completionManager.hasSelection()) {
            this.completionManager.insertSelectedCompletion();
        }
    }
}

