/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.evaluator.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.declarative.dsl.evaluation.AnalysisStatementFilter;
import org.gradle.declarative.dsl.evaluation.EvaluationSchema;
import org.gradle.declarative.dsl.evaluation.OperationGenerationId;
import org.gradle.internal.declarativedsl.analysis.DefaultCodeResolverKt;
import org.gradle.internal.declarativedsl.analysis.ResolutionResult;
import org.gradle.internal.declarativedsl.analysis.TracingResolver;
import org.gradle.internal.declarativedsl.evaluator.runner.AbstractAnalysisStepRunner;
import org.gradle.internal.declarativedsl.evaluator.runner.EvaluationResult;
import org.gradle.internal.declarativedsl.evaluator.runner.ParseAndResolveResult;
import org.gradle.internal.declarativedsl.language.LanguageTreeResult;
import org.gradle.internal.declarativedsl.language.SourceIdentifier;
import org.gradle.internal.declarativedsl.parsing.DefaultLanguageTreeBuilder;
import org.gradle.internal.declarativedsl.parsing.ParsedLightTree;
import org.gradle.internal.declarativedsl.parsing.ParserKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gradle/internal/declarativedsl/evaluator/runner/AnalysisStepRunner;", "Lorg/gradle/internal/declarativedsl/evaluator/runner/AbstractAnalysisStepRunner;", "<init>", "()V", "parseAndResolve", "Lorg/gradle/internal/declarativedsl/evaluator/runner/ParseAndResolveResult;", "evaluationSchema", "Lorg/gradle/declarative/dsl/evaluation/EvaluationSchema;", "scriptIdentifier", "", "scriptSource", "languageModelFromLightParser", "Lorg/gradle/internal/declarativedsl/language/LanguageTreeResult;", "languageTreeBuilder", "Lorg/gradle/internal/declarativedsl/parsing/DefaultLanguageTreeBuilder;", "declarative-dsl-evaluator"})
public class AnalysisStepRunner
extends AbstractAnalysisStepRunner {
    @NotNull
    private final DefaultLanguageTreeBuilder languageTreeBuilder = new DefaultLanguageTreeBuilder();

    @Override
    @NotNull
    public ParseAndResolveResult parseAndResolve(@NotNull EvaluationSchema evaluationSchema, @NotNull String scriptIdentifier, @NotNull String scriptSource) {
        ResolutionResult initialResolution;
        Intrinsics.checkNotNullParameter((Object)evaluationSchema, (String)"evaluationSchema");
        Intrinsics.checkNotNullParameter((Object)scriptIdentifier, (String)"scriptIdentifier");
        Intrinsics.checkNotNullParameter((Object)scriptSource, (String)"scriptSource");
        List failureReasons = new ArrayList();
        TracingResolver resolver = DefaultCodeResolverKt.tracingCodeResolver((OperationGenerationId)evaluationSchema.getOperationGenerationId(), (AnalysisStatementFilter)evaluationSchema.getAnalysisStatementFilter());
        LanguageTreeResult languageModel = this.languageModelFromLightParser(scriptIdentifier, scriptSource);
        if (!((Collection)languageModel.getAllFailures()).isEmpty()) {
            ((Collection)failureReasons).add(new EvaluationResult.NotEvaluated.StageFailure.FailuresInLanguageTree(languageModel.getAllFailures()));
        }
        if (!((Collection)(initialResolution = resolver.resolve(evaluationSchema.getAnalysisSchema(), languageModel.getImports(), languageModel.getTopLevelBlock())).getErrors()).isEmpty()) {
            ((Collection)failureReasons).add(new EvaluationResult.NotEvaluated.StageFailure.FailuresInResolution(initialResolution.getErrors()));
        }
        return new ParseAndResolveResult(languageModel, initialResolution, resolver.getTrace(), failureReasons);
    }

    private final LanguageTreeResult languageModelFromLightParser(String scriptIdentifier, String scriptSource) {
        ParsedLightTree parsedTree = ParserKt.parse((String)scriptSource);
        return this.languageTreeBuilder.build(parsedTree, new SourceIdentifier(scriptIdentifier));
    }
}

