/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing.type;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.internal.UncheckedException;
import org.gradle.plugins.signing.signatory.Signatory;
import org.gradle.plugins.signing.type.SignatureType;

public abstract class AbstractSignatureType
implements SignatureType {
    @Override
    public File sign(Signatory signatory, File toSign) {
        File signatureFile = this.fileFor(toSign);
        try (BufferedInputStream toSignStream = new BufferedInputStream(new FileInputStream(toSign));
             BufferedOutputStream signatureFileStream = new BufferedOutputStream(new FileOutputStream(signatureFile));){
            this.sign(signatory, toSignStream, signatureFileStream);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        return signatureFile;
    }

    @Override
    public void sign(Signatory signatory, InputStream toSign, OutputStream destination) {
        signatory.sign(toSign, destination);
    }

    @Override
    public File fileFor(File toSign) {
        return new File(toSign.getPath() + "." + this.getExtension());
    }

    @Override
    public String combinedExtension(File toSign) {
        String name = toSign.getName();
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex == -1 || dotIndex + 1 == name.length()) {
            return this.getExtension();
        }
        return name.substring(dotIndex + 1) + "." + this.getExtension();
    }
}

