/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.load;

import java.math.BigDecimal;
import pcgen.core.system.LoadInfo;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class LoadmultToken
extends AbstractNonEmptyToken<LoadInfo>
implements CDOMPrimaryToken<LoadInfo> {
    public String getTokenName() {
        return "LOADMULT";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, LoadInfo info, String value) {
        try {
            BigDecimal mult = new BigDecimal(value);
            if (mult.compareTo(BigDecimal.ZERO) <= 0) {
                return new ParseResult.Fail(this.getTokenName() + " requires a positive load multiplier, found : " + value, context);
            }
            info.setLoadScoreMultiplier(mult);
            return ParseResult.SUCCESS;
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail("Misunderstood Double in Tag: " + value, context);
        }
    }

    public String[] unparse(LoadContext context, LoadInfo info) {
        BigDecimal mod = info.getLoadScoreMultiplier();
        if (mod == null || mod.equals(BigDecimal.ZERO)) {
            return null;
        }
        return new String[]{mod.toString()};
    }

    public Class<LoadInfo> getTokenClass() {
        return LoadInfo.class;
    }
}

