/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.datacontrol;

import pcgen.base.util.FormatManager;
import pcgen.cdom.content.ContentDefinition;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class DataFormatToken
extends AbstractNonEmptyToken<ContentDefinition>
implements CDOMPrimaryToken<ContentDefinition>,
DeferredToken<ContentDefinition> {
    private static final Class<ContentDefinition> CONTENTDEF_CLASS = ContentDefinition.class;

    public String getTokenName() {
        return "DATAFORMAT";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, ContentDefinition def, String value) {
        FormatManager fmtMgr = context.getReferenceContext().getFormatManager(value);
        FormatManager old = def.setFormatManager(fmtMgr);
        if (old != null && !old.equals(fmtMgr)) {
            return new ParseResult.Fail("Content Definition " + def.getClass().getSimpleName() + " " + def.getKeyName() + " was defined as " + old.getIdentifierType() + " and " + value + " (using " + value + ")");
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, ContentDefinition def) {
        FormatManager manager = def.getFormatManager();
        if (manager == null) {
            return null;
        }
        return new String[]{manager.getIdentifierType()};
    }

    public Class<ContentDefinition> getTokenClass() {
        return CONTENTDEF_CLASS;
    }

    public boolean process(LoadContext context, ContentDefinition def) {
        boolean isMissingFormatManager;
        boolean bl = isMissingFormatManager = def.getFormatManager() == null;
        if (isMissingFormatManager) {
            Logging.errorPrint((String)("Content Definition " + def.getClass().getSimpleName() + " " + def.getKeyName() + " did not have a " + this.getTokenName()));
        }
        return !isMissingFormatManager;
    }

    public Class<ContentDefinition> getDeferredTokenClass() {
        return CONTENTDEF_CLASS;
    }
}

