/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChoiceActor;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.ConcretePersistentTransitionChoice;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.base.SelectableSet;
import pcgen.cdom.choiceset.ReferenceChoiceSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.WeaponProf;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;

public class WeaponbonusToken
extends AbstractTokenWithSeparator<PCClass>
implements CDOMPrimaryToken<PCClass>,
DeferredToken<PCClass>,
PersistentChoiceActor<WeaponProf> {
    private static final Class<WeaponProf> WEAPONPROF_CLASS = WeaponProf.class;

    public String getTokenName() {
        return "WEAPONBONUS";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClass pcc, String value) {
        StringTokenizer tok = new StringTokenizer(value, "|");
        boolean foundAny = false;
        boolean foundOther = false;
        while (tok.hasMoreTokens()) {
            CDOMGroupRef ref;
            String tokText = tok.nextToken();
            if ("ALL".equals(tokText)) {
                foundAny = true;
                ref = context.getReferenceContext().getCDOMAllReference(WEAPONPROF_CLASS);
                context.getObjectContext().addToList((CDOMObject)pcc, ListKey.WEAPONBONUS, (Object)ref);
                continue;
            }
            foundOther = true;
            ref = TokenUtilities.getTypeOrPrimitive((LoadContext)context, WEAPONPROF_CLASS, (String)tokText);
            if (ref == null) {
                return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
            }
            context.getObjectContext().addToList((CDOMObject)pcc, ListKey.WEAPONBONUS, (Object)ref);
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PCClass pcc) {
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)pcc, ListKey.WEAPONBONUS);
        Collection added = changes.getAdded();
        if (added == null || added.isEmpty()) {
            return null;
        }
        return new String[]{ReferenceUtilities.joinLstFormat((Collection)added, (String)"|")};
    }

    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }

    public boolean process(LoadContext context, PCClass obj) {
        List weaponbonus = obj.getListFor(ListKey.WEAPONBONUS);
        if (weaponbonus != null) {
            ReferenceChoiceSet rcs = new ReferenceChoiceSet((Collection)weaponbonus);
            ChoiceSet cs = new ChoiceSet(this.getTokenName(), (PrimitiveChoiceSet)rcs);
            cs.setTitle("Bonus WeaponProf Choice");
            ConcretePersistentTransitionChoice tc = new ConcretePersistentTransitionChoice((SelectableSet)cs, FormulaFactory.ONE);
            context.getObjectContext().addToList((CDOMObject)obj, ListKey.ADD, (Object)tc);
            tc.setChoiceActor((ChoiceActor)this);
        }
        return true;
    }

    public Class<PCClass> getDeferredTokenClass() {
        return PCClass.class;
    }

    public void applyChoice(CDOMObject owner, WeaponProf choice, PlayerCharacter pc) {
        pc.addWeaponBonus(owner, choice);
    }

    public boolean allow(WeaponProf item, PlayerCharacter pc, boolean allowStack) {
        return true;
    }

    public String encodeChoice(WeaponProf choice) {
        return choice.getKeyName();
    }

    public WeaponProf decodeChoice(LoadContext context, String s) {
        return (WeaponProf)context.getReferenceContext().silentlyGetConstructedCDOMObject(WeaponProf.class, s);
    }

    public void restoreChoice(PlayerCharacter pc, CDOMObject owner, WeaponProf choice) {
        pc.addWeaponBonus(owner, choice);
    }

    public void removeChoice(PlayerCharacter pc, CDOMObject owner, WeaponProf choice) {
        pc.removeWeaponBonus(owner, choice);
    }
}

