/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.graph.inst;

import javax.swing.event.EventListenerList;
import pcgen.base.graph.base.Edge;
import pcgen.base.graph.base.EdgeChangeEvent;
import pcgen.base.graph.base.Graph;
import pcgen.base.graph.base.GraphChangeListener;
import pcgen.base.graph.base.NodeChangeEvent;

public class GraphChangeSupport<N, ET extends Edge<N>> {
    private final EventListenerList listenerList;
    private final Graph<N, ET> source;

    public GraphChangeSupport(Graph<N, ET> sourceObject) {
        if (sourceObject == null) {
            throw new IllegalArgumentException("Source for GraphChangeSupport cannot be null");
        }
        this.source = sourceObject;
        this.listenerList = new EventListenerList();
    }

    public void addGraphChangeListener(GraphChangeListener<N, ET> listener) {
        this.listenerList.add(GraphChangeListener.class, listener);
    }

    public synchronized GraphChangeListener<N, ET>[] getGraphChangeListeners() {
        return (GraphChangeListener[])this.listenerList.getListeners(GraphChangeListener.class);
    }

    public void removeGraphChangeListener(GraphChangeListener<N, ET> listener) {
        this.listenerList.remove(GraphChangeListener.class, listener);
    }

    public void fireGraphEdgeChangeEvent(ET edge, int id) {
        GraphChangeListener[] listeners = (GraphChangeListener[])this.listenerList.getListeners(GraphChangeListener.class);
        EdgeChangeEvent<N, ET> ccEvent = null;
        block4: for (int i = listeners.length - 1; i >= 0; --i) {
            if (ccEvent == null) {
                ccEvent = new EdgeChangeEvent<N, ET>(this.source, edge, id);
            }
            switch (ccEvent.getID()) {
                case 0: {
                    listeners[i].edgeAdded(ccEvent);
                    continue block4;
                }
                case 1: {
                    listeners[i].edgeRemoved(ccEvent);
                    continue block4;
                }
            }
        }
    }

    public void fireGraphNodeChangeEvent(N node, int id) {
        GraphChangeListener[] listeners = (GraphChangeListener[])this.listenerList.getListeners(GraphChangeListener.class);
        NodeChangeEvent<N> ccEvent = null;
        block4: for (int i = listeners.length - 1; i >= 0; --i) {
            if (ccEvent == null) {
                ccEvent = new NodeChangeEvent<N>(this.source, node, id);
            }
            switch (ccEvent.getID()) {
                case 0: {
                    listeners[i].nodeAdded(ccEvent);
                    continue block4;
                }
                case 1: {
                    listeners[i].nodeRemoved(ccEvent);
                    continue block4;
                }
            }
        }
    }
}

