/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.lang;

import java.util.Collection;
import java.util.Comparator;
import java.util.StringTokenizer;

public final class StringUtil {
    public static final Comparator<String> CASE_SENSITIVE_ORDER = new Comparator<String>(){

        @Override
        public int compare(String str1, String str2) {
            return str1.compareTo(str2);
        }
    };

    private StringUtil() {
    }

    public static String join(Collection<?> collection, String separator) {
        return StringUtil.joinToStringBuilder(collection, separator).toString();
    }

    public static StringBuilder joinToStringBuilder(Collection<?> collection, String separator) {
        if (collection == null) {
            return new StringBuilder();
        }
        StringBuilder result = new StringBuilder(collection.size() * 10);
        boolean needjoin = false;
        for (Object obj : collection) {
            if (needjoin) {
                result.append(separator);
            }
            needjoin = true;
            result.append(obj.toString());
        }
        return result;
    }

    public static String join(String[] stringArray, String separator) {
        if (stringArray == null) {
            return "";
        }
        StringBuilder result = new StringBuilder(stringArray.length * 10);
        boolean needjoin = false;
        for (String obj : stringArray) {
            if (needjoin) {
                result.append(separator);
            }
            needjoin = true;
            result.append(obj);
        }
        return result.toString();
    }

    public static String replaceAll(String original, String find, String replace) {
        int i;
        int startindex = original.indexOf(find);
        if (startindex < 0) {
            return original;
        }
        char[] working = original.toCharArray();
        StringBuilder sb = new StringBuilder(original.length() + replace.length());
        int currindex = 0;
        while (startindex > -1) {
            for (i = currindex; i < startindex; ++i) {
                sb.append(working[i]);
            }
            currindex = startindex;
            sb.append(replace);
            startindex = original.indexOf(find, currindex += find.length());
        }
        for (i = currindex; i < working.length; ++i) {
            sb.append(working[i]);
        }
        return sb.toString();
    }

    public static boolean hasBalancedParens(String string) {
        int level = 0;
        StringTokenizer st = new StringTokenizer(string, "()", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (")".equals(tok)) {
                --level;
            } else if ("(".equals(tok)) {
                ++level;
            }
            if (level >= 0) continue;
            return false;
        }
        return level == 0;
    }
}

