/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.ability;

import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Categorized;
import pcgen.cdom.base.Category;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.rules.persistence.token.PostDeferredToken;
import pcgen.util.Logging;

public class CategoryToken
extends AbstractNonEmptyToken<Ability>
implements CDOMPrimaryToken<Ability>,
PostDeferredToken<Ability> {
    private static final Class<AbilityCategory> ABILITY_CATEGORY_CLASS = AbilityCategory.class;

    public String getTokenName() {
        return "CATEGORY";
    }

    public ParseResult parseNonEmptyToken(LoadContext context, Ability ability, String value) {
        Category cat = (Category)context.getReferenceContext().silentlyGetConstructedCDOMObject(ABILITY_CATEGORY_CLASS, value);
        if (cat == null) {
            return new ParseResult.Fail("Cannot find Ability Category: " + value, context);
        }
        context.getReferenceContext().reassociateCategory(cat, (Categorized)ability);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Ability ability) {
        Category cat = (Category)context.getObjectContext().getObject((CDOMObject)ability, ObjectKey.ABILITY_CAT);
        if (cat == null) {
            return null;
        }
        return new String[]{cat.getKeyName()};
    }

    public Class<Ability> getTokenClass() {
        return Ability.class;
    }

    public boolean process(LoadContext context, Ability ability) {
        Category cat = (Category)ability.get(ObjectKey.ABILITY_CAT);
        if (cat == null) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Ability " + ability.getKeyName() + " did not have a Category specified.  " + "A Category is required for an Ability. " + "File was " + ability.getSourceURI()));
            return false;
        }
        if (cat.getParentCategory() != cat) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Ability " + ability.getKeyName() + " did not refer to a 'parent' Category, used: " + cat + ". A Parent Category is required for an Ability. " + "File was " + ability.getSourceURI()));
            return false;
        }
        return true;
    }

    public Class<Ability> getDeferredTokenClass() {
        return this.getTokenClass();
    }

    public int getPriority() {
        return 0;
    }
}

