/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.race;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.RaceSubType;
import pcgen.core.Race;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class RacesubtypeToken
extends AbstractTokenWithSeparator<Race>
implements CDOMPrimaryToken<Race> {
    public String getTokenName() {
        return "RACESUBTYPE";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, Race race, String value) {
        StringTokenizer tok = new StringTokenizer(value, "|");
        boolean first = true;
        while (tok.hasMoreTokens()) {
            String tokString = tok.nextToken();
            if (".CLEAR".equals(tokString)) {
                if (!first) {
                    return new ParseResult.Fail("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item: " + value, context);
                }
                context.getObjectContext().removeList((CDOMObject)race, ListKey.RACESUBTYPE);
            } else if (tokString.startsWith(".CLEAR.")) {
                String clearText = tokString.substring(7);
                context.getObjectContext().removeFromList((CDOMObject)race, ListKey.RACESUBTYPE, (Object)RaceSubType.getConstant((String)clearText));
            } else {
                context.getObjectContext().addToList((CDOMObject)race, ListKey.RACESUBTYPE, (Object)RaceSubType.getConstant((String)tokString));
            }
            first = false;
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Race race) {
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)race, ListKey.RACESUBTYPE);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Collection removedItems = changes.getRemoved();
        if (changes.includesGlobalClear()) {
            if (removedItems != null && !removedItems.isEmpty()) {
                context.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            list.add(".CLEAR");
        } else if (removedItems != null && !removedItems.isEmpty()) {
            list.add(".CLEAR." + StringUtil.join((Collection)removedItems, (String)"|.CLEAR."));
        }
        Collection added = changes.getAdded();
        if (added != null && !added.isEmpty()) {
            list.add(StringUtil.join((Collection)added, (String)"|"));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public Class<Race> getTokenClass() {
        return Race.class;
    }
}

